/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runtime.datasources;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.datasources.Datasource;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.datasources.Driver;
import org.wildfly.swarm.runtime.container.AbstractServerConfiguration;

public class DatasourcesConfiguration
extends AbstractServerConfiguration<DatasourcesFraction> {
    private PathAddress datasourcesAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});

    public DatasourcesConfiguration() {
        super(DatasourcesFraction.class);
    }

    public DatasourcesFraction defaultFraction() {
        return new DatasourcesFraction();
    }

    public List<ModelNode> getList(DatasourcesFraction fraction) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode node = new ModelNode();
        node.get("address").set(this.datasourcesAddress.toModelNode());
        node.get("operation").set("add");
        list.add(node);
        this.addDrivers(fraction, list);
        this.addDatasources(fraction, list);
        return list;
    }

    protected void addDrivers(DatasourcesFraction fraction, List<ModelNode> list) {
        for (Driver each : fraction.drivers()) {
            this.addDriver(each, list);
        }
    }

    protected void addDriver(Driver driver, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.datasourcesAddress.append("jdbc-driver", driver.name()).toModelNode());
        node.get("operation").set("add");
        node.get("driver-name").set(driver.name());
        if (driver.datasourceClassName() != null) {
            node.get("driver-datasource-class-name").set(driver.datasourceClassName());
        }
        if (driver.xaDatasourceClassName() != null) {
            node.get("driver-xa-datasource-class-name").set(driver.xaDatasourceClassName());
        }
        node.get("driver-module-name").set(driver.moduleName());
        if (driver.moduleSlot() != null) {
            node.get("module-slot").set(driver.moduleSlot());
        }
        list.add(node);
    }

    protected void addDatasources(DatasourcesFraction fraction, List<ModelNode> list) {
        for (Datasource each : fraction.datasources()) {
            this.addDatasource(each, list);
        }
    }

    protected void addDatasource(Datasource datasource, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.datasourcesAddress.append("data-source", datasource.name()).toModelNode());
        node.get("operation").set("add");
        node.get("enabled").set(true);
        node.get("jndi-name").set(datasource.jndiName());
        node.get("use-java-context").set(true);
        node.get("connection-url").set(datasource.connectionURL());
        node.get("driver-name").set(datasource.driver());
        if (datasource.userName() != null) {
            node.get("user-name").set(datasource.userName());
        }
        if (datasource.password() != null) {
            node.get("password").set(datasource.password());
        }
        list.add(node);
    }
}

