/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runtime.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.runtime.undertow.StaticResourceHandler;

public class StaticHandlerBuilder
implements HandlerBuilder {
    public String name() {
        return "static-content";
    }

    public Map<String, Class<?>> parameters() {
        HashMap params = new HashMap();
        params.put("base", String.class);
        return params;
    }

    public Set<String> requiredParameters() {
        return new HashSet<String>();
    }

    public String defaultParameter() {
        return "";
    }

    public HandlerWrapper build(Map<String, Object> map) {
        final String base = (String)map.get("base");
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler next) {
                HttpHandler cur = next;
                cur = base != null ? new StaticResourceHandler((ResourceManager)new ClassPathResourceManager(ClassLoader.getSystemClassLoader(), base), cur) : new StaticResourceHandler((ResourceManager)new ClassPathResourceManager(ClassLoader.getSystemClassLoader()), cur);
                try {
                    Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.bootstrap"));
                    cur = new StaticResourceHandler((ResourceManager)new ClassPathResourceManager((ClassLoader)module.getClassLoader()), cur);
                }
                catch (ModuleLoadException module) {
                    // empty catch block
                }
                Path f = Paths.get(System.getProperty("user.dir"), "target", "classes");
                if (base != null) {
                    f = f.resolve(base);
                }
                if (Files.exists(f, new LinkOption[0])) {
                    cur = new StaticResourceHandler((ResourceManager)new FileResourceManager(f.toFile(), 1024L), cur);
                }
                f = Paths.get(System.getProperty("user.dir"), "src", "main", "webapp");
                if (base != null) {
                    f = f.resolve(base);
                }
                if (Files.exists(f, new LinkOption[0])) {
                    cur = new StaticResourceHandler((ResourceManager)new FileResourceManager(f.toFile(), 1024L), cur);
                }
                f = Paths.get(System.getProperty("user.dir"), "src", "main", "resources");
                if (base != null) {
                    f = f.resolve(base);
                }
                if (Files.exists(f, new LinkOption[0])) {
                    cur = new StaticResourceHandler((ResourceManager)new FileResourceManager(f.toFile(), 1024L), cur);
                }
                return cur;
            }
        };
    }
}

