/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.observability;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Dependent
public class OpenTelemetryMetricsChatModelListener
implements ChatModelListener {
    private static final String MP_AI_METRIC_START_TIME_NAME = "MP_AI_METRIC_START_TIME";
    private static final String METRIC_CLIENT_TOKEN_USAGE_NAME = "gen_ai.client.token.usage";
    private static final String METRIC_CLIENT_OPERATION_DURATION_NAME = "gen_ai.client.operation.duration";
    private LongHistogram clientTokenUsage;
    private DoubleHistogram clientOperationDuration;
    @Inject
    private Meter meter;

    @PostConstruct
    private void init() {
        this.clientTokenUsage = this.meter.histogramBuilder(METRIC_CLIENT_TOKEN_USAGE_NAME).ofLongs().setDescription("Measures number of input and output tokens used").setExplicitBucketBoundariesAdvice(List.of(1L, 4L, 16L, 64L, 256L, 1024L, 4096L, 16384L, 65536L, 262144L, 0x100000L, 0x400000L, 0x1000000L, 0x4000000L)).build();
        this.clientOperationDuration = this.meter.histogramBuilder(METRIC_CLIENT_OPERATION_DURATION_NAME).setDescription("GenAI operation duration").setExplicitBucketBoundariesAdvice(List.of(0.01, 0.02, 0.04, 0.08, 0.16, 0.32, 0.64, 1.28, 2.56, 5.12, 10.24, 20.48, 40.96, 81.92)).setUnit("s").build();
    }

    public void onRequest(ChatModelRequestContext requestContext) {
        requestContext.attributes().put(MP_AI_METRIC_START_TIME_NAME, System.nanoTime());
    }

    public void onResponse(ChatModelResponseContext responseContext) {
        long endTime = System.nanoTime();
        long startTime = (Long)responseContext.attributes().get(MP_AI_METRIC_START_TIME_NAME);
        ChatModelRequest request = responseContext.request();
        ChatModelResponse response = responseContext.response();
        Attributes inputTokenCountAttributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"gen_ai.operation.name"), (Object)"chat", (AttributeKey)AttributeKey.stringKey((String)"gen_ai.request.model"), (Object)request.model(), (AttributeKey)AttributeKey.stringKey((String)"gen_ai.response.model"), (Object)response.model(), (AttributeKey)AttributeKey.stringKey((String)"gen_ai.token.type"), (Object)"input");
        this.clientTokenUsage.record((long)response.tokenUsage().inputTokenCount().intValue(), inputTokenCountAttributes);
        Attributes outputTokenCountAttributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"gen_ai.operation.name"), (Object)"chat", (AttributeKey)AttributeKey.stringKey((String)"gen_ai.request.model"), (Object)request.model(), (AttributeKey)AttributeKey.stringKey((String)"gen_ai.response.model"), (Object)response.model(), (AttributeKey)AttributeKey.stringKey((String)"gen_ai.token.type"), (Object)"output");
        this.clientTokenUsage.record((long)response.tokenUsage().outputTokenCount().intValue(), outputTokenCountAttributes);
        Attributes durationAttributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"gen_ai.operation.name"), (Object)"chat", (AttributeKey)AttributeKey.stringKey((String)"gen_ai.request.model"), (Object)request.model(), (AttributeKey)AttributeKey.stringKey((String)"gen_ai.response.model"), (Object)response.model());
        this.recordClientOperationDuration(startTime, endTime, durationAttributes);
    }

    public void onError(ChatModelErrorContext errorContext) {
        long endTime = System.nanoTime();
        long startTime = (Long)errorContext.attributes().get(MP_AI_METRIC_START_TIME_NAME);
        ChatModelRequest request = errorContext.request();
        ChatModelResponse response = errorContext.partialResponse();
        StringBuilder sb = new StringBuilder().append(errorContext.error().getClass().getName());
        AiMessage aiMessage = errorContext.partialResponse().aiMessage();
        if (aiMessage != null) {
            sb.append(";").append(aiMessage.text());
        }
        Attributes durationAttributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"gen_ai.operation.name"), (Object)"chat", (AttributeKey)AttributeKey.stringKey((String)"gen_ai.request.model"), (Object)request.model(), (AttributeKey)AttributeKey.stringKey((String)"gen_ai.response.model"), (Object)response.model(), (AttributeKey)AttributeKey.stringKey((String)"error.type"), (Object)sb.toString());
        this.recordClientOperationDuration(startTime, endTime, durationAttributes);
    }

    private void recordClientOperationDuration(long startTime, long endTime, Attributes attributes) {
        this.clientOperationDuration.record((double)TimeUnit.SECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS), attributes);
    }
}

