/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import io.smallrye.llm.core.langchain4j.core.config.spi.LLMConfig;
import io.smallrye.llm.core.langchain4j.core.config.spi.ProducerFunction;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.extension.ai.injection.AILogger;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;

public class WildFlyLLMConfig
implements LLMConfig {
    private static final Set<String> beanNames = new HashSet<String>();
    private static final Map<String, Object> beanData = new HashMap<String, Object>();
    private static final String BEAN_VALUE = "defined_bean_value";
    private static final String BEAN_CLASS = "defined_bean_class";
    private static final String CLASS = "class";
    private static final String SCOPE = "scope";

    public static void registerBean(String name, Object value, Class<?> type) {
        beanNames.add(name);
        beanData.put(LLMConfig.getBeanPropertyName((String)name, (String)BEAN_VALUE), value);
        beanData.put(LLMConfig.getBeanPropertyName((String)name, (String)BEAN_CLASS), type);
        beanData.put(LLMConfig.getBeanPropertyName((String)name, (String)CLASS), type.getName());
        beanData.put(LLMConfig.getBeanPropertyName((String)name, (String)SCOPE), ApplicationScoped.class.getName());
    }

    public void init() {
    }

    public Set<String> getBeanNames() {
        return Collections.unmodifiableSet(beanNames);
    }

    public <T> T getBeanPropertyValue(String beanName, String propertyName, Class<T> type) {
        if ("defined_bean_producer".equals(propertyName)) {
            final Class expectedType = (Class)beanData.get(LLMConfig.getBeanPropertyName((String)beanName, (String)BEAN_CLASS));
            if (ChatLanguageModel.class.isAssignableFrom(expectedType) || StreamingChatLanguageModel.class.isAssignableFrom(expectedType)) {
                return (T)new ProducerFunction<Object>(){

                    public Object produce(Instance<Object> lookup, String beanName) {
                        WildFlyChatModelConfig config = (WildFlyChatModelConfig)beanData.get(LLMConfig.getBeanPropertyName((String)beanName, (String)WildFlyLLMConfig.BEAN_VALUE));
                        List<Object> listeners = config.isObservable() ? lookup.select(ChatModelListener.class, new Annotation[0]).handlesStream().map(Instance.Handle::get).collect(Collectors.toList()) : Collections.emptyList();
                        if (ChatLanguageModel.class.isAssignableFrom(expectedType) && !config.isStreaming()) {
                            return config.createLanguageModel(listeners);
                        }
                        if (StreamingChatLanguageModel.class.isAssignableFrom(expectedType) && config.isStreaming()) {
                            return config.createStreamingLanguageModel(listeners);
                        }
                        throw AILogger.ROOT_LOGGER.incorrectLLMConfiguration(beanName, expectedType.getName(), config.isStreaming());
                    }
                };
            }
            return (T)new ProducerFunction<Object>(){

                public Object produce(Instance<Object> lookup, String beanName) {
                    return beanData.get(LLMConfig.getBeanPropertyName((String)beanName, (String)WildFlyLLMConfig.BEAN_VALUE));
                }
            };
        }
        return (T)beanData.get(LLMConfig.getBeanPropertyName((String)beanName, (String)propertyName));
    }

    public Set<String> getPropertyNamesForBean(String beanName) {
        return Collections.emptySet();
    }
}

