/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.AILogger;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.service.capture.ValueExecutorRegistry;
import org.wildfly.subsystem.resource.ResourceDescriptor;

public class ChatModelConnectionCheckerOperationHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "chat";
    private final ValueExecutorRegistry<String, WildFlyChatModelConfig> registry;

    public static void register(ManagementResourceRegistration registration, ResourceDescriptor descriptor, ValueExecutorRegistry<String, WildFlyChatModelConfig> registry) {
        registration.registerOperationHandler((OperationDefinition)SimpleOperationDefinitionBuilder.of((String)OPERATION_NAME, (ResourceDescriptionResolver)descriptor.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{AIAttributeDefinitions.USER_MESSAGE}).setReplyType(ModelType.STRING).setRuntimeOnly().setReadOnly().addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).build(), (OperationStepHandler)new ChatModelConnectionCheckerOperationHandler(registry));
    }

    ChatModelConnectionCheckerOperationHandler(ValueExecutorRegistry<String, WildFlyChatModelConfig> registry) {
        this.registry = registry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String userMessage = AIAttributeDefinitions.USER_MESSAGE.resolveModelAttribute(context, operation).asString();
        FunctionExecutor executor = this.registry.getExecutor((Object)context.getCurrentAddressValue());
        if (executor == null) {
            throw AILogger.ROOT_LOGGER.chatLanguageModelServiceUnavailable(context.getCurrentAddressValue());
        }
        ModelNode answer = (ModelNode)executor.execute(chatLanguageModelConfig -> {
            AILogger.ROOT_LOGGER.debug("About to execute a chat call to the LLM with the following user message: " + userMessage);
            String response = chatLanguageModelConfig.createLanguageModel(Collections.emptyList()).generate(userMessage);
            AILogger.ROOT_LOGGER.debug("This is the answer I got: " + response);
            return new ModelNode(response);
        });
        context.getResult().set(answer);
    }
}

