/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.embedding.model;

import dev.langchain4j.model.embedding.EmbeddingModel;
import java.util.function.Supplier;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.ai.AILogger;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.embedding.model.InMemoryEmbeddingModelProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class InMemoryEmbeddingModelProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String moduleName = ModuleIdentifierUtil.canonicalModuleIdentifier((String)InMemoryEmbeddingModelProviderRegistrar.EMBEDDING_MODULE.resolveModelAttribute(context, model).asStringOrNull());
        final String embeddingModelClassName = InMemoryEmbeddingModelProviderRegistrar.EMBEDDING_MODEL_CLASS.resolveModelAttribute(context, model).asStringOrNull();
        Supplier<EmbeddingModel> factory = new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                try {
                    ModuleClassLoader moduleCL = Module.getCallerModuleLoader().loadModule(moduleName).getClassLoader();
                    Thread.currentThread().setContextClassLoader((ClassLoader)moduleCL);
                    EmbeddingModel embeddingModel = (EmbeddingModel)moduleCL.loadClass(embeddingModelClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    return embeddingModel;
                }
                catch (Exception e) {
                    AILogger.ROOT_LOGGER.error("Couldn't load EmbeddingModel " + e.getMessage(), e);
                    throw new RuntimeException(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(tccl);
                }
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.EMBEDDING_MODEL_PROVIDER_CAPABILITY, (Supplier)factory).blocking()).asActive()).build();
    }
}

