/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.embedding.store;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.embedding.store.InMemoryEmbeddingStoreProviderServiceConfigurator;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class InMemoryEmbeddingStoreProviderRegistrar
implements ChildResourceDefinitionRegistrar {
    protected static final SimpleAttributeDefinition STORE_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, false).setXmlName("path")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).build();
    protected static final SimpleAttributeDefinition STORE_RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setXmlName("relative-to")).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setCapabilityReference(PathManager.PATH_SERVICE_DESCRIPTOR.getName())).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(STORE_PATH, STORE_RELATIVE_TO);
    private final ResourceRegistration registration = ResourceRegistration.of((PathElement)PATH);
    private final ResourceDescriptor descriptor;
    static final String NAME = "in-memory-embedding-store";
    public static final PathElement PATH = PathElement.pathElement((String)"in-memory-embedding-store");

    public InMemoryEmbeddingStoreProviderRegistrar(ParentResourceDescriptionResolver parentResolver) {
        this.descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)parentResolver.createChildResolver(PATH)).addCapability(Capabilities.EMBEDDING_STORE_PROVIDER_CAPABILITY)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new InMemoryEmbeddingStoreProviderServiceConfigurator()))).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)this.descriptor.getResourceDescriptionResolver()).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(definition);
        if (context.getPathManager().isPresent()) {
            ResolvePathHandler resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)((PathManager)context.getPathManager().get())).setRelativeToAttribute((AttributeDefinition)STORE_RELATIVE_TO).setPathAttribute((AttributeDefinition)STORE_PATH).build();
            resourceRegistration.registerOperationHandler(resolvePathHandler.getOperationDefinition(), (OperationStepHandler)resolvePathHandler);
        }
        ManagementResourceRegistrar.of((ResourceDescriptor)this.descriptor).register(resourceRegistration);
        return resourceRegistration;
    }
}

