/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.embedding.store;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.neo4j.Neo4jEmbeddingStore;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.embedding.store.Neo4jEmbeddingStoreProviderRegistrar;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class Neo4jEmbeddingStoreProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String boltUrl = Neo4jEmbeddingStoreProviderRegistrar.BOLT_URL.resolveModelAttribute(context, model).asString();
        final String databaseName = Neo4jEmbeddingStoreProviderRegistrar.DATABASE_NAME.resolveModelAttribute(context, model).asStringOrNull();
        final Integer dimension = Neo4jEmbeddingStoreProviderRegistrar.DIMENSION.resolveModelAttribute(context, model).asIntOrNull();
        final String embeddingProperty = Neo4jEmbeddingStoreProviderRegistrar.EMBEDDING_PROPERTY.resolveModelAttribute(context, model).asStringOrNull();
        final String idProperty = Neo4jEmbeddingStoreProviderRegistrar.ID_PROPERTY.resolveModelAttribute(context, model).asStringOrNull();
        final String indexName = Neo4jEmbeddingStoreProviderRegistrar.INDEX_NAME.resolveModelAttribute(context, model).asStringOrNull();
        final String label = Neo4jEmbeddingStoreProviderRegistrar.LABEL.resolveModelAttribute(context, model).asStringOrNull();
        final String metadataPrefix = Neo4jEmbeddingStoreProviderRegistrar.METADATA_PREFIX.resolveModelAttribute(context, model).asStringOrNull();
        final String retrievalQuery = Neo4jEmbeddingStoreProviderRegistrar.RETRIEVAL_QUERY.resolveModelAttribute(context, model).asStringOrNull();
        final String textProperty = Neo4jEmbeddingStoreProviderRegistrar.TEXT_PROPERTY.resolveModelAttribute(context, model).asStringOrNull();
        final String userName = Neo4jEmbeddingStoreProviderRegistrar.USERNAME.resolveModelAttribute(context, model).asString();
        final ServiceDependency credentialRef = ServiceDependency.from((org.wildfly.service.ServiceDependency)CredentialReference.getCredentialSourceDependency((OperationContext)context, (AttributeDefinition)Neo4jEmbeddingStoreProviderRegistrar.CREDENTIAL_REFERENCE, (ModelNode)model));
        Supplier<EmbeddingStore<TextSegment>> factory = new Supplier<EmbeddingStore<TextSegment>>(){

            @Override
            public EmbeddingStore<TextSegment> get() {
                String password;
                try {
                    password = String.valueOf(((ClearPassword)((PasswordCredential)((CredentialSource)credentialRef.get()).getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return Neo4jEmbeddingStore.builder().withBasicAuth(boltUrl, userName, password).dimension(dimension.intValue()).databaseName(databaseName).embeddingProperty(embeddingProperty).idProperty(idProperty).indexName(indexName).label(label).metadataPrefix(metadataPrefix).retrievalQuery(retrievalQuery).textProperty(textProperty).build();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.EMBEDDING_STORE_PROVIDER_CAPABILITY, (Supplier)factory).requires((Consumer)credentialRef)).blocking()).asActive()).build();
    }
}

