/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.embedding.store;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.weaviate.WeaviateEmbeddingStore;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.embedding.store.WeaviateEmbeddingStoreProviderRegistrar;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

class WeaviateEmbeddingStoreProviderServiceConfigurator
implements ResourceServiceConfigurator {
    WeaviateEmbeddingStoreProviderServiceConfigurator() {
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String objectClass = WeaviateEmbeddingStoreProviderRegistrar.OBJECT_CLASS.resolveModelAttribute(context, model).asString();
        final String scheme = WeaviateEmbeddingStoreProviderRegistrar.SSL_ENABLED.resolveModelAttribute(context, model).asBoolean() ? "https" : "http";
        String socketBindingName = WeaviateEmbeddingStoreProviderRegistrar.STORE_BINDING.resolveModelAttribute(context, model).asString();
        final Boolean avoidDups = WeaviateEmbeddingStoreProviderRegistrar.AVOID_DUPS.resolveModelAttribute(context, model).asBooleanOrNull();
        final String consistencyLevel = WeaviateEmbeddingStoreProviderRegistrar.CONSISTENCY_LEVEL.resolveModelAttribute(context, model).asStringOrNull();
        final List metadataKeys = WeaviateEmbeddingStoreProviderRegistrar.METADATA.unwrap((ExpressionResolver)context, model);
        final ServiceDependency outboundSocketBinding = ServiceDependency.on((UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR, (String)socketBindingName);
        Supplier<EmbeddingStore<TextSegment>> factory = new Supplier<EmbeddingStore<TextSegment>>(){

            @Override
            public EmbeddingStore<TextSegment> get() {
                return WeaviateEmbeddingStore.builder().scheme(scheme).host(((OutboundSocketBinding)outboundSocketBinding.get()).getUnresolvedDestinationAddress()).port(Integer.valueOf(((OutboundSocketBinding)outboundSocketBinding.get()).getDestinationPort())).objectClass(objectClass).avoidDups(avoidDups).metadataKeys((Collection)metadataKeys).consistencyLevel(consistencyLevel).build();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.EMBEDDING_STORE_PROVIDER_CAPABILITY, (Supplier)factory).requires((Consumer)outboundSocketBinding)).blocking()).asActive()).build();
    }
}

