/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.rag.retriever;

import dev.langchain4j.rag.content.retriever.WebSearchContentRetriever;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.google.customsearch.GoogleCustomWebSearchEngine;
import dev.langchain4j.web.search.tavily.TavilyWebSearchEngine;
import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.rag.retriever.EmbeddingStoreContentRetrieverProviderRegistrar;
import org.wildfly.extension.ai.rag.retriever.WebSearchContentContentRetrieverProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class WebSearchContentRetrieverProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode googleConfiguration = WebSearchContentContentRetrieverProviderRegistrar.GOOGLE_SEARCH_ENGINE.resolveModelAttribute(context, model);
        ModelNode tavilyConfiguration = WebSearchContentContentRetrieverProviderRegistrar.TAVILY_SEARCH_ENGINE.resolveModelAttribute(context, model);
        Integer maxResults = EmbeddingStoreContentRetrieverProviderRegistrar.MAX_RESULTS.resolveModelAttribute(context, model).asIntOrNull();
        Object engine = googleConfiguration.isDefined() ? GoogleCustomWebSearchEngine.builder().apiKey(googleConfiguration.get(AIAttributeDefinitions.API_KEY.getName()).asStringOrNull()).csi(googleConfiguration.get("custom-search-id").asStringOrNull()).includeImages(googleConfiguration.get("include-images").asBooleanOrNull()).logRequests(googleConfiguration.get(AIAttributeDefinitions.LOG_REQUESTS.getName()).asBooleanOrNull()).logResponses(googleConfiguration.get(AIAttributeDefinitions.LOG_RESPONSES.getName()).asBooleanOrNull()).maxRetries(googleConfiguration.get("max-retries").asIntOrNull()).siteRestrict(googleConfiguration.get("site-restrict").asBooleanOrNull()).timeout(Duration.ofMillis(googleConfiguration.get(AIAttributeDefinitions.CONNECT_TIMEOUT.getName()).asLong())).build() : TavilyWebSearchEngine.builder().apiKey(tavilyConfiguration.get(AIAttributeDefinitions.API_KEY.getName()).asStringOrNull()).baseUrl(tavilyConfiguration.get(AIAttributeDefinitions.BASE_URL.getName()).asString()).excludeDomains(StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)tavilyConfiguration.get("exclude-domains"))).includeAnswer(tavilyConfiguration.get("include-answer").asBooleanOrNull()).includeDomains(StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)tavilyConfiguration.get("include-domains"))).includeRawContent(tavilyConfiguration.get("include-raw-content").asBooleanOrNull()).searchDepth(tavilyConfiguration.get("search-depth").asStringOrNull()).timeout(Duration.ofMillis(tavilyConfiguration.get(AIAttributeDefinitions.CONNECT_TIMEOUT.getName()).asLong())).build();
        Supplier<WebSearchContentRetriever> factory = new Supplier<WebSearchContentRetriever>((WebSearchEngine)engine, maxResults){
            final /* synthetic */ WebSearchEngine val$engine;
            final /* synthetic */ Integer val$maxResults;
            {
                this.val$engine = webSearchEngine;
                this.val$maxResults = n;
            }

            @Override
            public WebSearchContentRetriever get() {
                return new WebSearchContentRetriever(this.val$engine, this.val$maxResults);
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.CONTENT_RETRIEVER_PROVIDER_CAPABILITY, (Supplier)factory).blocking()).asActive()).build();
    }
}

