/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai;

import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AIAttributeDefinitions {
    public static final SimpleAttributeDefinition API_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("api-key", ModelType.STRING, false).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition BASE_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("base-url", ModelType.STRING, false).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition BOLT_URL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bolt-url", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CONNECT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connect-timeout", ModelType.LONG, true).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
    public static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((boolean)true, (boolean)true).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).build();
    public static final SimpleAttributeDefinition FREQUENCY_PENALTY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("frequency-penalty", ModelType.DOUBLE, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition LOG_REQUESTS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"log-requests", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition LOG_RESPONSES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"log-responses", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_RETRIES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retries", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_TOKEN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-token", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(1000))).build();
    public static final SimpleAttributeDefinition MODEL_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("model-name", ModelType.STRING, false).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition PRESENCE_PENALTY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("presence-penalty", ModelType.DOUBLE, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition RESPONSE_FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("response-format", ModelType.STRING, true).setValidator((ParameterValidator)EnumValidator.create(ResponseFormat.class))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SSL_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ssl-enabled", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition STREAMING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("streaming", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    public static final SimpleAttributeDefinition TEMPERATURE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("temperature", ModelType.DOUBLE, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TOP_P = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("top-p", ModelType.DOUBLE, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition USER_MESSAGE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("user-message", ModelType.STRING, false).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition USERNAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("username", ModelType.STRING, false).setAllowExpression(true)).build();

    public static enum ResponseFormat {
        JSON,
        TEXT;


        public static boolean isJson(String format) {
            return format != null && JSON == ResponseFormat.valueOf(format);
        }
    }
}

