/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.chat;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.ai.AIAttributeDefinitions;
import org.wildfly.extension.ai.Capabilities;
import org.wildfly.extension.ai.chat.ChatModelConnectionCheckerOperationHandler;
import org.wildfly.extension.ai.chat.GithubModelChatModelProviderServiceConfigurator;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;
import org.wildfly.service.capture.ValueExecutorRegistry;
import org.wildfly.service.capture.ValueRegistry;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class GithubModelChatLanguageModelProviderRegistrar
implements ChildResourceDefinitionRegistrar {
    public static final PropertiesAttributeDefinition CUSTOM_HEADERS = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("custom-headers", true).setAllowExpression(true)).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser(null, "header", false))).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller(null, "header", false))).build();
    public static final SimpleAttributeDefinition ENDPOINT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"endpoint", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition LOG_REQUESTS_RESPONSES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"log-requests-responses", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SEED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("seed", ModelType.LONG, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SERVICE_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("service-version", ModelType.STRING, true).setAllowedValues(new String[]{"2024-05-01-preview", "2024-05-01-preview"})).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition USER_AGENT_SUFFIX = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("user-agent-suffix", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(AIAttributeDefinitions.API_KEY, AIAttributeDefinitions.CONNECT_TIMEOUT, CUSTOM_HEADERS, ENDPOINT, AIAttributeDefinitions.FREQUENCY_PENALTY, LOG_REQUESTS_RESPONSES, AIAttributeDefinitions.MAX_RETRIES, AIAttributeDefinitions.MAX_TOKEN, AIAttributeDefinitions.MODEL_NAME, AIAttributeDefinitions.PRESENCE_PENALTY, AIAttributeDefinitions.RESPONSE_FORMAT, SEED, SERVICE_VERSION, AIAttributeDefinitions.STREAMING, AIAttributeDefinitions.TEMPERATURE, AIAttributeDefinitions.TOP_P, USER_AGENT_SUFFIX);
    private final ResourceRegistration registration;
    private final ResourceDescriptor descriptor;
    static final String NAME = "github-chat-model";
    public static final PathElement PATH = PathElement.pathElement((String)"github-chat-model");
    private final ValueExecutorRegistry<String, WildFlyChatModelConfig> registry = ValueExecutorRegistry.newInstance();

    public GithubModelChatLanguageModelProviderRegistrar(ParentResourceDescriptionResolver parentResolver) {
        this.registration = ResourceRegistration.of((PathElement)PATH);
        this.descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)parentResolver.createChildResolver(PATH)).addCapability(Capabilities.CHAT_MODEL_PROVIDER_CAPABILITY)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new GithubModelChatModelProviderServiceConfigurator((ValueRegistry<String, WildFlyChatModelConfig>)this.registry)))).build();
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)this.descriptor.getResourceDescriptionResolver()).build();
        ManagementResourceRegistration resourceRegistration = parent.registerSubModel(definition);
        ChatModelConnectionCheckerOperationHandler.register(resourceRegistration, this.descriptor, this.registry);
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"dev.langchain4j.github"), RuntimePackageDependency.required((String)"com.azure")});
        ManagementResourceRegistrar.of((ResourceDescriptor)this.descriptor).register(resourceRegistration);
        return resourceRegistration;
    }
}

