/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jberet.repository.JobRepository;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadFactoryResourceDefinition;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.UnboundedQueueThreadPoolResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet.DefaultValueService;
import org.wildfly.extension.batch.jberet.NameAttributeMarshaller;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.deployment.BatchDependencyProcessor;
import org.wildfly.extension.batch.jberet.deployment.BatchDeploymentDescriptorParser_1_0;
import org.wildfly.extension.batch.jberet.deployment.BatchDeploymentResourceProcessor;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentProcessor;
import org.wildfly.extension.batch.jberet.job.repository.InMemoryJobRepositoryDefinition;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryDefinition;

public class BatchSubsystemDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "batch-jberet";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"batch-jberet");
    static final String THREAD_POOL = "thread-pool";
    static final String THREAD_FACTORY = "thread-factory";
    static final PathElement THREAD_POOL_PATH = PathElement.pathElement((String)"thread-pool");
    static final SimpleAttributeDefinition DEFAULT_JOB_REPOSITORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-job-repository", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).setAttributeGroup("environment")).setAttributeMarshaller((AttributeMarshaller)NameAttributeMarshaller.INSTANCE)).setCapabilityReference(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), Capabilities.DEFAULT_JOB_REPOSITORY_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition DEFAULT_THREAD_POOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-thread-pool", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).setAttributeGroup("environment")).setAttributeMarshaller((AttributeMarshaller)NameAttributeMarshaller.INSTANCE)).setRestartAllServices()).build();
    private final boolean registerRuntimeOnly;

    BatchSubsystemDefinition(boolean registerRuntimeOnly) {
        super(SUBSYSTEM_PATH, (ResourceDescriptionResolver)BatchResourceDescriptionResolver.getResourceDescriptionResolver(), (OperationStepHandler)BatchSubsystemAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new InMemoryJobRepositoryDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new JdbcJobRepositoryDefinition());
        UnboundedQueueThreadPoolResourceDefinition threadPoolResource = UnboundedQueueThreadPoolResourceDefinition.create((PathElement)THREAD_POOL_PATH, (ThreadFactoryResolver)BatchThreadFactoryResolver.INSTANCE, (ServiceName)BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME, (boolean)this.registerRuntimeOnly);
        resourceRegistration.registerSubModel((ResourceDefinition)threadPoolResource);
        ThreadFactoryResourceDefinition threadFactoryResource = new ThreadFactoryResourceDefinition();
        resourceRegistration.registerSubModel((ResourceDefinition)threadFactoryResource);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DEFAULT_JOB_REPOSITORY, DEFAULT_THREAD_POOL});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_JOB_REPOSITORY, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_THREAD_POOL, null, (OperationStepHandler)writeHandler);
    }

    private static class BatchThreadFactoryResolver
    extends ThreadFactoryResolver.SimpleResolver {
        static final BatchThreadFactoryResolver INSTANCE = new BatchThreadFactoryResolver();

        private BatchThreadFactoryResolver() {
            super(ThreadsServices.FACTORY);
        }

        protected String getThreadGroupName(String threadPoolName) {
            return "Batch Thread";
        }
    }

    static class BatchSubsystemAdd
    extends AbstractAddStepHandler {
        static final BatchSubsystemAdd INSTANCE = new BatchSubsystemAdd();

        private BatchSubsystemAdd() {
            super(Stream.of(Capabilities.DEFAULT_JOB_REPOSITORY_CAPABILITY, Capabilities.DEFAULT_THREAD_POOL_CAPABILITY).collect(Collectors.toSet()), new AttributeDefinition[]{DEFAULT_JOB_REPOSITORY, DEFAULT_THREAD_POOL});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ModelNode defaultThreadPool;
            final boolean rcPresent = context.getOriginalRootResource().hasChild(PathElement.pathElement((String)"subsystem", (String)"request-controller"));
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                public void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.STRUCTURE, 2587, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(BatchDeploymentDescriptorParser_1_0.ROOT_ELEMENT, BatchDeploymentDescriptorParser_1_0.ATTACHMENT_KEY, (JBossAllXMLParser)new BatchDeploymentDescriptorParser_1_0()));
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.DEPENDENCIES, 6912, (DeploymentUnitProcessor)new BatchDependencyProcessor());
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.POST_MODULE, 12544, (DeploymentUnitProcessor)new BatchEnvironmentProcessor(rcPresent));
                    processorTarget.addDeploymentProcessor(BatchSubsystemDefinition.NAME, Phase.INSTALL, 8304, (DeploymentUnitProcessor)new BatchDeploymentResourceProcessor(BatchSubsystemDefinition.NAME));
                }
            }, OperationContext.Stage.RUNTIME);
            ServiceTarget target = context.getServiceTarget();
            ModelNode defaultJobRepository = DEFAULT_JOB_REPOSITORY.resolveModelAttribute(context, model);
            if (defaultJobRepository.isDefined()) {
                String name = defaultJobRepository.asString();
                DefaultValueService service = DefaultValueService.create();
                target.addService(context.getCapabilityServiceName(Capabilities.DEFAULT_JOB_REPOSITORY_CAPABILITY.getName(), JobRepository.class), service).addDependency(context.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), name, JobRepository.class), JobRepository.class, service.getInjector()).install();
            }
            if ((defaultThreadPool = DEFAULT_THREAD_POOL.resolveModelAttribute(context, model)).isDefined()) {
                String name = defaultThreadPool.asString();
                DefaultValueService service = DefaultValueService.create();
                target.addService(context.getCapabilityServiceName(Capabilities.DEFAULT_THREAD_POOL_CAPABILITY.getName(), ExecutorService.class), service).addDependency(BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME.append(new String[]{name}), ExecutorService.class, service.getInjector()).install();
            }
        }
    }
}

