/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.batch.jberet.Attribute;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet.Element;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentMetaData;

public class BatchDeploymentDescriptorParser_1_0
implements XMLStreamConstants,
JBossAllXMLParser<BatchEnvironmentMetaData> {
    public static final AttachmentKey<BatchEnvironmentMetaData> ATTACHMENT_KEY = AttachmentKey.create(BatchEnvironmentMetaData.class);
    public static final String NAMESPACE = "urn:jboss:batch-jberet:1.0";
    public static final QName ROOT_ELEMENT = new QName("urn:jboss:batch-jberet:1.0", "batch");
    private static final String JNDI_NAME = "datasource-jndi";

    public BatchEnvironmentMetaData parse(XMLExtendedStreamReader reader, DeploymentUnit deploymentUnit) throws XMLStreamException {
        JobRepository jobRepository = null;
        ExecutorService executorService = null;
        boolean empty = true;
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.JOB_REPOSITORY) {
                if (jobRepository != null) {
                    BatchLogger.LOGGER.multipleJobRepositoriesFound();
                } else {
                    jobRepository = this.parseJobRepository(reader, deploymentUnit);
                }
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            } else if (element == Element.THREAD_POOL) {
                String name = BatchDeploymentDescriptorParser_1_0.readRequiredAttribute(reader, Attribute.NAME);
                ServiceName serviceName = BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME.append(new String[]{name});
                ServiceController controller = deploymentUnit.getServiceRegistry().getRequiredService(serviceName);
                if (controller == null) {
                    BatchLogger.LOGGER.missingNamedService("thread-pool", name, deploymentUnit.getName());
                    return null;
                }
                executorService = (ExecutorService)controller.getValue();
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            } else {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            empty = false;
        }
        if (empty) {
            BatchLogger.LOGGER.debugf("An empty batch element in the deployment descriptor was found for %s.", deploymentUnit.getName());
            return null;
        }
        return new BatchEnvironmentMetaData(jobRepository, executorService);
    }

    private JobRepository parseJobRepository(XMLExtendedStreamReader reader, DeploymentUnit deploymentUnit) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.IN_MEMORY) {
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new InMemoryRepository();
            }
            if (element == Element.JDBC) {
                String value = BatchDeploymentDescriptorParser_1_0.readRequiredAttribute(reader, Attribute.JNDI_NAME);
                Properties configProperties = new Properties();
                configProperties.setProperty(JNDI_NAME, value);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return JdbcRepository.create((Properties)configProperties);
            }
            if (element == Element.NAMED) {
                String jobRepositoryName = BatchDeploymentDescriptorParser_1_0.readRequiredAttribute(reader, Attribute.NAME);
                CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                ServiceName serviceName = support.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), jobRepositoryName);
                ServiceController controller = deploymentUnit.getServiceRegistry().getRequiredService(serviceName);
                if (controller == null) {
                    BatchLogger.LOGGER.missingNamedService("job-repository", jobRepositoryName, deploymentUnit.getName());
                    return null;
                }
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return (JobRepository)controller.getValue();
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        BatchLogger.LOGGER.emptyJobRepositoryElement(deploymentUnit.getName());
        return null;
    }

    private static String readRequiredAttribute(XMLExtendedStreamReader reader, Attribute attribute) throws XMLStreamException {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute current = Attribute.forName(reader.getAttributeLocalName(i));
            if (current != attribute) continue;
            return reader.getAttributeValue(i);
        }
        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
    }
}

