/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Executor;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.alias.AeshAliasManager;
import org.aesh.command.alias.AliasCommand;
import org.aesh.command.alias.UnAliasCommand;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.export.ExportCommand;
import org.aesh.command.export.ExportCompletion;
import org.aesh.command.export.ExportManager;
import org.aesh.command.export.ExportPreProcessor;
import org.aesh.command.impl.AeshCommandResolver;
import org.aesh.command.impl.completer.AeshCompletionHandler;
import org.aesh.command.impl.invocation.AeshCommandInvocationBuilder;
import org.aesh.command.impl.registry.MutableCommandRegistryImpl;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.operator.OperatorType;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.MutableCommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.io.scanner.AnnotationDetector;
import org.aesh.io.scanner.CommandDefinitionReporter;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Console;
import org.aesh.readline.DefaultAeshContext;
import org.aesh.readline.ProcessManager;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.ShellImpl;
import org.aesh.readline.alias.AliasCompletion;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.alias.AliasPreProcessor;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.FileHistory;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.readline.util.FileAccessPermission;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.utils.Config;

public class ReadlineConsole
implements Console,
Consumer<Connection> {
    private AliasManager aliasManager;
    private Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings;
    private Prompt prompt;
    private List<Completion> completions;
    private Connection connection;
    private AeshCommandResolver<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> commandResolver;
    private AeshContext context;
    private Readline readline;
    private AeshCompletionHandler completionHandler;
    private CommandRuntime<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> runtime;
    private ProcessManager processManager;
    private ExportManager exportManager;
    private static List<Function<String, Optional<String>>> preProcessors = new ArrayList<Function<String, Optional<String>>>();
    private static final Logger LOGGER = LoggerUtil.getLogger(ReadlineConsole.class.getName());
    private volatile boolean running = false;
    private History history;
    private ShellImpl shell;
    private final EnumMap<ReadlineFlag, Integer> readlineFlags = new EnumMap(ReadlineFlag.class);

    public ReadlineConsole(Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> givenSettings) {
        this.settings = givenSettings == null ? SettingsBuilder.builder().build() : givenSettings;
        this.commandResolver = this.settings.getScanForCommandPackages() == null || this.settings.getScanForCommandPackages().length == 0 ? new AeshCommandResolver<Command<? extends CommandInvocation>, CommandInvocation>(this.settings.commandRegistry()) : this.getCommandResolverThroughScan();
        this.addCompletion(new AeshCompletion());
        if (this.settings.connection() != null) {
            this.connection = this.settings.connection();
        }
        if (this.settings.exportEnabled()) {
            this.exportManager = new ExportManager(this.settings.exportFile(), this.settings.exportUsesSystemEnvironment(), this.settings.exportListener());
            preProcessors.add(new ExportPreProcessor(this.exportManager));
            this.completions.add(new ExportCompletion(this.exportManager));
            if (this.commandResolver.getRegistry() != null && this.commandResolver.getRegistry() instanceof MutableCommandRegistry) {
                try {
                    ((MutableCommandRegistry)this.commandResolver.getRegistry()).addCommand(new ExportCommand(this.exportManager));
                }
                catch (CommandLineParserException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.settings.aliasEnabled()) {
            try {
                this.aliasManager = this.settings.aliasManager() != null ? this.settings.aliasManager() : new AeshAliasManager(this.settings.aliasFile(), this.settings.persistAlias(), this.commandResolver.getRegistry());
                preProcessors.add(new AliasPreProcessor(this.aliasManager));
                this.completions.add(new AliasCompletion(this.aliasManager, false));
                if (this.commandResolver.getRegistry() != null && this.commandResolver.getRegistry() instanceof MutableCommandRegistry) {
                    try {
                        ((MutableCommandRegistry)this.commandResolver.getRegistry()).addCommand(new AliasCommand(this.aliasManager));
                        ((MutableCommandRegistry)this.commandResolver.getRegistry()).addCommand(new UnAliasCommand(this.aliasManager));
                    }
                    catch (CommandLineParserException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.settings.isRedrawPromptOnInterrupt()) {
            this.readlineFlags.put(ReadlineFlag.NO_PROMPT_REDRAW_ON_INTR, Integer.MAX_VALUE);
        }
        this.context = new DefaultAeshContext(this.exportManager);
    }

    public void start() throws IOException {
        this.init();
        if (this.connection == null) {
            new TerminalConnection(Charset.defaultCharset(), this.settings.stdIn(), this.settings.stdOut(), this);
        } else {
            this.accept(this.connection);
        }
    }

    private void doStop(boolean closeConnection) {
        if (this.running) {
            this.running = false;
            if (this.history != null) {
                this.history.stop();
            }
            if (this.connection != null && closeConnection) {
                this.connection.close();
            }
            if (this.aliasManager != null && this.settings.persistAlias()) {
                this.aliasManager.persist();
            }
        }
    }

    @Override
    public void stop() {
        this.doStop(true);
    }

    @Override
    public boolean running() {
        return this.running;
    }

    @Override
    public void accept(Connection connection) {
        if (this.connection == null) {
            this.connection = connection;
        }
        connection.setCloseHandler(t -> this.doStop(false));
        if (!this.settings.isEchoCtrl()) {
            Attributes attr = connection.getAttributes();
            attr.setLocalFlag(Attributes.LocalFlag.ECHOCTL, false);
            connection.setAttributes(attr);
        }
        connection.setSignalHandler(t -> {
            if (this.settings.getInterruptHandler() != null) {
                this.settings.getInterruptHandler().accept(null);
            }
        });
        this.runtime = this.generateRuntime();
        this.read(this.connection, this.readline);
        this.processManager = new ProcessManager(this);
        this.connection.openBlocking();
    }

    private void init() {
        this.completionHandler = new AeshCompletionHandler(this.context);
        if (this.prompt == null) {
            this.prompt = new Prompt("");
        }
        this.history = this.settings.historyPersistent() ? new FileHistory(this.settings.historyFile(), this.settings.historySize(), this.buildPermission(this.settings.historyFilePermission()), this.settings.logging()) : new InMemoryHistory(this.settings.historySize());
        this.readline = new Readline(EditModeBuilder.builder(this.settings.mode()).create(), this.history, this.completionHandler);
        this.running = true;
    }

    @Override
    public void read() {
        this.read(this.connection, this.readline);
    }

    @Override
    public void read(Connection conn, Readline readline) {
        this.shell.printCollectedOutput();
        if (this.running) {
            readline.readline(conn, this.prompt, line -> {
                if (line != null && line.trim().length() > 0) {
                    this.shell.startCollectOutput();
                    this.processLine((String)line, conn);
                } else {
                    this.read(conn, readline);
                }
            }, this.completions, preProcessors, this.history, null, this.readlineFlags);
        } else {
            LOGGER.info("not running, returning");
            conn.close();
            if (this.settings.quitHandler() != null) {
                this.settings.quitHandler().quit();
            }
        }
    }

    private void processLine(String line, Connection conn) {
        try {
            Executor<? extends CommandInvocation> executor = this.runtime.buildExecutor(line);
            this.processManager.execute(executor, conn);
        }
        catch (CommandNotFoundException cnfe) {
            if (this.settings.commandNotFoundHandler() != null) {
                this.settings.commandNotFoundHandler().handleCommandNotFound(line, new ShellImpl(conn, this.readline));
            } else {
                conn.write(cnfe.getMessage() + Config.getLineSeparator());
            }
            this.read(conn, this.readline);
        }
        catch (IllegalArgumentException | CommandLineParserException | CommandValidatorException | OptionValidatorException e) {
            conn.write(e.getMessage() + Config.getLineSeparator());
            this.read(conn, this.readline);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got exception while starting new process", e);
            this.read(conn, this.readline);
        }
    }

    @Override
    public Prompt prompt() {
        return this.prompt;
    }

    @Override
    public void setPrompt(Prompt prompt) {
        if (prompt != null) {
            this.prompt = prompt;
        }
    }

    @Override
    public void setPrompt(String prompt) {
        if (prompt != null) {
            this.prompt = new Prompt(prompt);
        }
    }

    @Override
    public AeshContext context() {
        return this.context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String helpInfo(String commandName) {
        try (CommandContainer<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> commandContainer = this.commandResolver.resolveCommand(commandName);){
            if (commandContainer == null) return "";
            String string = commandContainer.printHelp(commandName);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void addCompletion(Completion completion) {
        if (this.completions == null) {
            this.completions = new ArrayList<Completion>();
        }
        this.completions.add(completion);
    }

    public void addCompletions(List<Completion> completions) {
        if (this.completions == null) {
            this.completions = new ArrayList<Completion>();
        }
        this.completions.addAll(completions);
    }

    private FileAccessPermission buildPermission(org.aesh.command.settings.FileAccessPermission historyFilePermission) {
        if (historyFilePermission == null) {
            return null;
        }
        FileAccessPermission perm = new FileAccessPermission();
        perm.setExecutable(historyFilePermission.isExecutable());
        perm.setExecutableOwnerOnly(historyFilePermission.isExecutableOwnerOnly());
        perm.setReadable(historyFilePermission.isReadable());
        perm.setReadableOwnerOnly(historyFilePermission.isReadableOwnerOnly());
        perm.setWritable(historyFilePermission.isWritable());
        perm.setWritableOwnerOnly(historyFilePermission.isWritableOwnerOnly());
        return perm;
    }

    private AeshCommandResolver<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> getCommandResolverThroughScan() {
        MutableCommandRegistryImpl registry = new MutableCommandRegistryImpl();
        CommandDefinitionReporter reporter = new CommandDefinitionReporter();
        AnnotationDetector detector = new AnnotationDetector(reporter);
        try {
            detector.detect(this.settings.getScanForCommandPackages());
            for (String command : reporter.getCommands()) {
                registry.addCommand(Class.forName(command));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "AnnotationDetector failed to scan for CommandDefinition annotations", e);
        }
        catch (ClassNotFoundException | CommandLineParserException e) {
            LOGGER.log(Level.WARNING, "Failed to load CommandDefinition class.", e);
        }
        return new AeshCommandResolver(registry);
    }

    private CommandRuntime<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> generateRuntime() {
        this.shell = new ShellImpl(this.connection, this.readline, this.settings.enableSearchInPaging());
        return AeshCommandRuntimeBuilder.builder().settings(this.settings).commandInvocationBuilder(new AeshCommandInvocationBuilder(this.shell, this)).aeshContext(this.context).operators(EnumSet.allOf(OperatorType.class)).build();
    }

    class AeshCompletion
    implements Completion<AeshCompleteOperation> {
        AeshCompletion() {
        }

        @Override
        public void complete(AeshCompleteOperation completeOperation) {
            ReadlineConsole.this.runtime.complete(completeOperation);
        }
    }
}

