/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import javax.net.SocketFactory;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;

public class SyslogAuditEndpoint
implements AuditEndpoint {
    private volatile boolean accepting = true;
    private final SyslogHandler syslogHandler;

    SyslogAuditEndpoint(Builder builder) throws IOException {
        SyslogHandler.Protocol protocol = builder.ssl ? SyslogHandler.Protocol.SSL_TCP : (builder.tcp ? SyslogHandler.Protocol.TCP : SyslogHandler.Protocol.UDP);
        this.syslogHandler = new SyslogHandler(Assert.checkNotNullParam("serverAddress", builder.serverAddress), builder.port, SyslogHandler.Facility.SECURITY, null, protocol, Assert.checkNotNullParam("hostName", builder.hostName));
        if (builder.tcp && builder.socketFactory != null) {
            this.syslogHandler.setOutputStream(new TcpOutputStream(builder.socketFactory, builder.serverAddress, builder.port){});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(EventPriority t, String u) throws IOException {
        if (!this.accepting) {
            return;
        }
        SyslogAuditEndpoint syslogAuditEndpoint = this;
        synchronized (syslogAuditEndpoint) {
            if (!this.accepting) {
                return;
            }
            this.syslogHandler.doPublish(new ExtLogRecord(SyslogAuditEndpoint.toLevel(t), u, SyslogAuditEndpoint.class.getName()));
        }
    }

    private static Level toLevel(EventPriority eventPriority) {
        switch (eventPriority) {
            case ALERT: 
            case EMERGENCY: 
            case CRITICAL: 
            case ERROR: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case INFORMATIONAL: {
                return Level.INFO;
            }
            case OFF: {
                throw ElytronMessages.audit.invalidEventPriority(eventPriority);
            }
        }
        return Level.FINEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.accepting = false;
        SyslogAuditEndpoint syslogAuditEndpoint = this;
        synchronized (syslogAuditEndpoint) {
            this.syslogHandler.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InetAddress serverAddress;
        private int port;
        private boolean ssl = false;
        private boolean tcp = true;
        private String hostName;
        private SocketFactory socketFactory = null;

        Builder() {
        }

        public Builder setServerAddress(InetAddress serverAddress) {
            this.serverAddress = Assert.checkNotNullParam("serverAddress", serverAddress);
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTcp(boolean tcp) {
            this.tcp = tcp;
            return this;
        }

        public Builder setSsl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder setHostName(String hostName) {
            this.hostName = Assert.checkNotNullParam("hostName", hostName);
            return this;
        }

        public AuditEndpoint build() throws IOException {
            return new SyslogAuditEndpoint(this);
        }
    }
}

