/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.alpn.ALPNManager;
import io.undertow.protocols.alpn.ALPNProvider;
import io.undertow.protocols.ssl.SslConduit;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.AggregateConnectorStatistics;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.XnioByteBufferPool;
import io.undertow.server.protocol.http.ALPNLimitingSSLEngine;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.SslConnection;

public class AlpnOpenListener
implements ChannelListener<StreamConnection>,
OpenListener {
    public static final String REQUIRED_CIPHER = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
    public static final String REQUIRED_PROTOCOL = "TLSv1.2";
    private final ALPNManager alpnManager = ALPNManager.INSTANCE;
    private final ByteBufferPool bufferPool;
    private final Map<String, ListenerEntry> listeners = new HashMap<String, ListenerEntry>();
    private String[] protocols;
    private final String fallbackProtocol;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;
    private volatile boolean providerLogged;
    private volatile boolean alpnFailLogged;

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions, DelegateOpenListener httpListener) {
        this(bufferPool, undertowOptions, "http/1.1", httpListener);
    }

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions) {
        this(bufferPool, undertowOptions, null, null);
    }

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this(new XnioByteBufferPool(bufferPool), undertowOptions, fallbackProtocol, fallbackListener);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, DelegateOpenListener httpListener) {
        this(bufferPool, undertowOptions, "http/1.1", httpListener);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool) {
        this(bufferPool, OptionMap.EMPTY, null, null);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions) {
        this(bufferPool, undertowOptions, null, null);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this.bufferPool = bufferPool;
        this.undertowOptions = undertowOptions;
        this.fallbackProtocol = fallbackProtocol;
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
        if (fallbackProtocol != null && fallbackListener != null) {
            this.addProtocol(fallbackProtocol, fallbackListener, 0);
        }
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(rootHandler);
        }
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(this.rootHandler);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            ArrayList<ConnectorStatistics> stats = new ArrayList<ConnectorStatistics>();
            for (Map.Entry<String, ListenerEntry> l : this.listeners.entrySet()) {
                ConnectorStatistics c = l.getValue().listener.getConnectorStatistics();
                if (c == null) continue;
                stats.add(c);
            }
            return new AggregateConnectorStatistics(stats.toArray(new ConnectorStatistics[stats.size()]));
        }
        return null;
    }

    public AlpnOpenListener addProtocol(String name, DelegateOpenListener listener, int weight) {
        this.listeners.put(name, new ListenerEntry(listener, weight, name));
        ArrayList<ListenerEntry> list = new ArrayList<ListenerEntry>(this.listeners.values());
        Collections.sort(list);
        this.protocols = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.protocols[i] = ((ListenerEntry)list.get((int)i)).protocol;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(StreamConnection channel) {
        ALPNProvider provider;
        SslConduit sslConduit;
        SSLEngine sslEngine;
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        if (!AlpnOpenListener.engineSupportsHTTP2(sslEngine = (sslConduit = UndertowXnioSsl.getSslConduit((SslConnection)channel)).getSSLEngine())) {
            ListenerEntry listener;
            if (!this.alpnFailLogged) {
                AlpnOpenListener alpnOpenListener = this;
                synchronized (alpnOpenListener) {
                    if (!this.alpnFailLogged) {
                        UndertowLogger.REQUEST_LOGGER.debugf("ALPN has been configured however %s is not present or TLS1.2 is not enabled, falling back to default protocol", (Object)REQUIRED_CIPHER);
                        this.alpnFailLogged = true;
                    }
                }
            }
            if (this.fallbackProtocol != null && (listener = this.listeners.get(this.fallbackProtocol)) != null) {
                listener.listener.handleEvent(channel);
                return;
            }
        }
        if ((provider = this.alpnManager.getProvider(sslEngine)) == null) {
            ListenerEntry listener;
            if (!this.providerLogged) {
                AlpnOpenListener alpnOpenListener = this;
                synchronized (alpnOpenListener) {
                    if (!this.providerLogged) {
                        UndertowLogger.REQUEST_LOGGER.debugf("ALPN has been configured however no provider could be found for engine %s for connector at %s", (Object)sslEngine, (Object)channel.getLocalAddress());
                        this.providerLogged = true;
                    }
                }
            }
            if (this.fallbackProtocol != null && (listener = this.listeners.get(this.fallbackProtocol)) != null) {
                listener.listener.handleEvent(channel);
                return;
            }
            UndertowLogger.REQUEST_LOGGER.debugf("No ALPN provider available and no fallback defined", new Object[0]);
            IoUtils.safeClose((Closeable)channel);
            return;
        }
        if (!this.providerLogged) {
            AlpnOpenListener listener = this;
            synchronized (listener) {
                if (!this.providerLogged) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Using ALPN provider %s for connector at %s", (Object)provider, (Object)channel.getLocalAddress());
                    this.providerLogged = true;
                }
            }
        }
        final SSLEngine newEngine = provider.setProtocols(sslEngine, this.protocols);
        sslConduit.setSslEngine(new ALPNLimitingSSLEngine(newEngine, new Runnable(){

            @Override
            public void run() {
                provider.setProtocols(newEngine, new String[]{AlpnOpenListener.this.fallbackProtocol});
            }
        }));
        AlpnConnectionListener potentialConnection = new AlpnConnectionListener(channel, newEngine, provider);
        channel.getSourceChannel().setReadListener(potentialConnection);
        potentialConnection.handleEvent(channel.getSourceChannel());
    }

    public static boolean engineSupportsHTTP2(SSLEngine engine) {
        String[] ciphers;
        String[] protcols = engine.getEnabledProtocols();
        boolean found = false;
        for (String proto : protcols) {
            if (!proto.equals(REQUIRED_PROTOCOL)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        for (String i : ciphers = engine.getEnabledCipherSuites()) {
            if (!i.equals(REQUIRED_CIPHER)) continue;
            return true;
        }
        return false;
    }

    private class AlpnConnectionListener
    implements ChannelListener<StreamSourceChannel> {
        private final StreamConnection channel;
        private final SSLEngine engine;
        private final ALPNProvider provider;

        private AlpnConnectionListener(StreamConnection channel, SSLEngine engine, ALPNProvider provider) {
            this.channel = channel;
            this.engine = engine;
            this.provider = provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel source) {
            PooledByteBuffer buffer = AlpnOpenListener.this.bufferPool.allocate();
            boolean free = true;
            try {
                while (true) {
                    int res;
                    if ((res = this.channel.getSourceChannel().read(buffer.getBuffer())) == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        return;
                    }
                    buffer.getBuffer().flip();
                    String selected = this.provider.getSelectedProtocol(this.engine);
                    if (selected != null) {
                        DelegateOpenListener listener;
                        if (selected.isEmpty()) {
                            if (AlpnOpenListener.this.fallbackProtocol == null) {
                                UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                                IoUtils.safeClose((Closeable)this.channel);
                                return;
                            }
                            listener = ((ListenerEntry)((AlpnOpenListener)AlpnOpenListener.this).listeners.get((Object)((AlpnOpenListener)AlpnOpenListener.this).fallbackProtocol)).listener;
                        } else {
                            listener = ((ListenerEntry)((AlpnOpenListener)AlpnOpenListener.this).listeners.get((Object)selected)).listener;
                        }
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res > 0) {
                        if (AlpnOpenListener.this.fallbackProtocol == null) {
                            UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                            IoUtils.safeClose((Closeable)this.channel);
                            return;
                        }
                        DelegateOpenListener listener = ((ListenerEntry)((AlpnOpenListener)AlpnOpenListener.this).listeners.get((Object)((AlpnOpenListener)AlpnOpenListener.this).fallbackProtocol)).listener;
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res == 0) {
                        this.channel.getSourceChannel().resumeReads();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            finally {
                if (free) {
                    buffer.close();
                }
            }
        }
    }

    private static class ListenerEntry
    implements Comparable<ListenerEntry> {
        final DelegateOpenListener listener;
        final int weight;
        final String protocol;

        ListenerEntry(DelegateOpenListener listener, int weight, String protocol) {
            this.listener = listener;
            this.weight = weight;
            this.protocol = protocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListenerEntry)) {
                return false;
            }
            ListenerEntry that = (ListenerEntry)o;
            if (this.weight != that.weight) {
                return false;
            }
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.protocol.equals(that.protocol);
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + this.weight;
            result = 31 * result + this.protocol.hashCode();
            return result;
        }

        @Override
        public int compareTo(ListenerEntry o) {
            return -Integer.compare(this.weight, o.weight);
        }
    }
}

