/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import org.jboss.ejb.client.ClusterNodeSelector;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

public final class EJBClientCluster {
    private final String name;
    private final long maximumConnectedNodes;
    private final long connectTimeoutMilliseconds;
    private final ClusterNodeSelector clusterNodeSelector;
    private final AuthenticationConfiguration overrideConfiguration;

    EJBClientCluster(Builder builder) {
        this.name = builder.name;
        this.maximumConnectedNodes = builder.maximumConnectedNodes;
        this.connectTimeoutMilliseconds = builder.connectTimeoutMilliseconds;
        this.clusterNodeSelector = builder.clusterNodeSelector;
        this.overrideConfiguration = builder.overrideConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public long getMaximumConnectedNodes() {
        return this.maximumConnectedNodes;
    }

    public long getConnectTimeoutMilliseconds() {
        return this.connectTimeoutMilliseconds;
    }

    public ClusterNodeSelector getClusterNodeSelector() {
        return this.clusterNodeSelector;
    }

    public AuthenticationConfiguration getOverrideConfiguration() {
        return this.overrideConfiguration;
    }

    public static final class Builder {
        private String name;
        private long maximumConnectedNodes = 0L;
        private long connectTimeoutMilliseconds = -1L;
        private ClusterNodeSelector clusterNodeSelector;
        private AuthenticationConfiguration overrideConfiguration;

        public Builder setName(String name) {
            Assert.checkNotNullParam("name", name);
            this.name = name;
            return this;
        }

        public Builder setMaximumConnectedNodes(long maximumConnectedNodes) {
            Assert.checkMinimumParameter("maximumConnectedNodes", 0L, maximumConnectedNodes);
            this.maximumConnectedNodes = maximumConnectedNodes;
            return this;
        }

        public Builder setConnectTimeoutMilliseconds(long connectTimeoutMilliseconds) {
            Assert.checkMinimumParameter("connectTimeoutMilliseconds", -1L, connectTimeoutMilliseconds);
            this.connectTimeoutMilliseconds = connectTimeoutMilliseconds;
            return this;
        }

        public Builder setClusterNodeSelector(ClusterNodeSelector clusterNodeSelector) {
            this.clusterNodeSelector = clusterNodeSelector;
            return this;
        }

        public Builder setOverrideConfiguration(AuthenticationConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        public EJBClientCluster build() {
            Assert.checkNotNullParam("name", this.name);
            return new EJBClientCluster(this);
        }
    }
}

