/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.parser;

import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.impl.completer.CompleterData;
import org.aesh.command.impl.completer.DefaultValueOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.AeshCommandLineParser;
import org.aesh.command.impl.parser.CommandLineCompletionParser;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.parser.CompleteStatus;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParsedWord;
import org.aesh.parser.ParserStatus;
import org.aesh.readline.AeshContext;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.util.Parser;

public class AeshCommandLineCompletionParser<C extends Command>
implements CommandLineCompletionParser {
    private final AeshCommandLineParser<C> parser;

    public AeshCommandLineCompletionParser(AeshCommandLineParser<C> parser) {
        this.parser = parser;
    }

    @Override
    public void injectValuesAndComplete(AeshCompleteOperation completeOperation, InvocationProviders invocationProviders, ParsedLine line) {
        this.doInjectValues(invocationProviders, completeOperation.getContext());
        if (this.parser.getProcessedCommand().completeStatus().status().equals((Object)CompleteStatus.Status.COMPLETE_OPTION)) {
            ParsedWord.Status selectedWordStatus;
            ParsedWord.Status status = selectedWordStatus = line.selectedWord() != null ? line.selectedWord().status() : line.lastWord().status();
            if ((line.spaceAtEnd() || this.parser.lastParsedOption().getEndsWithSeparator()) && selectedWordStatus == ParsedWord.Status.OK) {
                if (this.parser.lastParsedOption() != null) {
                    if (this.parser.lastParsedOption().getValue() == null || this.parser.lastParsedOption().hasMultipleValues()) {
                        if (line.spaceAtEnd() && this.parser.lastParsedOption().getValueSeparator() == ' ') {
                            this.parser.lastParsedOption().setEndsWithSeparator(true);
                        }
                        this.doCompleteOptionValue(invocationProviders, completeOperation, this.parser.lastParsedOption(), selectedWordStatus);
                    } else if (this.parser.getProcessedCommand().hasArguments() || this.parser.getProcessedCommand().hasArgumentWithNoValue()) {
                        this.doProcessArgument(completeOperation, invocationProviders, line);
                    } else {
                        this.doListOptions(completeOperation, "");
                    }
                } else if (this.parser.getProcessedCommand().hasArguments() || this.parser.getProcessedCommand().hasArgumentWithNoValue()) {
                    this.doProcessArgument(completeOperation, invocationProviders, line);
                } else {
                    this.doListOptions(completeOperation, "");
                }
            } else {
                if (selectedWordStatus != ParsedWord.Status.OK) {
                    this.parser.lastParsedOption().setEndsWithSeparator(false);
                }
                this.doCompleteOptionValue(invocationProviders, completeOperation, this.parser.lastParsedOption(), selectedWordStatus);
            }
        } else if (this.parser.getProcessedCommand().completeStatus().status().equals((Object)CompleteStatus.Status.LONG_OPTION)) {
            this.doListOptions(completeOperation, "--" + this.parser.getProcessedCommand().completeStatus().value());
        } else if (this.parser.getProcessedCommand().completeStatus().status().equals((Object)CompleteStatus.Status.SHORT_OPTION)) {
            if (this.parser.getProcessedCommand().completeStatus().value().length() == 0) {
                completeOperation.addCompletionCandidate("-");
                completeOperation.doAppendSeparator(false);
                completeOperation.setOffset(completeOperation.getCursor());
            }
        } else if (this.parser.getProcessedCommand().completeStatus().status().equals((Object)CompleteStatus.Status.OPTION_MISSING_VALUE)) {
            if (this.parser.lastParsedOption().isLongNameUsed() || this.parser.lastParsedOption().getValue() != null || this.parser.lastParsedOption().getEndsWithSeparator() || line.spaceAtEnd()) {
                if (this.parser.lastParsedOption().isLongNameUsed() && !this.parser.lastParsedOption().getEndsWithSeparator() && !line.spaceAtEnd() && !line.selectedWord().word().endsWith("=") && this.parser.lastParsedOption().hasValue()) {
                    completeOperation.addCompletionCandidate("=");
                    completeOperation.setOffset(completeOperation.getCursor());
                    completeOperation.doAppendSeparator(false);
                } else if (!(this.parser.lastParsedOption().hasValue() || this.parser.lastParsedOption().getEndsWithSeparator() || line.spaceAtEnd())) {
                    completeOperation.addCompletionCandidate(" ");
                    completeOperation.setOffset(completeOperation.getCursor());
                    completeOperation.doAppendSeparator(false);
                } else {
                    this.doCompleteOptionValue(invocationProviders, completeOperation, this.parser.lastParsedOption(), line.selectedWord() != null ? line.selectedWord().status() : line.lastWord().status());
                }
            }
        } else if (this.parser.getProcessedCommand().completeStatus().status().equals((Object)CompleteStatus.Status.ARGUMENT)) {
            this.doProcessArgument(completeOperation, invocationProviders, line);
        } else if (this.parser.getProcessedCommand().completeStatus().status().equals((Object)CompleteStatus.Status.GROUP_COMMAND)) {
            this.doProcessGroupCommand(completeOperation, this.parser.getProcessedCommand().completeStatus().value(), line);
        } else if (this.parser.getProcessedCommand().completeStatus().status().equals((Object)CompleteStatus.Status.APPEND_SPACE)) {
            completeOperation.addCompletionCandidate(" ");
            completeOperation.doAppendSeparator(false);
            completeOperation.setOffset(completeOperation.getCursor());
        }
    }

    private void doProcessGroupCommand(AeshCompleteOperation completeOperation, String name, ParsedLine line) {
        if (name.length() == 0) {
            for (CommandLineParser<C> clp : this.parser.getAllChildParsers()) {
                if (!clp.getProcessedCommand().getActivator().isActivated(new ParsedCommand(clp.getProcessedCommand()))) continue;
                completeOperation.addCompletionCandidate(clp.getProcessedCommand().name());
            }
            if (completeOperation.getCompletionCandidates().size() == 1) {
                completeOperation.setOffset(completeOperation.getCursor());
            }
        } else {
            for (CommandLineParser<C> child : this.parser.getAllChildParsers()) {
                if (!child.getProcessedCommand().name().startsWith(name) || !child.getProcessedCommand().getActivator().isActivated(new ParsedCommand(child.getProcessedCommand()))) continue;
                completeOperation.addCompletionCandidate(child.getProcessedCommand().name());
                completeOperation.setOffset(completeOperation.getCursor() - name.length());
            }
        }
        if (completeOperation.getCompletionCandidates().size() == 1 && !line.cursorAtEnd()) {
            completeOperation.doAppendSeparator(false);
        }
    }

    private void doProcessArgument(AeshCompleteOperation completeOperation, InvocationProviders invocationProviders, ParsedLine line) {
        ProcessedOption arg;
        ProcessedOption processedOption = arg = this.parser.getProcessedCommand().hasArguments() ? this.parser.getProcessedCommand().getArguments() : this.parser.getProcessedCommand().getArgument();
        if (!(arg.getOptionType() != OptionType.ARGUMENT || arg.getValue() == null && arg.activator().isActivated(new ParsedCommand(this.parser.getProcessedCommand())))) {
            this.doListOptions(completeOperation, "");
        } else if (arg.getOptionType() == OptionType.ARGUMENTS && !arg.activator().isActivated(new ParsedCommand(this.parser.getProcessedCommand()))) {
            this.doListOptions(completeOperation, "");
        } else {
            if (this.parser.getProcessedCommand().completeStatus().value() != null && this.parser.getProcessedCommand().completeStatus().value().length() > 0) {
                arg.addValue(this.parser.getProcessedCommand().completeStatus().value());
            } else {
                arg.setEndsWithSeparator(true);
            }
            boolean haveCompletion = false;
            haveCompletion = this.parser.getProcessedCommand().completeStatus().value() != null && this.parser.getProcessedCommand().completeStatus().value().length() > 0 ? this.doCompleteOptionValue(invocationProviders, completeOperation, arg, line.selectedWord().status()) : this.doCompleteOptionValue(invocationProviders, completeOperation, arg, line.status() == ParserStatus.OK ? ParsedWord.Status.OK : ParsedWord.Status.OPEN_QUOTE);
            if (!haveCompletion && !arg.isRequired() && arg.getValue() == null && this.parser.getProcessedCommand().completeStatus().value().length() == 0) {
                this.doListOptions(completeOperation, "");
            }
        }
    }

    private void doListOptions(AeshCompleteOperation completeOperation, String value) {
        List<TerminalString> optionNamesWithDash = value.length() < 3 ? this.parser.getProcessedCommand().getOptionLongNamesWithDash() : this.parser.getProcessedCommand().findPossibleLongNamesWithDash(value.substring(2));
        if (optionNamesWithDash.size() > 1) {
            completeOperation.addCompletionCandidatesTerminalString(optionNamesWithDash);
            completeOperation.setOffset(completeOperation.getCursor() - value.length());
            completeOperation.setIgnoreStartsWith(false);
        } else if (optionNamesWithDash.size() == 1) {
            completeOperation.addCompletionCandidate(optionNamesWithDash.get(0));
            completeOperation.setOffset(completeOperation.getCursor() - value.length());
            if (optionNamesWithDash.get(0).getCharacters().endsWith("=")) {
                completeOperation.doAppendSeparator(false);
            }
        }
    }

    private boolean doCompleteOptionValue(InvocationProviders invocationProviders, AeshCompleteOperation completeOperation, ProcessedOption currentOption, ParsedWord.Status selectedWordStatus) {
        String value = currentOption.getLastValue();
        if (value == null || currentOption.getEndsWithSeparator()) {
            value = "";
        }
        if (currentOption.completer() != null && currentOption.hasValue() && currentOption.activator().isActivated(new ParsedCommand(this.parser.getProcessedCommand()))) {
            Object completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getContext(), value, (Command)this.parser.getCommand()));
            currentOption.completer().complete(completions);
            completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
            AeshCommandLineCompletionParser.verifyCompleteValue(completeOperation, completions, value, selectedWordStatus);
        } else if (currentOption.getDefaultValues().size() > 0) {
            Object completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getContext(), value, (Command)this.parser.getCommand()));
            new DefaultValueOptionCompleter(currentOption.getDefaultValues()).complete((CompleterInvocation)completions);
            completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
            AeshCommandLineCompletionParser.verifyCompleteValue(completeOperation, completions, value, selectedWordStatus);
        } else if (!currentOption.hasValue()) {
            completeOperation.doAppendSeparator(true);
        }
        return completeOperation.getCompletionCandidates().size() > 0;
    }

    public static void verifyCompleteValue(AeshCompleteOperation completeOperation, CompleterInvocation completions, String value, ParsedWord.Status selectedWordStatus) {
        if (completions.getOffset() >= 0) {
            int numberSpaces = 0;
            if (selectedWordStatus == ParsedWord.Status.OK && completions.getCompleterValues().size() == 1) {
                numberSpaces = Parser.findNumberOfSpacesInWord(value.substring(value.length() - completions.getOffset(), value.length()));
            }
            completeOperation.setOffset(completeOperation.getCursor() - completions.getOffset() - numberSpaces);
        } else {
            completeOperation.setOffset(completeOperation.getCursor() - value.length() - (selectedWordStatus == ParsedWord.Status.OK ? Parser.findNumberOfSpacesInWord(value) : 0));
        }
        if (selectedWordStatus == ParsedWord.Status.OK && completeOperation.getCompletionCandidates().size() == 1 && completeOperation.getCompletionCandidates().get(0).containSpaces()) {
            completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
        }
        if (completions.getCompleterValues().size() == 1) {
            completeOperation.doAppendSeparator(completions.isAppendSpace());
        }
        completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
        completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
    }

    private void doInjectValues(InvocationProviders invocationProviders, AeshContext context) {
        try {
            this.parser.getCommandPopulator().populateObject(this.parser.getProcessedCommand(), invocationProviders, context, CommandLineParser.Mode.NONE);
        }
        catch (CommandLineParserException | OptionValidatorException exception) {
            // empty catch block
        }
    }
}

