/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.alias.AliasCompletion;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.alias.AliasPreProcessor;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.FileHistory;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.TerminalBuilder;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Signal;
import org.aesh.util.FileAccessPermission;
import org.aesh.util.Parser;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;
import org.jboss.as.cli.CommandHistory;
import org.jboss.logging.Logger;

public class ReadlineConsole {
    private static final Logger LOG = Logger.getLogger(ReadlineConsole.class.getName());
    private static final boolean isTraceEnabled = LOG.isTraceEnabled();
    private final List<Completion> completions = new ArrayList<Completion>();
    private Readline readline;
    private CLITerminalConnection connection;
    private final CommandHistory history = new HistoryImpl();
    private final FileHistory readlineHistory;
    private Prompt prompt;
    private final Settings settings;
    private volatile boolean started;
    private volatile boolean closed;
    private Thread startThread;
    private Thread readingThread;
    private Consumer<String> callback;
    private final ExecutorService executor = Executors.newFixedThreadPool(1, r -> new Thread(r, "CLI command"));
    private StringBuilder outputCollector;
    private final AliasManager aliasManager;
    private final List<Function<String, Optional<String>>> preProcessors = new ArrayList<Function<String, Optional<String>>>();
    private static final EnumMap<ReadlineFlag, Integer> READLINE_FLAGS = new EnumMap(ReadlineFlag.class);
    private Consumer<Signal> interruptHandler;
    private boolean isSystemTerminal;
    private boolean forcePaging;

    ReadlineConsole(Settings settings) throws IOException {
        this.settings = settings;
        this.readlineHistory = new FileHistory(settings.getHistoryFile(), settings.getHistorySize(), settings.getPermission(), false);
        if (settings.isDisableHistory()) {
            this.readlineHistory.disable();
        } else {
            this.readlineHistory.enable();
        }
        if (isTraceEnabled) {
            LOG.tracef("History is enabled? %s", (Object)(!settings.isDisableHistory() ? 1 : 0));
        }
        this.aliasManager = new AliasManager(new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_aliases"), true);
        AliasPreProcessor aliasPreProcessor = new AliasPreProcessor(this.aliasManager);
        this.preProcessors.add(aliasPreProcessor);
        this.completions.add(new AliasCompletion(this.aliasManager));
        this.readline = new Readline();
    }

    private void initializeConnection() throws IOException {
        if (this.connection == null) {
            this.connection = this.newConnection();
            this.interruptHandler = signal -> {
                if (signal == Signal.INT) {
                    LOG.trace("Calling InterruptHandler");
                    this.connection.write(Config.getLineSeparator());
                    this.connection.close();
                }
            };
            this.connection.setSignalHandler(this.interruptHandler);
            Attributes attr = this.connection.getAttributes();
            attr.setLocalFlag(Attributes.LocalFlag.ECHOCTL, false);
            this.connection.setAttributes(attr);
        }
    }

    public void setActionCallback(Consumer<String> callback) {
        this.callback = callback;
    }

    private CLITerminalConnection newConnection() throws IOException {
        LOG.trace("Creating terminal connection");
        Terminal terminal = TerminalBuilder.builder().input(this.settings.getInStream() == null ? System.in : this.settings.getInStream()).output(this.settings.getOutStream()).nativeSignals(true).name("CLI Terminal").system(!this.settings.isOutputRedefined()).build();
        if (isTraceEnabled) {
            LOG.tracef("New Terminal %s", (Object)terminal.getClass());
        }
        CLITerminalConnection c = new CLITerminalConnection(terminal);
        this.isSystemTerminal = c.supportsAnsi();
        return c;
    }

    public void setCompletionHandler(CompletionHandler<? extends CompleteOperation> ch) {
        this.readline = new Readline(EditModeBuilder.builder().create(), null, ch);
    }

    private Readline getReadLine() {
        if (this.readline == null) {
            this.readline = new Readline();
        }
        return this.readline;
    }

    public void addCompleter(Completion<? extends CompleteOperation> completer) {
        this.completions.add(completer);
    }

    public CommandHistory getHistory() {
        return this.history;
    }

    public void clearScreen() {
        if (this.connection != null) {
            this.connection.stdoutHandler().accept(ANSI.CLEAR_SCREEN);
        }
    }

    public String formatColumns(Collection<String> list) {
        String[] newList = new String[list.size()];
        list.toArray(newList);
        return Parser.formatDisplayList(newList, this.getHeight(), this.getWidth());
    }

    public void print(String line, boolean collect) {
        LOG.tracef("Print %s", (Object)line);
        if (collect && this.outputCollector != null) {
            this.outputCollector.append(line);
        } else if (this.connection == null) {
            PrintStream out = this.settings.getOutStream() == null ? System.out : this.settings.getOutStream();
            try {
                ((OutputStream)out).write(line.getBytes());
            }
            catch (IOException ex) {
                LOG.tracef("Print exception %s", (Object)ex);
            }
        } else {
            this.connection.write(line);
        }
    }

    public Key readKey() throws InterruptedException, IOException {
        return Key.findStartKey(this.read());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCollectedOutput() {
        if (this.outputCollector == null) {
            return;
        }
        try {
            String line = this.outputCollector.toString();
            if (line.isEmpty()) {
                return;
            }
            String[] lines = line.split("\\R", -1);
            int max = this.connection.size().getHeight();
            int currentLines = 0;
            int allLines = 0;
            while (allLines < lines.length) {
                if (currentLines > max - 2) {
                    try {
                        this.connection.write(ANSI.CURSOR_SAVE);
                        int percentage = allLines * 100 / lines.length;
                        this.connection.write("--More(" + percentage + "%)--");
                        Key k = this.readKey();
                        this.connection.write(ANSI.CURSOR_RESTORE);
                        this.connection.stdoutHandler().accept(ANSI.ERASE_LINE_FROM_CURSOR);
                        if (k == null) {
                            allLines = lines.length;
                            continue;
                        }
                        switch (k) {
                            case SPACE: {
                                currentLines = 0;
                                break;
                            }
                            case DOWN: 
                            case ENTER: 
                            case CTRL_M: {
                                --currentLines;
                                break;
                            }
                            case q: {
                                allLines = lines.length;
                            }
                        }
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                String l = lines[allLines];
                ++currentLines;
                if (++allLines == lines.length && l.isEmpty()) continue;
                this.connection.write(l + Config.getLineSeparator());
            }
        }
        finally {
            this.outputCollector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] read() throws InterruptedException, IOException {
        this.initializeConnection();
        ActionDecoder decoder = new ActionDecoder();
        int[][] key = new int[][]{null};
        this.readingThread = Thread.currentThread();
        Consumer<Signal> prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(this.interruptHandler);
        CountDownLatch latch = new CountDownLatch(1);
        Attributes attributes = this.connection.enterRawMode();
        this.connection.setStdinHandler(keys -> {
            decoder.add((int[])keys);
            if (decoder.hasNext()) {
                key[0] = decoder.next().buffer().array();
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        finally {
            this.connection.setStdinHandler(null);
            this.connection.setSignalHandler(prevHandler);
            this.readingThread = null;
        }
        return key[0];
    }

    public void printNewLine(boolean collect) {
        this.print(Config.getLineSeparator(), collect);
    }

    public String readLine(String prompt) throws IOException, InterruptedException {
        return this.readLine(prompt, (Character)null);
    }

    public String readLine(String prompt, Character mask) throws InterruptedException, IOException {
        this.logPromptMask(prompt, mask);
        return this.readLine(new Prompt(prompt, mask));
    }

    public String readLine(Prompt prompt) throws InterruptedException, IOException {
        return this.readLine(prompt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        this.printCollectedOutput();
        this.outputCollector = this.createCollector();
        this.readingThread = Thread.currentThread();
        try {
            if (!this.started) {
                String string = this.promptFromNonStartedConsole(prompt, completer);
                return string;
            }
            String string = this.promptFromStartedConsole(prompt, completer);
            return string;
        }
        finally {
            this.readingThread = null;
        }
    }

    private StringBuilder createCollector() {
        if (!this.isPagingOutputEnabled()) {
            return null;
        }
        return new StringBuilder();
    }

    private String promptFromNonStartedConsole(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        this.initializeConnection();
        LOG.trace("Not started");
        String[] out = new String[1];
        if (this.connection.suspended()) {
            this.connection.awake();
        }
        ArrayList<Completion> lst = null;
        if (completer != null) {
            lst = new ArrayList<Completion>();
            lst.add(completer);
        }
        this.getReadLine().readline(this.connection, prompt, newLine -> {
            out[0] = newLine;
            LOG.trace("Got some input");
            this.connection.stopReading();
        }, lst, null, null, null, READLINE_FLAGS);
        this.connection.openBlockingInterruptable();
        LOG.trace("Done for prompt");
        return out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptFromStartedConsole(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        this.initializeConnection();
        String[] out = new String[1];
        if (this.readingThread == this.startThread) {
            throw new RuntimeException("Can't prompt from the Thread that is reading terminal input");
        }
        ArrayList<Completion> lst = null;
        if (completer != null) {
            lst = new ArrayList<Completion>();
            lst.add(completer);
        }
        CountDownLatch latch = new CountDownLatch(1);
        Consumer<Signal> prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(this.interruptHandler);
        this.readline.readline(this.connection, prompt, newLine -> {
            out[0] = newLine;
            LOG.trace("Got some input");
            latch.countDown();
        }, lst, null, null, null, READLINE_FLAGS);
        try {
            latch.await();
        }
        finally {
            this.connection.setSignalHandler(prevHandler);
        }
        LOG.trace("Done for prompt");
        return out[0];
    }

    private void logPromptMask(String prompt, Character mask) {
        LOG.tracef("Prompt %s mask %s", (Object)prompt, (Object)mask);
    }

    public int getTerminalWidth() {
        return this.getWidth();
    }

    public int getTerminalHeight() {
        return this.getHeight();
    }

    private int getHeight() {
        if (this.connection == null) {
            return 40;
        }
        return this.connection.size().getHeight();
    }

    private int getWidth() {
        if (this.connection == null) {
            return 80;
        }
        return this.connection.size().getWidth();
    }

    public void start() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Console has already been closed");
        }
        if (!this.started) {
            this.initializeConnection();
            this.startThread = Thread.currentThread();
            this.started = true;
            this.loop();
            LOG.tracef("Started in thread %s. Waiting...", (Object)this.startThread.getName());
            try {
                this.connection.openBlockingInterruptable();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.trace("Leaving console");
        } else {
            LOG.trace("Already started");
        }
    }

    private void loop() {
        try {
            if (isTraceEnabled) {
                LOG.tracef("Set a readline callback with prompt %s", (Object)this.prompt);
            }
            if (!this.closed) {
                this.getReadLine().readline(this.connection, this.prompt, line -> {
                    LOG.tracef("Executing command %s in a new thread.", line);
                    if (line == null || line.trim().length() == 0 || this.handleAlias((String)line)) {
                        this.loop();
                        return;
                    }
                    this.executor.submit(() -> {
                        Consumer<Signal> handler = this.connection.getSignalHandler();
                        Thread callingThread = Thread.currentThread();
                        this.connection.setSignalHandler(signal -> {
                            switch (signal) {
                                case INT: {
                                    LOG.tracef("Interrupting command: %s", line);
                                    callingThread.interrupt();
                                }
                            }
                        });
                        try {
                            this.outputCollector = this.createCollector();
                            this.callback.accept((String)line);
                        }
                        catch (Throwable thr) {
                            this.connection.write("Unexpected exception");
                            thr.printStackTrace();
                        }
                        finally {
                            this.printCollectedOutput();
                            Thread.interrupted();
                            this.connection.setSignalHandler(handler);
                            LOG.tracef("Done Executing command %s", line);
                            this.loop();
                        }
                    });
                }, this.completions, this.preProcessors, this.readlineHistory, null, READLINE_FLAGS);
            }
        }
        catch (Exception ex) {
            this.connection.write("Unexpected exception");
            ex.printStackTrace();
        }
    }

    private boolean handleAlias(String line) {
        if (line.startsWith("alias ") || line.equals("alias")) {
            String out = this.aliasManager.parseAlias(line.trim());
            if (out != null) {
                this.print(out, false);
            }
            return true;
        }
        if (line.startsWith("unalias ") || line.equals("unalias")) {
            String out = this.aliasManager.removeAlias(line.trim());
            if (out != null) {
                this.print(out, false);
            }
            return true;
        }
        return false;
    }

    public void stop() {
        if (!this.closed) {
            LOG.trace("Stopping.");
            this.closed = true;
            if (this.readingThread != null) {
                LOG.trace("Interrupting reading thread");
                this.readingThread.interrupt();
            }
            if (this.started) {
                this.readlineHistory.stop();
                this.aliasManager.persist();
            }
            this.executor.shutdown();
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    public boolean running() {
        return this.started;
    }

    public void setPrompt(String prompt) {
        this.prompt = new Prompt(prompt);
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public boolean isPagingOutputEnabled() {
        if (this.forcePaging) {
            return true;
        }
        return this.isSystemTerminal;
    }

    public void forcePagingOutput(boolean forcePaging) {
        this.forcePaging = forcePaging;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String handleBuiltins(String line) {
        if (this.handleAlias(line)) {
            return null;
        }
        return this.parse(line);
    }

    private String parse(String line) {
        Optional<String> out = this.aliasManager.getAliasName(line);
        if (out.isPresent()) {
            line = out.get();
        }
        return line;
    }

    static {
        READLINE_FLAGS.put(ReadlineFlag.NO_PROMPT_REDRAW_ON_INTR, Integer.MAX_VALUE);
    }

    class HistoryImpl
    implements CommandHistory {
        HistoryImpl() {
        }

        @Override
        public List<String> asList() {
            ArrayList<String> lst = new ArrayList<String>();
            for (int[] l : ReadlineConsole.this.readlineHistory.getAll()) {
                lst.add(Parser.stripAwayAnsiCodes(Parser.fromCodePoints(l)));
            }
            return lst;
        }

        @Override
        public boolean isUseHistory() {
            return ReadlineConsole.this.readlineHistory.isEnabled();
        }

        @Override
        public void setUseHistory(boolean useHistory) {
            if (useHistory) {
                ReadlineConsole.this.readlineHistory.enable();
            } else {
                ReadlineConsole.this.readlineHistory.disable();
            }
        }

        @Override
        public void clear() {
            ReadlineConsole.this.readlineHistory.clear();
        }

        @Override
        public int getMaxSize() {
            return ReadlineConsole.this.readlineHistory.size();
        }
    }

    public static class SettingsBuilder {
        private InputStream inStream;
        private OutputStream outStream;
        private boolean disableHistory;
        private File historyFile;
        private int historySize;
        private FileAccessPermission permission;
        private Runnable interrupt;
        private boolean outputRedefined;

        public SettingsBuilder inputStream(InputStream inStream) {
            this.inStream = inStream;
            return this;
        }

        public SettingsBuilder outputStream(OutputStream outStream) {
            this.outStream = outStream;
            return this;
        }

        public SettingsBuilder disableHistory(boolean disableHistory) {
            this.disableHistory = disableHistory;
            return this;
        }

        public SettingsBuilder historyFile(File historyFile) {
            this.historyFile = historyFile;
            return this;
        }

        public SettingsBuilder historySize(int historySize) {
            this.historySize = historySize;
            return this;
        }

        public SettingsBuilder historyFilePermission(FileAccessPermission permission) {
            this.permission = permission;
            return this;
        }

        public SettingsBuilder interruptHook(Runnable interrupt) {
            this.interrupt = interrupt;
            return this;
        }

        public SettingsBuilder outputRedefined(boolean outputRedefined) {
            this.outputRedefined = outputRedefined;
            return this;
        }

        public Settings create() {
            return new SettingsImpl(this.inStream, this.outStream, this.outputRedefined, this.disableHistory, this.historyFile, this.historySize, this.permission, this.interrupt);
        }
    }

    private static class SettingsImpl
    implements Settings {
        private final InputStream inStream;
        private final OutputStream outStream;
        private final boolean disableHistory;
        private final File historyFile;
        private final int historySize;
        private final FileAccessPermission permission;
        private final Runnable interrupt;
        private final boolean outputRedefined;

        private SettingsImpl(InputStream inStream, OutputStream outStream, boolean outputRedefined, boolean disableHistory, File historyFile, int historySize, FileAccessPermission permission, Runnable interrupt) {
            this.inStream = inStream;
            this.outStream = outStream;
            this.outputRedefined = outputRedefined;
            this.disableHistory = disableHistory;
            this.historyFile = historyFile;
            this.historySize = historySize;
            this.permission = permission;
            this.interrupt = interrupt;
        }

        @Override
        public InputStream getInStream() {
            return this.inStream;
        }

        @Override
        public OutputStream getOutStream() {
            return this.outStream;
        }

        @Override
        public boolean isDisableHistory() {
            return this.disableHistory;
        }

        @Override
        public boolean isOutputRedefined() {
            return this.outputRedefined;
        }

        @Override
        public File getHistoryFile() {
            return this.historyFile;
        }

        @Override
        public int getHistorySize() {
            return this.historySize;
        }

        @Override
        public FileAccessPermission getPermission() {
            return this.permission;
        }

        @Override
        public Runnable getInterrupt() {
            return this.interrupt;
        }
    }

    private static class CLITerminalConnection
    extends TerminalConnection {
        private final Consumer<int[]> interceptor = ints -> {
            if (isTraceEnabled) {
                LOG.tracef("Writing %s", (Object)Parser.stripAwayAnsiCodes(Parser.fromCodePoints(ints)));
            }
            CLITerminalConnection.super.stdoutHandler().accept(ints);
        };
        private Thread connectionThread;

        CLITerminalConnection(Terminal terminal) {
            super(terminal);
        }

        @Override
        public Consumer<int[]> stdoutHandler() {
            return this.interceptor;
        }

        public void openBlockingInterruptable() throws InterruptedException {
            this.connectionThread = new Thread(() -> {
                Thread thr = new Thread(() -> super.openBlocking(), "CLI Terminal Connection (uninterruptable)");
                thr.start();
                try {
                    thr.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }, "CLI Terminal Connection (interruptable)");
            this.connectionThread.start();
            this.connectionThread.join();
        }

        @Override
        public void close() {
            super.close();
            if (this.connectionThread != null) {
                this.connectionThread.interrupt();
            }
        }
    }

    public static interface Settings {
        public InputStream getInStream();

        public OutputStream getOutStream();

        public boolean isDisableHistory();

        public boolean isOutputRedefined();

        public File getHistoryFile();

        public int getHistorySize();

        public FileAccessPermission getPermission();

        public Runnable getInterrupt();
    }
}

