/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.aesh.command.CommandException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyManager;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStore;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ServerSSLContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class SSLSecurityBuilder
implements SecurityCommand.FailureConsumer {
    public FailureDescProvider NO_DESC = new FailureDescProvider(){

        @Override
        public String stepFailedDescription() {
            return null;
        }
    };
    private final List<FailureDescProvider> providers = new ArrayList<FailureDescProvider>();
    private final List<FailureDescProvider> finalProviders = new ArrayList<FailureDescProvider>();
    private final List<FailureDescProvider> effectiveProviders = new ArrayList<FailureDescProvider>();
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private String sslContextName;
    private String keyManagerName;
    private final ModelNode composite = new ModelNode();
    private ServerSSLContext sslContext;
    private File trustedCertificate;
    private String trustStoreName;
    private String trustStoreFileName;
    private String generatedTrustStore;
    private String trustStoreFilePassword;
    private String newTrustStoreName;
    private String newTrustManagerName;
    private boolean validateCertificate;
    private final Set<String> ksToStore = new HashSet<String>();
    private final List<ModelNode> finalSteps = new ArrayList<ModelNode>();

    public SSLSecurityBuilder() throws CommandException {
        this.composite.get("operation").set("composite");
        this.composite.get("address").setEmptyList();
    }

    protected void needKeyStoreStore(String keyStoreName) {
        this.ksToStore.add(keyStoreName);
    }

    protected void addFinalstep(ModelNode step, FailureDescProvider ex) {
        this.finalSteps.add(step);
        this.finalProviders.add(ex);
    }

    public void setNewTrustStoreName(String newTrustStoreName) {
        this.newTrustStoreName = newTrustStoreName;
    }

    public void setNewTrustManagerName(String newTrustManagerName) {
        this.newTrustManagerName = newTrustManagerName;
    }

    public ModelNode buildExecutableRequest(CommandContext ctx) throws Exception {
        try {
            for (FailureDescProvider h : this.providers) {
                this.effectiveProviders.add(h);
            }
            for (String ks : this.ksToStore) {
                this.composite.get("steps").add(ElytronUtil.storeKeyStore(ctx, ks));
                this.effectiveProviders.add(new FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Storing the key-store " + SSLSecurityBuilder.this.ksToStore;
                    }
                });
            }
            for (int i = 0; i < this.finalSteps.size(); ++i) {
                this.composite.get("steps").add(this.finalSteps.get(i));
                this.effectiveProviders.add(this.finalProviders.get(i));
            }
            return this.composite;
        }
        catch (Exception ex) {
            try {
                this.failureOccured(ctx, null);
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    public File getTrustedCertificatePath() {
        return this.trustedCertificate;
    }

    public void setTrustedCertificatePath(File trustedCertificate) {
        this.trustedCertificate = trustedCertificate;
    }

    public void setValidateCertificate(boolean validateCertificate) {
        this.validateCertificate = validateCertificate;
    }

    public void addStep(ModelNode step, FailureDescProvider ex) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(ex);
        this.composite.get("steps").add(step);
        this.providers.add(ex);
    }

    public ServerSSLContext getServerSSLContext() {
        return this.sslContext;
    }

    public SSLSecurityBuilder setSSLContextName(String sslContextName) {
        this.sslContextName = sslContextName;
        return this;
    }

    public SSLSecurityBuilder setKeyManagerName(String keyManagerName) {
        this.keyManagerName = keyManagerName;
        return this;
    }

    protected abstract KeyStore buildKeyStore(CommandContext var1, boolean var2) throws Exception;

    public void buildRequest(CommandContext ctx, boolean buildRequest) throws Exception {
        try {
            KeyStore keyStore = this.buildKeyStore(ctx, buildRequest);
            KeyManager trustManager = this.buildTrustManager(ctx, buildRequest);
            KeyManager km = this.buildKeyManager(ctx, this.keyManagerName, keyStore);
            this.sslContext = this.buildServerSSLContext(ctx, km, trustManager);
        }
        catch (Exception ex) {
            try {
                this.failureOccured(ctx, null);
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    protected KeyManager buildTrustManager(CommandContext ctx, boolean buildRequest) throws Exception {
        KeyManager trustManager = null;
        if (this.trustedCertificate != null || this.trustStoreName != null) {
            KeyStore trustStore = null;
            String id = UUID.randomUUID().toString();
            if (this.newTrustStoreName == null) {
                this.newTrustStoreName = "trust-store-" + id;
            } else if (ElytronUtil.keyStoreExists(ctx, this.newTrustStoreName)) {
                throw new CommandException("The key-store " + this.newTrustStoreName + " already exists");
            }
            if (this.trustStoreName == null) {
                if (this.trustStoreFileName == null) {
                    this.trustStoreFileName = "server-" + id + ".trustore";
                } else {
                    List<String> ksNames = ElytronUtil.findMatchingKeyStores(ctx, new File(this.trustStoreFileName), "jboss.server.config.dir");
                    if (!ksNames.isEmpty()) {
                        throw new CommandException("Error, the file " + this.trustStoreFileName + " is already referenced from " + ksNames + " resources. Use " + SecurityCommand.formatOption("trust-store-name") + " option or choose another file name.");
                    }
                }
                this.generatedTrustStore = this.newTrustStoreName;
                String password = this.trustStoreFilePassword == null ? SSLSecurityBuilder.generateRandomPassword() : this.trustStoreFilePassword;
                ModelNode request = ElytronUtil.addKeyStore(ctx, this.newTrustStoreName, new File(this.trustStoreFileName), "jboss.server.config.dir", password, "JKS", false, null);
                if (buildRequest) {
                    this.addStep(request, this.NO_DESC);
                } else {
                    SecurityCommand.execute(ctx, request, SecurityCommand.DEFAULT_FAILURE_CONSUMER);
                }
                trustStore = new KeyStore(this.newTrustStoreName, password, false);
                ModelNode certImport = ElytronUtil.importCertificate(ctx, this.trustedCertificate, id, this.validateCertificate, trustStore, true);
                this.addStep(certImport, new FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Importing certificate " + SSLSecurityBuilder.this.trustedCertificate.getAbsolutePath() + " in trust-store " + SSLSecurityBuilder.this.newTrustStoreName;
                    }
                });
                this.needKeyStoreStore(trustStore.getName());
            } else {
                trustStore = ElytronUtil.getKeyStore(ctx, this.trustStoreName);
            }
            trustManager = this.buildTrustManager(ctx, this.newTrustManagerName, trustStore);
        }
        return trustManager;
    }

    private KeyManager buildKeyManager(CommandContext ctx, String ksManagerName, KeyStore keyStore) throws Exception {
        boolean lookupExisting = false;
        if (ksManagerName == null) {
            ksManagerName = DefaultResourceNames.buildDefaultKeyManagerName(ctx, keyStore.getName());
            lookupExisting = true;
        } else if (ElytronUtil.keyManagerExists(ctx, ksManagerName)) {
            throw new CommandException("The key-manager " + ksManagerName + " already exists");
        }
        String name = null;
        boolean exists = false;
        if (keyStore.exists() && lookupExisting) {
            name = ElytronUtil.findMatchingKeyManager(ctx, keyStore, null, null);
        }
        if (name == null) {
            final String kmName = name = ksManagerName;
            this.addStep(ElytronUtil.addKeyManager(ctx, keyStore, ksManagerName, null, null), new FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Adding key-manager " + kmName;
                }
            });
        } else {
            exists = true;
        }
        return new KeyManager(name, keyStore, exists);
    }

    private KeyManager buildTrustManager(CommandContext ctx, String ksManagerName, KeyStore keyStore) throws Exception {
        boolean lookupExisting = false;
        if (ksManagerName == null) {
            ksManagerName = DefaultResourceNames.buildDefaultKeyManagerName(ctx, keyStore.getName());
            lookupExisting = true;
        } else if (ElytronUtil.trustManagerExists(ctx, ksManagerName)) {
            throw new CommandException("The key-manager " + ksManagerName + " already exists");
        }
        String name = null;
        boolean exists = false;
        if (keyStore.exists() && lookupExisting) {
            name = ElytronUtil.findMatchingTrustManager(ctx, keyStore, null, null);
        }
        if (name == null) {
            name = ksManagerName;
            final String tmName = ksManagerName;
            this.addStep(ElytronUtil.addTrustManager(ctx, keyStore, ksManagerName, null, null), new FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Adding trust-manager " + tmName;
                }
            });
        } else {
            exists = true;
        }
        return new KeyManager(name, keyStore, exists);
    }

    private ServerSSLContext buildServerSSLContext(CommandContext ctx, KeyManager manager, KeyManager trustManager) throws Exception {
        ServerSSLContext sslCtx;
        String tm;
        boolean lookupExisting = false;
        if (this.sslContextName == null) {
            this.sslContextName = DefaultResourceNames.buildDefaultSSLContextName(ctx, manager.getKeyStore().getName());
            lookupExisting = true;
        } else if (ElytronUtil.serverSSLContextExists(ctx, this.sslContextName)) {
            throw new CommandException("The ssl-context " + this.sslContextName + " already exists");
        }
        List<String> lst = DefaultResourceNames.getDefaultProtocols(ctx);
        String name = null;
        boolean exists = false;
        boolean need = trustManager != null;
        String string = tm = trustManager == null ? null : trustManager.getName();
        if (manager.exists() && lookupExisting) {
            sslCtx = new ServerSSLContext(null, manager, trustManager, false);
            sslCtx.setNeed(need);
            sslCtx.setProtocols(lst);
            name = ElytronUtil.findMatchingSSLContext(ctx, sslCtx);
        }
        if (name == null) {
            name = this.sslContextName;
        } else {
            exists = true;
        }
        sslCtx = new ServerSSLContext(name, manager, trustManager, exists);
        sslCtx.setNeed(need);
        sslCtx.setProtocols(lst);
        if (!exists) {
            this.addStep(ElytronUtil.addServerSSLContext(ctx, sslCtx, this.sslContextName), new FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Adding ssl-context " + SSLSecurityBuilder.this.sslContextName;
                }
            });
        }
        return sslCtx;
    }

    private String getFailedStepDescription(CommandContext ctx, ModelNode responseNode) {
        if (responseNode == null) {
            return null;
        }
        ModelNode mn = responseNode.get("result");
        StringBuilder msg = new StringBuilder();
        if (mn.isDefined()) {
            int index = 0;
            ModelNode fd = responseNode.get("failure-description");
            if (fd.isDefined()) {
                for (Property prop : mn.asPropertyList()) {
                    ModelNode val = prop.getValue();
                    if (val.hasDefined("failure-description")) {
                        String description = this.effectiveProviders.get(index).stepFailedDescription();
                        msg.append("\nERROR, security changes have not been applied.\n");
                        if (description != null) {
                            msg.append("Failed action: ").append(description).append("\n");
                        }
                        msg.append("Cause: ").append(val.get("failure-description").asString()).append("\n");
                        break;
                    }
                    ++index;
                }
            }
        }
        return msg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failureOccured(CommandContext ctx, ModelNode mn) throws CommandException {
        StringBuilder builder = new StringBuilder();
        boolean failure = false;
        if (mn != null) {
            String desc = this.getFailedStepDescription(ctx, mn);
            builder.append(desc).append("\n");
            failure = true;
        }
        try {
            if (this.generatedTrustStore != null) {
                ModelNode req = ElytronUtil.removeKeyStore(ctx, this.generatedTrustStore);
                SecurityCommand.execute(ctx, req, SecurityCommand.DEFAULT_FAILURE_CONSUMER);
            }
        }
        catch (Exception ex) {
            builder.append("Error while cleaning up key-stores " + ex).append("\n");
            failure = true;
        }
        finally {
            try {
                this.doFailureOccured(ctx);
            }
            catch (Exception ex) {
                builder.append("Error while cleaning up " + ex);
                failure = true;
            }
        }
        if (failure) {
            throw new CommandException(builder.toString());
        }
    }

    protected abstract void doFailureOccured(CommandContext var1) throws Exception;

    public String getTrustStoreName() {
        return this.trustStoreName;
    }

    public void setTrustStoreName(String trustStoreName) {
        this.trustStoreName = trustStoreName;
    }

    public String getTrustStoreFileName() {
        return this.trustStoreFileName;
    }

    public void setTrustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
    }

    public void setTrustStoreFilePassword(String trustStoreFilePassword) {
        this.trustStoreFilePassword = trustStoreFilePassword;
    }

    static String generateRandomPassword() {
        return SSLSecurityBuilder.generateRandomString(8);
    }

    static String generateRandomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = (int)(RANDOM.nextDouble() * (double)CHARS.length());
            builder.append(CHARS.substring(index, index + 1));
        }
        return builder.toString();
    }

    public static interface FailureDescProvider {
        public String stepFailedDescription();
    }
}

