/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.builder.CommandBuilder;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.renderer.OptionRenderer;
import org.aesh.command.settings.ManProvider;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.OptionValidator;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.command.validator.ValidatorInvocationProvider;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.readline.ReadlineConsole;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.formatting.CharacterType;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.terminal.formatting.TerminalTextStyle;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

public class Example {
    public static void main(String[] args) throws CommandLineParserException, IOException {
        CommandBuilder fooCommand = new CommandBuilder().name("foo").description("fooing").addOption(ProcessedOptionBuilder.builder().name("bar").addDefaultValue("en 1 0").addDefaultValue("to 2 0").fieldName("bar").type(String.class).renderer(new BlueBoldRenderer()).build()).addOption(ProcessedOptionBuilder.builder().name("foo").fieldName("foo").type(String.class).build()).command(FooCommand.class);
        SettingsBuilder builder = SettingsBuilder.builder().logging(true).enableMan(true).enableAlias(true).enableExport(true).setExecuteFileAtStart(new FileResource(Config.getHomeDir() + Config.getPathSeparator() + ".aeshrc")).readInputrc(false);
        CommandRegistry registry = new AeshCommandRegistryBuilder().command(ExitCommand.class).command(fooCommand.create()).command(HiddenCommand.class).command(LsCommand.class).command(TestConsoleCommand.class).command(PromptCommand.class).command(RunCommand.class).command(ClearCommand.class).command(GroupCommand.class).command(LongOutputCommand.class).command(new CommandBuilder().name("quit").command(commandInvocation -> {
            commandInvocation.stop();
            return CommandResult.SUCCESS;
        }).create()).create();
        Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings = builder.commandRegistry(registry).manProvider(new ManProviderExample()).validatorInvocationProvider(new ExampleValidatorInvocationProvider()).build();
        ReadlineConsole console = new ReadlineConsole(settings);
        console.setPrompt(new Prompt(new TerminalString("[aesh@rules]$ ", new TerminalColor(Color.GREEN, Color.DEFAULT, Color.Intensity.BRIGHT))));
        console.start();
    }

    @CommandDefinition(name="rebase", description="description of rebase command")
    public static class Rebase
    implements Command {
        @Option
        private boolean bar;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.getShell().writeln("bar is set to: " + this.bar);
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="base", description="description of base command")
    public static class Base
    implements Command {
        @Option(description="set foo")
        private String foo;
        @Option(hasValue=false, description="display this help option")
        private boolean help;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().writeln(commandInvocation.getHelpInfo("group child1"));
            } else {
                commandInvocation.getShell().writeln("foo is set to: " + this.foo);
            }
            return CommandResult.SUCCESS;
        }
    }

    @GroupCommandDefinition(name="group", description="This is a group command", groupCommands={Base.class, Rebase.class})
    public static class GroupCommand
    implements Command {
        @Option(hasValue=false, description="display this help option")
        private boolean help;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().writeln(commandInvocation.getHelpInfo("group"));
            } else {
                commandInvocation.getShell().writeln("only executed group, it doesnt do much...");
            }
            return CommandResult.SUCCESS;
        }
    }

    public static class ManProviderExample
    implements ManProvider {
        @Override
        public InputStream getManualDocument(String commandName) {
            try {
                return new FileInputStream("/tmp/asciitest2.txt");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class BlueBoldRenderer
    implements OptionRenderer {
        private static final TerminalTextStyle style = new TerminalTextStyle(CharacterType.UNDERLINE);
        private static final TerminalColor color = new TerminalColor(42, Color.DEFAULT);

        @Override
        public TerminalColor getColor() {
            return color;
        }

        @Override
        public TerminalTextStyle getTextType() {
            return style;
        }
    }

    public static class BarActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption bar = parsedCommand.findLongOption("bar");
            return bar != null && bar.value() != null;
        }
    }

    public static class ExampleValidatorInvocationProvider
    implements ValidatorInvocationProvider<ValidatorInvocation<File, Command>> {
        @Override
        public ValidatorInvocation<File, Command> enhanceValidatorInvocation(ValidatorInvocation validatorInvocation) {
            if (validatorInvocation.getValue() instanceof File) {
                return new DirectoryValidatorInvocation((File)validatorInvocation.getValue(), (Command)validatorInvocation.getCommand(), validatorInvocation.getAeshContext());
            }
            return validatorInvocation;
        }
    }

    public static class DirectoryValidatorInvocation
    implements ValidatorInvocation<File, Command> {
        private final File file;
        private final Command command;
        private final AeshContext aeshContext;

        public DirectoryValidatorInvocation(File file, Command command, AeshContext aeshContext) {
            this.file = file;
            this.command = command;
            this.aeshContext = aeshContext;
        }

        @Override
        public File getValue() {
            return this.file;
        }

        @Override
        public Command getCommand() {
            return this.command;
        }

        @Override
        public AeshContext getAeshContext() {
            return this.aeshContext;
        }
    }

    public static class DirectoryValidator
    implements OptionValidator<DirectoryValidatorInvocation> {
        @Override
        public void validate(DirectoryValidatorInvocation validatorInvocation) throws OptionValidatorException {
            if (!validatorInvocation.getValue().isDirectory()) {
                throw new OptionValidatorException("File validation failed, must be a directory.");
            }
        }
    }

    public static class LessCompleter
    implements OptionCompleter {
        public void complete(CompleterInvocation completerData) {
            ArrayList<String> completeList = new ArrayList<String>();
            if (completerData.getGivenCompleteValue() == null || completerData.getGivenCompleteValue().length() == 0) {
                completeList.add("1");
            } else {
                int lastChar = completerData.getGivenCompleteValue().charAt(completerData.getGivenCompleteValue().length() - 1);
                if (Character.isDigit((char)lastChar)) {
                    int i = lastChar;
                    completeList.add(completerData.getGivenCompleteValue() + ++i);
                }
            }
            completerData.addAllCompleterValues(completeList);
        }
    }

    @CommandDefinition(name="prompt", description="")
    public static class PromptCommand
    implements Command {
        @Option(hasValue=false)
        private boolean bar;
        private Shell shell;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            this.shell = commandInvocation.getShell();
            if (this.bar) {
                this.shell.write("are you sure you want bar? (y/n) ");
                KeyAction operation = null;
                try {
                    operation = commandInvocation.input();
                }
                catch (InterruptedException e) {
                    return CommandResult.FAILURE;
                }
                if (operation instanceof Key) {
                    this.processOperation((Key)operation);
                }
            }
            return CommandResult.SUCCESS;
        }

        public void processOperation(Key operation) {
            if (operation == Key.y) {
                this.shell.writeln(Config.getLineSeparator() + "you wanted bar!");
            } else {
                this.shell.writeln(Config.getLineSeparator() + "you chickened out!!");
            }
        }
    }

    @CommandDefinition(name="long-output", description="")
    public static class LongOutputCommand
    implements Command {
        @Option(hasValue=false)
        private boolean prompt;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < commandInvocation.getShell().size().getHeight() * 2; ++i) {
                builder.append("A sentence to say " + i + " time how long this content is." + Config.getLineSeparator());
            }
            commandInvocation.getShell().writeln(builder.toString(), true);
            if (this.prompt) {
                commandInvocation.inputLine(new Prompt("What was the name of your first pet?: "));
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="clear", description="")
    public static class ClearCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.getShell().clear();
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="ls", description="[OPTION]... [FILE]...")
    public static class LsCommand
    implements Command {
        @Option(shortName=102, hasValue=false, description="set foo to true/false")
        private Boolean foo;
        @Option(hasValue=false, description="set the bar", renderer=BlueBoldRenderer.class)
        private boolean bar;
        @Option(shortName=108, completer=LessCompleter.class, defaultValue={"MORE"}, argument="SIZE")
        private String less;
        @OptionList(defaultValue={"/tmp"}, description="file location", valueSeparator=58, validator=DirectoryValidator.class, activator=BarActivator.class)
        List<File> files;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;
        @Arguments(description="files or directories thats listed")
        private List<Resource> arguments;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().writeln(commandInvocation.getHelpInfo("ls"));
            } else {
                if (this.foo.booleanValue()) {
                    commandInvocation.getShell().writeln("you set foo to: " + this.foo);
                }
                if (this.bar) {
                    commandInvocation.getShell().writeln("you set bar to: " + this.bar);
                }
                if (this.less != null) {
                    commandInvocation.getShell().writeln("you set less to: " + this.less);
                }
                if (this.files != null) {
                    commandInvocation.getShell().writeln("you set file to: " + this.files);
                }
                if (this.arguments != null) {
                    for (Resource f : this.arguments) {
                        commandInvocation.getShell().writeln(f.toString());
                    }
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="test", description="testing")
    public static class TestConsoleCommand
    implements Command {
        @Option(hasValue=false, required=true)
        private boolean bar;
        @Option(hasValue=false)
        private boolean barbar;
        @Option(overrideRequired=true, hasValue=false)
        private boolean help;
        @Option(hasValue=false)
        private boolean helpPlease;
        private Shell shell;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            this.shell = commandInvocation.getShell();
            if (this.help) {
                this.shell.writeln(commandInvocation.getHelpInfo("test"));
            } else {
                try {
                    this.processOperation(commandInvocation);
                }
                catch (IOException ex) {
                    throw new CommandException(ex);
                }
            }
            return CommandResult.SUCCESS;
        }

        private void display() {
            this.shell.write(ANSI.ALTERNATE_BUFFER);
        }

        private void stop() {
            this.shell.write(ANSI.MAIN_BUFFER);
        }

        public void processOperation(CommandInvocation invocation) throws IOException, InterruptedException {
            String username = this.promptForUsername(invocation);
            String password = this.promptForInput("password: ", Character.valueOf('*'), invocation);
            this.shell.writeln("we got username: " + username + ", password: " + password);
        }

        private String promptForUsername(CommandInvocation invocation) throws InterruptedException {
            invocation.print("username: ");
            return invocation.inputLine();
        }

        private String promptForInput(String prompt, Character mask, CommandInvocation invocation) throws IOException, InterruptedException {
            return invocation.inputLine(new Prompt(prompt, mask));
        }
    }

    public static class FooCommand
    implements Command {
        private String bar;
        private String foo;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            if (this.bar == null) {
                commandInvocation.getShell().writeln("NO BAR!");
            } else {
                commandInvocation.getShell().writeln("you set bar to: " + this.bar);
                commandInvocation.getShell().writeln("lets work a bit...... ");
                Thread.sleep(2000L);
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="run", description="")
    public static class RunCommand
    implements Command {
        @Arguments(required=true)
        private List<Resource> arguments;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            if (this.arguments != null && this.arguments.size() > 0 && this.arguments.get(0).isLeaf()) {
                try {
                    List<String> script = this.readScriptFile(this.arguments.get(0));
                    for (String line : script) {
                        commandInvocation.executeCommand(line + Config.getLineSeparator());
                    }
                }
                catch (Exception ex) {
                    throw new CommandException(ex);
                }
            }
            return CommandResult.SUCCESS;
        }

        private List<String> readScriptFile(Resource resource) throws IOException {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(resource.read()));
            String line = br.readLine();
            while (line != null) {
                if (line.trim().length() > 0 && !line.trim().startsWith("#")) {
                    lines.add(line);
                }
                line = br.readLine();
            }
            return lines;
        }
    }

    @CommandDefinition(name="hidden", description="hidden command", activator=HideActivator.class)
    public static class HiddenCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.print("Command exists but is not shown");
            return CommandResult.SUCCESS;
        }
    }

    private static class HideActivator
    implements CommandActivator {
        private HideActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand command) {
            return false;
        }
    }

    @CommandDefinition(name="exit", description="exit the program", aliases={"quit"})
    public static class ExitCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.stop();
            return CommandResult.SUCCESS;
        }
    }
}

