/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.apache.activemq.artemis.core.protocol.hornetq.client.HornetQClientSessionContext;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;

public class HornetQClientProtocolManager
extends ActiveMQClientProtocolManager {
    private static final int VERSION_PLAYED = 123;

    @Override
    protected void sendHandshake(Connection transportConnection) {
    }

    @Override
    protected SessionContext newSessionContext(String name, int confirmationWindowSize, Channel sessionChannel, CreateSessionResponseMessage response) {
        return new HornetQClientSessionContext(name, this.connection, sessionChannel, response.getServerVersion(), confirmationWindowSize);
    }

    @Override
    protected Packet newCreateSessionPacket(Version clientVersion, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize, long sessionChannelID) {
        return new CreateSessionMessage(name, sessionChannelID, 123, username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, confirmationWindowSize, null);
    }

    @Override
    public void sendSubscribeTopology(boolean isServer) {
        this.getChannel0().send(new SubscribeClusterTopologyUpdatesMessageV2(isServer, 123));
    }

    @Override
    public boolean checkForFailover(String liveNodeID) throws ActiveMQException {
        return true;
    }

    @Override
    protected ClusterTopologyChangeMessage updateTransportConfiguration(ClusterTopologyChangeMessage topMessage) {
        this.updateTransportConfiguration(topMessage.getPair().getA());
        this.updateTransportConfiguration(topMessage.getPair().getB());
        return super.updateTransportConfiguration(topMessage);
    }

    private void updateTransportConfiguration(TransportConfiguration connector) {
        String factoryClassName;
        if (connector != null && "org.hornetq.core.remoting.impl.netty.NettyConnectorFactory".equals(factoryClassName = connector.getFactoryClassName())) {
            connector.setFactoryClassName(NettyConnectorFactory.class.getName());
        }
    }
}

