/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.protocol.ProtocolTimeoutHandler;
import org.xnio.IoFuture;

public class GeneralTimeoutHandler
implements ProtocolTimeoutHandler {
    private volatile boolean thinking = false;
    private final AtomicLong thinkTime = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendAndExecute(Runnable runnable) {
        this.thinking = true;
        long startThinking = System.currentTimeMillis();
        try {
            runnable.run();
        }
        finally {
            this.thinkTime.addAndGet(System.currentTimeMillis() - startThinking);
            this.thinking = false;
        }
    }

    @Override
    public IoFuture.Status await(IoFuture<?> future, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        IoFuture.Status status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
        while (status == IoFuture.Status.WAITING) {
            if (this.thinking) {
                status = future.await(timeoutMillis, TimeUnit.MILLISECONDS);
                continue;
            }
            long timeToWait = timeoutMillis + this.thinkTime.get() - (System.currentTimeMillis() - startTime);
            if (timeToWait > 0L) {
                status = future.await(timeToWait, TimeUnit.MILLISECONDS);
                continue;
            }
            return status;
        }
        return status;
    }
}

