/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.config;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;

public final class ActiveMQDefaultConfiguration {
    private static long DEFAULT_CLIENT_FAILURE_CHECK_PERIOD = 30000L;
    private static long DEFAULT_FILE_DEPLOYER_SCAN_PERIOD = 5000L;
    private static int DEFAULT_JOURNAL_MAX_IO_AIO = 500;
    private static int DEFAULT_JOURNAL_POOL_FILES = -1;
    private static int DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO = 500000;
    private static int DEFAULT_JOURNAL_BUFFER_SIZE_AIO = 501760;
    private static int DEFAULT_JOURNAL_MAX_IO_NIO = 1;
    private static int DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO = 3333333;
    private static int DEFAULT_JOURNAL_BUFFER_SIZE_NIO = 501760;
    private static String PROP_MASK_PASSWORD = "activemq.usemaskedpassword";
    private static String PROP_PASSWORD_CODEC = "activemq.passwordcodec";
    private static String DEFAULT_HAPOLICY_TYPE = "NONE";
    private static String DEFAULT_HAPOLICY_BACKUP_STRATEGY = "FULL";
    private static boolean DEFAULT_RESOLVE_PROTOCOLS = true;
    private static boolean DEFAULT_FILE_DEPLOYMENT_ENABLED = false;
    private static boolean DEFAULT_PERSISTENCE_ENABLED = true;
    private static boolean DEFAULT_JOURNAL_DATASYNC = true;
    private static int DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE = 5;
    private static int DEFAULT_THREAD_POOL_MAX_SIZE = 30;
    private static boolean DEFAULT_SECURITY_ENABLED = true;
    private static boolean DEFAULT_GRACEFUL_SHUTDOWN_ENABLED = false;
    private static long DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = -1L;
    private static long DEFAULT_SECURITY_INVALIDATION_INTERVAL = 10000L;
    private static long DEFAULT_JOURNAL_LOCK_ACQUISITION_TIMEOUT = -1L;
    private static boolean DEFAULT_WILDCARD_ROUTING_ENABLED = true;
    private static SimpleString DEFAULT_MANAGEMENT_ADDRESS = new SimpleString("jms.queue.activemq.management");
    private static SimpleString DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS = new SimpleString("activemq.notifications");
    private static String DEFAULT_CLUSTER_ADDRESS = "jms";
    private static String DEFAULT_CLUSTER_USER = "ACTIVEMQ.CLUSTER.ADMIN.USER";
    private static String DEFAULT_CLUSTER_PASSWORD = "CHANGE ME!!";
    private static boolean DEFAULT_MASK_PASSWORD = false;
    private static boolean DEFAULT_JMX_MANAGEMENT_ENABLED = true;
    private static String DEFAULT_JMX_DOMAIN = "org.apache.activemq.artemis";
    private static boolean DEFAULT_JMX_IS_USE_BROKER_NAME = true;
    private static boolean DEFAULT_MESSAGE_COUNTER_ENABLED = false;
    private static long DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD = 10000L;
    private static int DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY = 10;
    private static long DEFAULT_CONNECTION_TTL_OVERRIDE = -1L;
    private static boolean DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED = true;
    private static long DEFAULT_TRANSACTION_TIMEOUT = 300000L;
    private static long DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD = 1000L;
    private static long DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD = 30000L;
    private static int DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY = 3;
    private static int DEFAULT_ID_CACHE_SIZE = 20000;
    private static boolean DEFAULT_PERSIST_ID_CACHE = true;
    private static boolean DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = false;
    private static String DEFAULT_PAGING_DIR = "data/paging";
    private static String DEFAULT_BINDINGS_DIRECTORY = "data/bindings";
    private static boolean DEFAULT_CREATE_BINDINGS_DIR = true;
    private static int DEFAULT_MAX_CONCURRENT_PAGE_IO = 5;
    private static String DEFAULT_JOURNAL_DIR = "data/journal";
    private static boolean DEFAULT_CREATE_JOURNAL_DIR = true;
    private static boolean DEFAULT_JOURNAL_SYNC_TRANSACTIONAL = true;
    private static boolean DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL = true;
    private static boolean DEFAULT_JOURNAL_LOG_WRITE_RATE = false;
    private static int DEFAULT_JOURNAL_FILE_SIZE = 0xA00000;
    private static int DEFAULT_JOURNAL_MIN_FILES = 2;
    private static int DEFAULT_JOURNAL_COMPACT_PERCENTAGE = 30;
    private static int DEFAULT_JOURNAL_COMPACT_MIN_FILES = 10;
    private static int DEFAULT_JOURNAL_PERF_BLAST_PAGES = -1;
    private static boolean DEFAULT_RUN_SYNC_SPEED_TEST = false;
    private static long DEFAULT_SERVER_DUMP_INTERVAL = -1L;
    private static int DEFAULT_MEMORY_WARNING_THRESHOLD = 25;
    private static long DEFAULT_MEMORY_MEASURE_INTERVAL = -1L;
    private static String DEFAULT_LARGE_MESSAGES_DIR = "data/largemessages";
    private static long DEFAULT_BROADCAST_PERIOD = 2000L;
    private static int DEFAULT_BROADCAST_REFRESH_TIMEOUT = 10000;
    private static long DEFAULT_CONNECTION_TTL = 60000L;
    private static double DEFAULT_RETRY_INTERVAL_MULTIPLIER = 1.0;
    private static long DEFAULT_MAX_RETRY_INTERVAL = 2000L;
    private static int DEFAULT_BRIDGE_INITIAL_CONNECT_ATTEMPTS = -1;
    private static int DEFAULT_BRIDGE_RECONNECT_ATTEMPTS = -1;
    private static boolean DEFAULT_BRIDGE_DUPLICATE_DETECTION = true;
    private static int DEFAULT_BRIDGE_CONFIRMATION_WINDOW_SIZE = 0x100000;
    private static int DEFAULT_BRIDGE_PRODUCER_WINDOW_SIZE = -1;
    private static int DEFAULT_BRIDGE_CONNECT_SAME_NODE = 10;
    private static long DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD = 30000L;
    private static long DEFAULT_CLUSTER_CONNECTION_TTL = 60000L;
    private static long DEFAULT_CLUSTER_CALL_TIMEOUT = 30000L;
    private static long DEFAULT_CLUSTER_RETRY_INTERVAL = 500L;
    private static double DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER = 1.0;
    private static long DEFAULT_CLUSTER_MAX_RETRY_INTERVAL = 2000L;
    private static int DEFAULT_CLUSTER_INITIAL_CONNECT_ATTEMPTS = -1;
    private static int DEFAULT_CLUSTER_RECONNECT_ATTEMPTS = -1;
    private static boolean DEFAULT_CLUSTER_DUPLICATE_DETECTION = true;
    private static boolean DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS = false;
    private static String DEFAULT_CLUSTER_MESSAGE_LOAD_BALANCING_TYPE = "ON_DEMAND";
    private static int DEFAULT_CLUSTER_MAX_HOPS = 1;
    private static int DEFAULT_CLUSTER_CONFIRMATION_WINDOW_SIZE = 0x100000;
    private static long DEFAULT_CLUSTER_CALL_FAILOVER_TIMEOUT = -1L;
    private static long DEFAULT_CLUSTER_NOTIFICATION_INTERVAL = 1000L;
    private static int DEFAULT_CLUSTER_NOTIFICATION_ATTEMPTS = 2;
    private static boolean DEFAULT_DIVERT_EXCLUSIVE = false;
    private static boolean DEFAULT_HAPOLICY_REQUEST_BACKUP = false;
    private static int DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRIES = -1;
    private static long DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRY_INTERVAL = 5000L;
    private static int DEFAULT_HAPOLICY_MAX_BACKUPS = 1;
    private static int DEFAULT_HAPOLICY_BACKUP_PORT_OFFSET = 100;
    private static boolean DEFAULT_CHECK_FOR_LIVE_SERVER = false;
    private static int DEFAULT_MAX_SAVED_REPLICATED_JOURNALS_SIZE = 2;
    private static boolean DEFAULT_RESTART_BACKUP = true;
    private static boolean DEFAULT_ALLOW_AUTO_FAILBACK = true;
    private static long DEFAULT_INITIAL_REPLICATION_SYNC_TIMEOUT = 30000L;
    private static boolean DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN = false;
    private static boolean DEFAULT_WAIT_FOR_ACTIVATION = true;
    private static boolean DEFAULT_POPULATE_VALIDATED_USER = false;
    private static boolean DEFAULT_SCALE_DOWN_ENABLED = true;
    private static int DEFAULT_GROUPING_HANDLER_TIMEOUT = 5000;
    private static int DEFAULT_GROUPING_HANDLER_GROUP_TIMEOUT = -1;
    private static long DEFAULT_GROUPING_HANDLER_REAPER_PERIOD = 30000L;
    private static String DEFAULT_STORE_TYPE = "FILE";
    private static String DEFAULT_DATABASE_URL = null;
    private static String DEFAULT_JDBC_DRIVER_CLASS_NAME = null;
    private static String DEFAULT_MESSAGE_TABLE_NAME = "MESSAGES";
    private static String DEFAULT_BINDINGS_TABLE_NAME = "BINDINGS";
    private static final String DEFAULT_LARGE_MESSAGES_TABLE_NAME = "LARGE_MESSAGES";
    private static final String DEFAULT_PAGE_STORE_TABLE_NAME = "PAGE_STORE";
    private static final String DEFAULT_NODE_MANAGER_STORE_TABLE_NAME = "NODE_MANAGER_STORE";
    private static final int DEFAULT_JDBC_NETWORK_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_JDBC_LOCK_RENEW_PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(4L);
    private static final long DEFAULT_JDBC_LOCK_EXPIRATION_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_JDBC_LOCK_ACQUISITION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final String DEFAULT_JMS_BINDINGS_TABLE_NAME = "JMS_BINDINGS";
    public static final long DEFAULT_CONNECTION_TTL_CHECK_INTERVAL = 2000L;
    public static final long DEFAULT_CONFIGURATION_FILE_REFRESH_PERIOD = 5000L;
    public static final long DEFAULT_GLOBAL_MAX_SIZE = -1L;
    public static final int DEFAULT_MAX_DISK_USAGE = 100;
    public static final int DEFAULT_DISK_SCAN = 5000;
    public static final String DEFAULT_SYSTEM_PROPERTY_PREFIX = "brokerconfig.";
    public static String DEFAULT_NETWORK_CHECK_LIST = null;
    public static String DEFAULT_NETWORK_CHECK_URL_LIST = null;
    public static long DEFAULT_NETWORK_CHECK_PERIOD = 5000L;
    public static int DEFAULT_NETWORK_CHECK_TIMEOUT = 1000;
    public static String DEFAULT_NETWORK_CHECK_NIC = null;

    private ActiveMQDefaultConfiguration() {
    }

    public static long getDefaultClientFailureCheckPeriod() {
        return DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    }

    public static long getDefaultFileDeployerScanPeriod() {
        return DEFAULT_FILE_DEPLOYER_SCAN_PERIOD;
    }

    public static int getDefaultJournalMaxIoAio() {
        return DEFAULT_JOURNAL_MAX_IO_AIO;
    }

    public static int getDefaultJournalBufferTimeoutAio() {
        return DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO;
    }

    public static int getDefaultJournalBufferSizeAio() {
        return DEFAULT_JOURNAL_BUFFER_SIZE_AIO;
    }

    public static int getDefaultJournalMaxIoNio() {
        return DEFAULT_JOURNAL_MAX_IO_NIO;
    }

    public static int getDefaultJournalBufferTimeoutNio() {
        return DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO;
    }

    public static int getDefaultJournalBufferSizeNio() {
        return DEFAULT_JOURNAL_BUFFER_SIZE_NIO;
    }

    public static String getPropMaskPassword() {
        return PROP_MASK_PASSWORD;
    }

    public static String getPropPasswordCodec() {
        return PROP_PASSWORD_CODEC;
    }

    public static String getDefaultHapolicyType() {
        return DEFAULT_HAPOLICY_TYPE;
    }

    public static String getDefaultHapolicyBackupStrategy() {
        return DEFAULT_HAPOLICY_BACKUP_STRATEGY;
    }

    public static boolean isDefaultResolveProtocols() {
        return DEFAULT_RESOLVE_PROTOCOLS;
    }

    public static boolean isDefaultFileDeploymentEnabled() {
        return DEFAULT_FILE_DEPLOYMENT_ENABLED;
    }

    public static boolean isDefaultPersistenceEnabled() {
        return DEFAULT_PERSISTENCE_ENABLED;
    }

    public static boolean isDefaultJournalDatasync() {
        return DEFAULT_JOURNAL_DATASYNC;
    }

    public static int getDefaultScheduledThreadPoolMaxSize() {
        return DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE;
    }

    public static int getDefaultThreadPoolMaxSize() {
        return DEFAULT_THREAD_POOL_MAX_SIZE;
    }

    public static boolean isDefaultSecurityEnabled() {
        return DEFAULT_SECURITY_ENABLED;
    }

    public static boolean isDefaultGracefulShutdownEnabled() {
        return DEFAULT_GRACEFUL_SHUTDOWN_ENABLED;
    }

    public static long getDefaultGracefulShutdownTimeout() {
        return DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
    }

    public static long getDefaultSecurityInvalidationInterval() {
        return DEFAULT_SECURITY_INVALIDATION_INTERVAL;
    }

    public static long getDefaultJournalLockAcquisitionTimeout() {
        return DEFAULT_JOURNAL_LOCK_ACQUISITION_TIMEOUT;
    }

    public static boolean isDefaultWildcardRoutingEnabled() {
        return DEFAULT_WILDCARD_ROUTING_ENABLED;
    }

    public static SimpleString getDefaultManagementAddress() {
        return DEFAULT_MANAGEMENT_ADDRESS;
    }

    public static SimpleString getDefaultManagementNotificationAddress() {
        return DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS;
    }

    public static String getDefaultClusterAddress() {
        return DEFAULT_CLUSTER_ADDRESS;
    }

    public static String getDefaultClusterUser() {
        return DEFAULT_CLUSTER_USER;
    }

    public static String getDefaultClusterPassword() {
        return DEFAULT_CLUSTER_PASSWORD;
    }

    public static boolean isDefaultMaskPassword() {
        return DEFAULT_MASK_PASSWORD;
    }

    public static boolean isDefaultJmxManagementEnabled() {
        return DEFAULT_JMX_MANAGEMENT_ENABLED;
    }

    public static String getDefaultJmxDomain() {
        return DEFAULT_JMX_DOMAIN;
    }

    public static boolean isDefaultJMXUseBrokerName() {
        return DEFAULT_JMX_IS_USE_BROKER_NAME;
    }

    public static boolean isDefaultMessageCounterEnabled() {
        return DEFAULT_MESSAGE_COUNTER_ENABLED;
    }

    public static long getDefaultMessageCounterSamplePeriod() {
        return DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD;
    }

    public static int getDefaultMessageCounterMaxDayHistory() {
        return DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY;
    }

    public static long getDefaultConnectionTtlOverride() {
        return DEFAULT_CONNECTION_TTL_OVERRIDE;
    }

    public static boolean isDefaultAsyncConnectionExecutionEnabled() {
        return DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED;
    }

    public static long getDefaultTransactionTimeout() {
        return DEFAULT_TRANSACTION_TIMEOUT;
    }

    public static long getDefaultTransactionTimeoutScanPeriod() {
        return DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD;
    }

    public static long getDefaultMessageExpiryScanPeriod() {
        return DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD;
    }

    public static int getDefaultMessageExpiryThreadPriority() {
        return DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY;
    }

    public static int getDefaultIdCacheSize() {
        return DEFAULT_ID_CACHE_SIZE;
    }

    public static boolean isDefaultPersistIdCache() {
        return DEFAULT_PERSIST_ID_CACHE;
    }

    public static boolean isDefaultPersistDeliveryCountBeforeDelivery() {
        return DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY;
    }

    public static String getDefaultPagingDir() {
        return DEFAULT_PAGING_DIR;
    }

    public static String getDefaultBindingsDirectory() {
        return DEFAULT_BINDINGS_DIRECTORY;
    }

    public static boolean isDefaultCreateBindingsDir() {
        return DEFAULT_CREATE_BINDINGS_DIR;
    }

    public static int getDefaultMaxConcurrentPageIo() {
        return DEFAULT_MAX_CONCURRENT_PAGE_IO;
    }

    public static String getDefaultJournalDir() {
        return DEFAULT_JOURNAL_DIR;
    }

    public static boolean isDefaultCreateJournalDir() {
        return DEFAULT_CREATE_JOURNAL_DIR;
    }

    public static boolean isDefaultJournalSyncTransactional() {
        return DEFAULT_JOURNAL_SYNC_TRANSACTIONAL;
    }

    public static boolean isDefaultJournalSyncNonTransactional() {
        return DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL;
    }

    public static boolean isDefaultJournalLogWriteRate() {
        return DEFAULT_JOURNAL_LOG_WRITE_RATE;
    }

    public static int getDefaultJournalFileSize() {
        return DEFAULT_JOURNAL_FILE_SIZE;
    }

    public static int getDefaultJournalMinFiles() {
        return DEFAULT_JOURNAL_MIN_FILES;
    }

    public static int getDefaultJournalPoolFiles() {
        return DEFAULT_JOURNAL_POOL_FILES;
    }

    public static int getDefaultJournalCompactPercentage() {
        return DEFAULT_JOURNAL_COMPACT_PERCENTAGE;
    }

    public static int getDefaultJournalCompactMinFiles() {
        return DEFAULT_JOURNAL_COMPACT_MIN_FILES;
    }

    public static int getDefaultJournalPerfBlastPages() {
        return DEFAULT_JOURNAL_PERF_BLAST_PAGES;
    }

    public static boolean isDefaultRunSyncSpeedTest() {
        return DEFAULT_RUN_SYNC_SPEED_TEST;
    }

    public static long getDefaultServerDumpInterval() {
        return DEFAULT_SERVER_DUMP_INTERVAL;
    }

    public static int getDefaultMemoryWarningThreshold() {
        return DEFAULT_MEMORY_WARNING_THRESHOLD;
    }

    public static long getDefaultMemoryMeasureInterval() {
        return DEFAULT_MEMORY_MEASURE_INTERVAL;
    }

    public static String getDefaultLargeMessagesDir() {
        return DEFAULT_LARGE_MESSAGES_DIR;
    }

    public static long getDefaultBroadcastPeriod() {
        return DEFAULT_BROADCAST_PERIOD;
    }

    public static int getDefaultBroadcastRefreshTimeout() {
        return DEFAULT_BROADCAST_REFRESH_TIMEOUT;
    }

    public static long getDefaultConnectionTtl() {
        return DEFAULT_CONNECTION_TTL;
    }

    public static double getDefaultRetryIntervalMultiplier() {
        return DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    }

    public static long getDefaultMaxRetryInterval() {
        return DEFAULT_MAX_RETRY_INTERVAL;
    }

    public static int getDefaultBridgeInitialConnectAttempts() {
        return DEFAULT_BRIDGE_INITIAL_CONNECT_ATTEMPTS;
    }

    public static int getDefaultBridgeReconnectAttempts() {
        return DEFAULT_BRIDGE_RECONNECT_ATTEMPTS;
    }

    public static boolean isDefaultBridgeDuplicateDetection() {
        return DEFAULT_BRIDGE_DUPLICATE_DETECTION;
    }

    public static int getDefaultBridgeConfirmationWindowSize() {
        return DEFAULT_BRIDGE_CONFIRMATION_WINDOW_SIZE;
    }

    public static int getDefaultBridgeProducerWindowSize() {
        return DEFAULT_BRIDGE_PRODUCER_WINDOW_SIZE;
    }

    public static int getDefaultBridgeConnectSameNode() {
        return DEFAULT_BRIDGE_CONNECT_SAME_NODE;
    }

    public static long getDefaultClusterFailureCheckPeriod() {
        return DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD;
    }

    public static long getDefaultClusterConnectionTtl() {
        return DEFAULT_CLUSTER_CONNECTION_TTL;
    }

    public static long getDefaultClusterCallTimeout() {
        return DEFAULT_CLUSTER_CALL_TIMEOUT;
    }

    public static long getDefaultClusterRetryInterval() {
        return DEFAULT_CLUSTER_RETRY_INTERVAL;
    }

    public static double getDefaultClusterRetryIntervalMultiplier() {
        return DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER;
    }

    public static long getDefaultClusterMaxRetryInterval() {
        return DEFAULT_CLUSTER_MAX_RETRY_INTERVAL;
    }

    public static int getDefaultClusterInitialConnectAttempts() {
        return DEFAULT_CLUSTER_INITIAL_CONNECT_ATTEMPTS;
    }

    public static int getDefaultClusterReconnectAttempts() {
        return DEFAULT_CLUSTER_RECONNECT_ATTEMPTS;
    }

    public static boolean isDefaultClusterDuplicateDetection() {
        return DEFAULT_CLUSTER_DUPLICATE_DETECTION;
    }

    public static boolean isDefaultClusterForwardWhenNoConsumers() {
        return DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS;
    }

    public static String getDefaultClusterMessageLoadBalancingType() {
        return DEFAULT_CLUSTER_MESSAGE_LOAD_BALANCING_TYPE;
    }

    public static int getDefaultClusterMaxHops() {
        return DEFAULT_CLUSTER_MAX_HOPS;
    }

    public static int getDefaultClusterConfirmationWindowSize() {
        return DEFAULT_CLUSTER_CONFIRMATION_WINDOW_SIZE;
    }

    public static long getDefaultClusterCallFailoverTimeout() {
        return DEFAULT_CLUSTER_CALL_FAILOVER_TIMEOUT;
    }

    public static long getDefaultClusterNotificationInterval() {
        return DEFAULT_CLUSTER_NOTIFICATION_INTERVAL;
    }

    public static int getDefaultClusterNotificationAttempts() {
        return DEFAULT_CLUSTER_NOTIFICATION_ATTEMPTS;
    }

    public static boolean isDefaultDivertExclusive() {
        return DEFAULT_DIVERT_EXCLUSIVE;
    }

    public static boolean isDefaultHapolicyRequestBackup() {
        return DEFAULT_HAPOLICY_REQUEST_BACKUP;
    }

    public static int getDefaultHapolicyBackupRequestRetries() {
        return DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRIES;
    }

    public static long getDefaultHapolicyBackupRequestRetryInterval() {
        return DEFAULT_HAPOLICY_BACKUP_REQUEST_RETRY_INTERVAL;
    }

    public static int getDefaultHapolicyMaxBackups() {
        return DEFAULT_HAPOLICY_MAX_BACKUPS;
    }

    public static int getDefaultHapolicyBackupPortOffset() {
        return DEFAULT_HAPOLICY_BACKUP_PORT_OFFSET;
    }

    public static boolean isDefaultCheckForLiveServer() {
        return DEFAULT_CHECK_FOR_LIVE_SERVER;
    }

    public static int getDefaultMaxSavedReplicatedJournalsSize() {
        return DEFAULT_MAX_SAVED_REPLICATED_JOURNALS_SIZE;
    }

    public static boolean isDefaultRestartBackup() {
        return DEFAULT_RESTART_BACKUP;
    }

    public static boolean isDefaultAllowAutoFailback() {
        return DEFAULT_ALLOW_AUTO_FAILBACK;
    }

    public static long getDefaultInitialReplicationSyncTimeout() {
        return DEFAULT_INITIAL_REPLICATION_SYNC_TIMEOUT;
    }

    @Deprecated
    public static long getDefaultFailbackDelay() {
        return 5000L;
    }

    public static boolean isDefaultFailoverOnServerShutdown() {
        return DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN;
    }

    public static boolean isDefaultWaitForActivation() {
        return DEFAULT_WAIT_FOR_ACTIVATION;
    }

    public static boolean isDefaultPopulateValidatedUser() {
        return DEFAULT_POPULATE_VALIDATED_USER;
    }

    public static boolean isDefaultScaleDownEnabled() {
        return DEFAULT_SCALE_DOWN_ENABLED;
    }

    public static int getDefaultGroupingHandlerTimeout() {
        return DEFAULT_GROUPING_HANDLER_TIMEOUT;
    }

    public static int getDefaultGroupingHandlerGroupTimeout() {
        return DEFAULT_GROUPING_HANDLER_GROUP_TIMEOUT;
    }

    public static long getDefaultGroupingHandlerReaperPeriod() {
        return DEFAULT_GROUPING_HANDLER_REAPER_PERIOD;
    }

    public static String getDefaultStoreType() {
        return DEFAULT_STORE_TYPE;
    }

    public static String getDefaultDatabaseUrl() {
        return DEFAULT_DATABASE_URL;
    }

    public static String getDefaultMessageTableName() {
        return DEFAULT_MESSAGE_TABLE_NAME;
    }

    public static String getDefaultBindingsTableName() {
        return DEFAULT_BINDINGS_TABLE_NAME;
    }

    public static String getDefaultDriverClassName() {
        return DEFAULT_JDBC_DRIVER_CLASS_NAME;
    }

    public static String getDefaultLargeMessagesTableName() {
        return DEFAULT_LARGE_MESSAGES_TABLE_NAME;
    }

    public static String getDefaultPageStoreTableName() {
        return DEFAULT_PAGE_STORE_TABLE_NAME;
    }

    public static String getDefaultNodeManagerStoreTableName() {
        return DEFAULT_NODE_MANAGER_STORE_TABLE_NAME;
    }

    public static int getDefaultJdbcNetworkTimeout() {
        return DEFAULT_JDBC_NETWORK_TIMEOUT;
    }

    public static long getDefaultJdbcLockRenewPeriodMillis() {
        return DEFAULT_JDBC_LOCK_RENEW_PERIOD_MILLIS;
    }

    public static long getDefaultJdbcLockExpirationMillis() {
        return DEFAULT_JDBC_LOCK_EXPIRATION_MILLIS;
    }

    public static long getDefaultJdbcLockAcquisitionTimeoutMillis() {
        return DEFAULT_JDBC_LOCK_ACQUISITION_TIMEOUT_MILLIS;
    }

    public static String getDefaultJMSBindingsTableName() {
        return DEFAULT_JMS_BINDINGS_TABLE_NAME;
    }

    public static long getDefaultConnectionTtlCheckInterval() {
        return 2000L;
    }

    public static long getDefaultConfigurationFileRefreshPeriod() {
        return 5000L;
    }

    public static long getDefaultMaxGlobalSize() {
        return -1L;
    }

    public static int getDefaultMaxDiskUsage() {
        return 100;
    }

    public static int getDefaultDiskScanPeriod() {
        return 5000;
    }

    public static String getDefaultSystemPropertyPrefix() {
        return DEFAULT_SYSTEM_PROPERTY_PREFIX;
    }

    public static String getDefaultNetworkCheckList() {
        return DEFAULT_NETWORK_CHECK_LIST;
    }

    public static String getDefaultNetworkCheckURLList() {
        return DEFAULT_NETWORK_CHECK_URL_LIST;
    }

    public static long getDefaultNetworkCheckPeriod() {
        return DEFAULT_NETWORK_CHECK_PERIOD;
    }

    public static int getDefaultNetworkCheckTimeout() {
        return DEFAULT_NETWORK_CHECK_TIMEOUT;
    }

    public static String getDefaultNetworkCheckNic() {
        return DEFAULT_NETWORK_CHECK_NIC;
    }
}

