/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ApplicationSecurityDomain;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class HTTPServer {
    public static final String DEFAULT_SERVER = "default-server";

    public static void enableSSL(String serverName, boolean noOverride, CommandContext context, SSLSecurityBuilder builder) throws OperationFormatException {
        if (serverName == null) {
            serverName = DefaultResourceNames.getDefaultServerName(context);
        }
        if (serverName == null) {
            throw new OperationFormatException("No default server name found.");
        }
        final String sName = serverName;
        if (!noOverride) {
            builder.addStep(HTTPServer.writeServerAttribute(serverName, "security-realm", null), new SSLSecurityBuilder.FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Writing security-realm attribute on http-server " + sName;
                }
            });
        }
        builder.addStep(HTTPServer.writeServerAttribute(serverName, "ssl-context", builder.getServerSSLContext().getName()), new SSLSecurityBuilder.FailureDescProvider(){

            @Override
            public String stepFailedDescription() {
                return "Writing ssl-context attribute on http-server " + sName;
            }
        });
    }

    private static ModelNode writeServerAttribute(String serverName, String name, String value) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("write-attribute");
        builder.addNode("subsystem", "undertow");
        builder.addNode("server", serverName);
        builder.addNode("https-listener", "https");
        builder.addProperty("name", name);
        if (value != null) {
            builder.addProperty("value", value);
        }
        return builder.buildRequest();
    }

    public static String disableSSL(CommandContext context, String serverName, ModelNode steps) throws OperationFormatException {
        if (serverName == null) {
            serverName = DefaultResourceNames.getDefaultServerName(context);
        }
        steps.add(HTTPServer.writeServerAttribute(serverName, "ssl-context", null));
        steps.add(HTTPServer.writeServerAttribute(serverName, "security-realm", DefaultResourceNames.getDefaultApplicationLegacyRealm()));
        return serverName;
    }

    public static String getSSLContextName(String serverName, CommandContext ctx) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-attribute");
        builder.addNode("subsystem", "undertow");
        builder.addNode("server", serverName);
        builder.addNode("https-listener", "https");
        builder.addProperty("name", "ssl-context");
        ModelNode request = builder.buildRequest();
        ModelNode outcome = ctx.getModelControllerClient().execute(request);
        if (Util.isSuccess(outcome) && outcome.hasDefined("result")) {
            return outcome.get("result").asString();
        }
        return null;
    }

    private static List<String> getNames(ModelControllerClient client, String type) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-children-names");
            builder.addNode("subsystem", "undertow");
            builder.addProperty("child-type", type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static boolean isUnderowSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "undertow");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }

    public static boolean isReferencedSecurityDomainSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource-description");
        builder.addNode("subsystem", "undertow");
        builder.addNode("application-security-domain", "?");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        if (Util.isSuccess(response) && response.get("result").hasDefined("attributes")) {
            return response.get("result").get("attributes").hasDefined("security-domain");
        }
        return false;
    }

    public static ApplicationSecurityDomain getSecurityDomain(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "undertow");
        builder.addNode("application-security-domain", name);
        ModelNode mn = ctx.getModelControllerClient().execute(builder.buildRequest());
        ApplicationSecurityDomain dom = null;
        if (Util.isSuccess(mn)) {
            ModelNode result = mn.get("result");
            String factory = null;
            String secDomain = null;
            if (result.hasDefined("http-authentication-factory")) {
                factory = result.get("http-authentication-factory").asString();
            }
            if (result.hasDefined("security-domain")) {
                secDomain = result.get("security-domain").asString();
            }
            dom = new ApplicationSecurityDomain(name, factory, secDomain);
        }
        return dom;
    }

    public static void writeReferencedSecurityDomain(AuthSecurityBuilder authBuilder, String securityDomain, CommandContext ctx) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("write-attribute");
        builder.addNode("subsystem", "undertow");
        builder.addNode("application-security-domain", securityDomain);
        builder.addProperty("name", "security-domain");
        builder.addProperty("value", authBuilder.getReferencedSecurityDomain());
        authBuilder.getSteps().add(builder.buildRequest());
    }

    public static boolean hasAuthFactory(CommandContext ctx, String securityDomain) throws OperationFormatException, IOException {
        ApplicationSecurityDomain dom = HTTPServer.getSecurityDomain(ctx, securityDomain);
        if (dom != null) {
            return dom.getFactory() != null;
        }
        return false;
    }

    public static void enableHTTPAuthentication(AuthSecurityBuilder builder, String securityDomain, CommandContext ctx) throws Exception {
        DefaultOperationRequestBuilder reqBuilder = new DefaultOperationRequestBuilder();
        reqBuilder.setOperationName("add");
        reqBuilder.addNode("subsystem", "undertow");
        reqBuilder.addNode("application-security-domain", securityDomain);
        if (builder.getReferencedSecurityDomain() == null) {
            reqBuilder.addProperty("http-authentication-factory", builder.getAuthFactory().getName());
        } else {
            reqBuilder.addProperty("security-domain", builder.getReferencedSecurityDomain());
        }
        builder.getSteps().add(reqBuilder.buildRequest());
    }

    public static ModelNode disableHTTPAuthentication(String securityDomain, CommandContext ctx) throws Exception {
        DefaultOperationRequestBuilder reqBuilder = new DefaultOperationRequestBuilder();
        reqBuilder.setOperationName("remove");
        reqBuilder.addNode("subsystem", "undertow");
        reqBuilder.addNode("application-security-domain", securityDomain);
        return reqBuilder.buildRequest();
    }

    public static String getSecurityDomainFactoryName(String securityDomain, CommandContext ctx) throws IOException, OperationFormatException {
        ApplicationSecurityDomain dom = HTTPServer.getSecurityDomain(ctx, securityDomain);
        if (dom != null) {
            return dom.getFactory();
        }
        return null;
    }

    public static String getReferencedSecurityDomainName(String securityDomain, CommandContext ctx) throws IOException, OperationFormatException {
        ApplicationSecurityDomain dom = HTTPServer.getSecurityDomain(ctx, securityDomain);
        if (dom != null) {
            return dom.getSecurityDomain();
        }
        return null;
    }
}

