/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public class SortedMechanismClientServerFactory
extends AbstractDelegatingSaslClientFactory {
    private final Comparator<String> mechanismNameComparator;
    private final SaslMechanismSelector saslMechanismSelector;

    public SortedMechanismClientServerFactory(SaslClientFactory delegate, Comparator<String> mechanismNameComparator) {
        super(delegate);
        this.mechanismNameComparator = Assert.checkNotNullParam("mechanismComparator", mechanismNameComparator);
        this.saslMechanismSelector = null;
    }

    public SortedMechanismClientServerFactory(SaslClientFactory delegate, String ... mechanismNames) {
        super(delegate);
        Assert.checkNotNullParam("mechanismNames", mechanismNames);
        this.saslMechanismSelector = SaslMechanismSelector.NONE.addMechanisms(mechanismNames);
        this.mechanismNameComparator = null;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        String[] sortedMechanisms = (String[])mechanisms.clone();
        Arrays.sort(sortedMechanisms, this.mechanismNameComparator);
        return super.createSaslClient(sortedMechanisms, authorizationId, protocol, serverName, props, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] mechanismNames = super.getMechanismNames(props);
        if (this.mechanismNameComparator != null) {
            Arrays.sort(mechanismNames, this.mechanismNameComparator);
        } else if (this.saslMechanismSelector != null) {
            List<String> mechanismNamesList = new ArrayList<String>(Arrays.asList(mechanismNames));
            mechanismNamesList = this.saslMechanismSelector.apply(mechanismNamesList, null);
            mechanismNames = mechanismNamesList.toArray(new String[mechanismNamesList.size()]);
        }
        return mechanismNames;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SortedMechanismClientServerFactory && this.equals((SortedMechanismClientServerFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof SortedMechanismClientServerFactory && this.equals((SortedMechanismClientServerFactory)other);
    }

    public boolean equals(SortedMechanismClientServerFactory other) {
        return super.equals(other) && this.mechanismNameComparator.equals(other.mechanismNameComparator);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.mechanismNameComparator.hashCode());
    }
}

