/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.HttpServerCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.auth.AbstractEnableAuthenticationCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ApplicationSecurityDomain;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.HTTPServer;
import org.jboss.as.cli.operation.OperationFormatException;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependRejectOptionActivator;

@CommandDefinition(name="enable-http-auth-http-server", description="", activator=HttpServerCommandActivator.class)
public class HTTPServerEnableAuthCommand
extends AbstractEnableAuthenticationCommand {
    @Option(name="security-domain", required=true, completer=SecurityCommand.OptionCompleters.SecurityDomainCompleter.class)
    String securityDomain;
    @Option(name="mechanism", completer=FactoryMechanismCompleter.class, activator=MechanismActivator.class)
    String factoryMechanism;
    @Option(name="referenced-security-domain", completer=SecurityCommand.OptionCompleters.ReferencedSecurityDomainCompleter.class, activator=ReferencedSecurityDomainActivator.class)
    String referencedSecurityDomain;
    private final CommandContext ctx;

    public HTTPServerEnableAuthCommand(CommandContext ctx) {
        super(AuthFactorySpec.HTTP);
        this.ctx = ctx;
    }

    @Override
    protected String getMechanism() {
        return this.factoryMechanism;
    }

    @Override
    protected void secure(CommandContext ctx, AuthSecurityBuilder builder) throws Exception {
        ApplicationSecurityDomain secDomain = HTTPServer.getSecurityDomain(ctx, this.securityDomain);
        if (secDomain != null) {
            if (secDomain.getSecurityDomain() != null && !secDomain.getSecurityDomain().equals(builder.getReferencedSecurityDomain())) {
                HTTPServer.writeReferencedSecurityDomain(builder, this.securityDomain, ctx);
            }
        } else {
            HTTPServer.enableHTTPAuthentication(builder, this.securityDomain, ctx);
        }
    }

    @Override
    protected AuthSecurityBuilder buildSecurityRequest(CommandContext context) throws Exception {
        if (!HTTPServer.isReferencedSecurityDomainSupported(context)) {
            return super.buildSecurityRequest(context);
        }
        AuthSecurityBuilder builder = null;
        if (this.getMechanism() == null) {
            if (this.referencedSecurityDomain == null) {
                this.referencedSecurityDomain = this.getOOTBSecurityDomain(context);
            }
            if (!ElytronUtil.securityDomainExists(context, this.referencedSecurityDomain)) {
                throw new CommandException("Can't enable HTTP Authentication, security domain " + this.referencedSecurityDomain + " doesn't exist");
            }
        } else {
            if (this.referencedSecurityDomain != null) {
                throw new CommandException("Can't mix mechanism and referenced security domain");
            }
            return super.buildSecurityRequest(context);
        }
        builder = new AuthSecurityBuilder(this.referencedSecurityDomain);
        this.secure(context, builder);
        return builder;
    }

    @Override
    protected String getEnabledFactory(CommandContext ctx) throws IOException, OperationFormatException {
        return HTTPServer.getSecurityDomainFactoryName(this.securityDomain, ctx);
    }

    @Override
    protected String getOOTBFactory(CommandContext ctx) throws Exception {
        return ElytronUtil.OOTB_APPLICATION_HTTP_FACTORY;
    }

    protected String getOOTBSecurityDomain(CommandContext ctx) throws Exception {
        return ElytronUtil.OOTB_APPLICATION_DOMAIN;
    }

    @Override
    protected String getSecuredEndpoint(CommandContext ctx) {
        return "security domain " + this.securityDomain;
    }

    public static class MechanismActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> REJECTED = new HashSet<String>();

        public MechanismActivator() {
            super(false, EXPECTED, REJECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            if (!super.isActivated(processedCommand)) {
                return false;
            }
            HTTPServerEnableAuthCommand cmd = (HTTPServerEnableAuthCommand)processedCommand.command();
            try {
                ApplicationSecurityDomain secDomain;
                if (cmd.securityDomain != null && (secDomain = HTTPServer.getSecurityDomain(cmd.ctx, cmd.securityDomain)) != null && secDomain.getFactory() == null) {
                    return false;
                }
            }
            catch (IOException | OperationFormatException ex) {
                return false;
            }
            return super.isActivated(processedCommand);
        }

        static {
            REJECTED.add("referenced-security-domain");
            EXPECTED.add("security-domain");
        }
    }

    public static class ReferencedSecurityDomainActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> REJECTED = new HashSet<String>();

        public ReferencedSecurityDomainActivator() {
            super(false, EXPECTED, REJECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand pc) {
            HTTPServerEnableAuthCommand cmd = (HTTPServerEnableAuthCommand)pc.command();
            try {
                ApplicationSecurityDomain secDomain;
                if (!HTTPServer.isReferencedSecurityDomainSupported(cmd.ctx)) {
                    return false;
                }
                if (cmd.securityDomain != null && (secDomain = HTTPServer.getSecurityDomain(cmd.ctx, cmd.securityDomain)) != null && secDomain.getSecurityDomain() == null) {
                    return false;
                }
                return super.isActivated(pc);
            }
            catch (IOException | OperationFormatException ex) {
                return false;
            }
        }

        static {
            REJECTED.add("mechanism");
            EXPECTED.add("security-domain");
        }
    }

    public static class FactoryMechanismCompleter
    extends SecurityCommand.OptionCompleters.MechanismCompleter {
        @Override
        protected List<String> getItems(CLICompleterInvocation completerInvocation) {
            HTTPServerEnableAuthCommand cmd = (HTTPServerEnableAuthCommand)completerInvocation.getCommand();
            try {
                if (cmd.securityDomain != null) {
                    ApplicationSecurityDomain secDomain = HTTPServer.getSecurityDomain(cmd.ctx, cmd.securityDomain);
                    if (secDomain != null && secDomain.getFactory() == null) {
                        return Collections.emptyList();
                    }
                    return super.getItems(completerInvocation);
                }
                return Collections.emptyList();
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }
    }
}

