/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.impl.Pipe;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;

public class OperationResponseProxy
implements OperationResponse {
    private final ModelNode responseNode;
    private final Map<String, OperationResponse.StreamEntry> proxiedStreams;

    private OperationResponseProxy(ModelNode responseNode, ManagementChannelAssociation channelAssociation, int batchId, ModelNode streamHeader) {
        this.responseNode = responseNode;
        int size = streamHeader.asInt();
        this.proxiedStreams = new LinkedHashMap<String, OperationResponse.StreamEntry>(size);
        for (int i = 0; i < size; ++i) {
            ModelNode headerElement = streamHeader.get(i);
            String uuid = headerElement.require("uuid").asString();
            String mimeType = headerElement.require("mime-type").asString();
            this.proxiedStreams.put(uuid, new ProxiedInputStream(uuid, mimeType, channelAssociation, batchId, i));
        }
    }

    public static OperationResponseProxy create(ModelNode responseNode, ManagementChannelAssociation channelAssociation, int batchId, ModelNode streamHeader) {
        return new OperationResponseProxy(responseNode, channelAssociation, batchId, streamHeader);
    }

    @Override
    public ModelNode getResponseNode() {
        return this.responseNode;
    }

    @Override
    public List<OperationResponse.StreamEntry> getInputStreams() {
        ArrayList<OperationResponse.StreamEntry> result = new ArrayList<OperationResponse.StreamEntry>();
        result.addAll(this.proxiedStreams.values());
        return Collections.unmodifiableList(result);
    }

    @Override
    public OperationResponse.StreamEntry getInputStream(String uuid) {
        return this.proxiedStreams.get(uuid);
    }

    @Override
    public void close() throws IOException {
        for (OperationResponse.StreamEntry se : this.proxiedStreams.values()) {
            se.getStream().close();
        }
    }

    private static class ProxiedInputStream
    extends InputStream
    implements OperationResponse.StreamEntry {
        static final int BUFFER_SIZE = 8192;
        private final String uuid;
        private final String mimeType;
        private final int index;
        private final int batchId;
        private final Pipe pipe;
        private final ManagementChannelAssociation channelAssociation;
        private volatile boolean remoteClosed;
        private boolean remoteRead;
        private volatile Exception error;

        ProxiedInputStream(String uuid, String mimeType, ManagementChannelAssociation channelAssociation, int batchId, int index) {
            this.uuid = uuid;
            this.mimeType = mimeType;
            this.channelAssociation = channelAssociation;
            this.batchId = batchId;
            this.index = index;
            this.pipe = new Pipe(8192);
        }

        @Override
        public int read() throws IOException {
            if (this.available() < 1) {
                this.readRemote();
            }
            return this.pipe.getIn().read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.available() < len) {
                this.readRemote();
            }
            return this.pipe.getIn().read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            IOException ex;
            block8: {
                block7: {
                    ex = null;
                    try {
                        this.closeRemote();
                    }
                    catch (IOException e) {
                        ex = e;
                    }
                    try {
                        this.pipe.getOut().close();
                    }
                    catch (IOException e) {
                        if (ex != null) break block7;
                        ex = e;
                    }
                }
                try {
                    this.pipe.getIn().close();
                }
                catch (IOException e) {
                    if (ex != null) break block8;
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        @Override
        public int available() throws IOException {
            return this.pipe.getIn().available();
        }

        private void readRemote() throws IOException {
            this.readInputStream();
            this.throwIfError();
        }

        private synchronized void readInputStream() {
            if (this.remoteRead || this.remoteClosed) {
                return;
            }
            final OutputStream os = this.pipe.getOut();
            AbstractManagementRequest<Void, Void> getISRequest = new AbstractManagementRequest<Void, Void>(){

                @Override
                public byte getOperationType() {
                    return 79;
                }

                @Override
                protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
                    output.write(97);
                    output.writeInt(batchId);
                    output.write(102);
                    output.writeInt(index);
                }

                @Override
                public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context) throws IOException {
                    try {
                        IOException pipeWriteException = null;
                        block4: while (true) {
                            byte header;
                            if ((header = input.readByte()) == 96) {
                                remoteClosed = true;
                                break;
                            }
                            ProtocolUtils.expectHeader(header, 103);
                            int size = input.readInt();
                            ProtocolUtils.expectHeader(input, 104);
                            byte[] buffer = new byte[8192];
                            int totalRead = 0;
                            while (true) {
                                if (totalRead >= size) continue block4;
                                int len = Math.min(size - totalRead, buffer.length);
                                input.readFully(buffer, 0, len);
                                if (pipeWriteException == null) {
                                    try {
                                        os.write(buffer, 0, len);
                                    }
                                    catch (IOException e) {
                                        pipeWriteException = e;
                                    }
                                }
                                totalRead += len;
                            }
                            break;
                        }
                        os.close();
                        if (pipeWriteException != null) {
                            throw pipeWriteException;
                        }
                        resultHandler.done(null);
                    }
                    catch (IOException e) {
                        this.shutdown(e);
                        resultHandler.failed(e);
                        throw e;
                    }
                }
            };
            try {
                this.channelAssociation.executeRequest(getISRequest, null);
                this.remoteRead = true;
            }
            catch (IOException e) {
                this.shutdown(e);
            }
        }

        private void closeRemote() throws IOException {
            if (!this.remoteClosed) {
                AbstractManagementRequest<Void, Void> closeRequest = new AbstractManagementRequest<Void, Void>(){

                    @Override
                    public byte getOperationType() {
                        return 68;
                    }

                    @Override
                    protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
                        output.write(97);
                        output.writeInt(batchId);
                        output.write(102);
                        output.writeInt(index);
                    }

                    @Override
                    public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context) throws IOException {
                        remoteClosed = true;
                    }
                };
                this.channelAssociation.executeRequest(closeRequest, null);
            }
        }

        private void throwIfError() throws IOException {
            if (this.error != null) {
                if (this.error instanceof IOException) {
                    throw (IOException)this.error;
                }
                throw new IOException(this.error);
            }
        }

        private void shutdown(Exception error) {
            StreamUtils.safeClose(this);
            this.error = error;
        }

        @Override
        public String getUUID() {
            return this.uuid;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public InputStream getStream() {
            return this;
        }
    }
}

