/*
 * Decompiled with CFR 0.152.
 */
package __redirected;

import __redirected.ConstructorSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.ModuleLogger;

public final class __RedirectedUtils {
    static ModuleLogger getModuleLogger() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ModuleLogger>(){

                @Override
                public ModuleLogger run() {
                    return Module.getModuleLogger();
                }
            });
        }
        return Module.getModuleLogger();
    }

    static RuntimeException rethrowCause(Throwable t) throws Error {
        try {
            throw t.getCause();
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException re) {
            return re;
        }
        catch (Throwable throwable) {
            return new UndeclaredThrowableException(throwable);
        }
    }

    static <E extends Throwable> E wrapped(E e, Throwable orig) {
        Throwable cause = orig.getCause();
        if (cause != null) {
            e.initCause(cause);
        }
        e.setStackTrace(orig.getStackTrace());
        return e;
    }

    static <T> Supplier<T> loadProvider(String id, Class<T> intf, ModuleLoader moduleLoader) {
        return __RedirectedUtils.loadProvider(id, intf, moduleLoader, null);
    }

    static <T> Supplier<T> loadProvider(String id, Class<T> intf, ModuleLoader moduleLoader, String name) {
        Module module;
        try {
            module = moduleLoader.loadModule(id);
        }
        catch (ModuleLoadException e) {
            __RedirectedUtils.getModuleLogger().providerUnloadable(id, null);
            return null;
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        return __RedirectedUtils.loadProvider(intf, classLoader, name);
    }

    static <T> Supplier<T> loadProvider(Class<T> intf, ClassLoader classLoader) {
        return __RedirectedUtils.loadProvider(intf, classLoader, null);
    }

    static <T> Supplier<T> loadProvider(Class<T> intf, ClassLoader classLoader, String name) {
        List<String> names = __RedirectedUtils.findProviderClassNames(intf, classLoader, name);
        if (names.isEmpty()) {
            __RedirectedUtils.getModuleLogger().providerUnloadable("Not found", classLoader);
            return null;
        }
        String clazzName = names.get(0);
        try {
            return new ConstructorSupplier<T>(classLoader.loadClass(clazzName).asSubclass(intf).getConstructor(new Class[0]));
        }
        catch (Exception ignore) {
            __RedirectedUtils.getModuleLogger().providerUnloadable(clazzName, classLoader);
            return null;
        }
    }

    static <T> List<Supplier<T>> loadProviders(Class<T> intf, ClassLoader classLoader) {
        return __RedirectedUtils.loadProviders(intf, classLoader, null);
    }

    static <T> List<Supplier<T>> loadProviders(Class<T> intf, ClassLoader classLoader, String name) {
        List<String> names = __RedirectedUtils.findProviderClassNames(intf, classLoader, name);
        if (names.size() < 1) {
            __RedirectedUtils.getModuleLogger().providerUnloadable("Not found", classLoader);
            return Collections.emptyList();
        }
        ArrayList<Supplier<T>> suppliers = new ArrayList<Supplier<T>>();
        for (String className : names) {
            try {
                suppliers.add(new ConstructorSupplier<T>(classLoader.loadClass(className).asSubclass(intf).getConstructor(new Class[0])));
            }
            catch (Exception ignore) {
                __RedirectedUtils.getModuleLogger().providerUnloadable(className, classLoader);
            }
        }
        return suppliers;
    }

    static <T> List<String> findProviderClassNames(Class<T> intf, ClassLoader loader, String name) {
        block24: {
            if (name == null) {
                name = intf.getName();
            }
            try {
                Enumeration<URL> resources = loader.getResources("META-INF/services/" + name);
                if (!resources.hasMoreElements()) break block24;
                ArrayList<String> list = new ArrayList<String>();
                do {
                    URL url = resources.nextElement();
                    URLConnection connection = url.openConnection();
                    try (InputStream is = connection.getInputStream();
                         InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                         BufferedReader reader = new BufferedReader(isr);){
                        String line;
                        while ((line = __RedirectedUtils.readLine(reader)) != null) {
                            int i = line.indexOf(35);
                            if (i != -1) {
                                line = line.substring(0, i);
                            }
                            if ((line = line.trim()).length() == 0 || line.startsWith("__redirected")) continue;
                            list.add(line);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                } while (resources.hasMoreElements());
                return list;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException ignore) {
            return null;
        }
    }
}

