/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.session.SessionContext;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.util.ElytronMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class ElytronFilePasswordProvider
implements FilePasswordProvider {
    private final ExceptionSupplier<CredentialSource, XMLStreamException> credentialSourceSupplier;
    private final Credential credential;

    public ElytronFilePasswordProvider(ExceptionSupplier<CredentialSource, XMLStreamException> credentialSourceSupplier) {
        this.credentialSourceSupplier = credentialSourceSupplier;
        this.credential = null;
    }

    public ElytronFilePasswordProvider(Credential credential) {
        this.credentialSourceSupplier = null;
        this.credential = credential;
    }

    @Override
    public String getPassword(SessionContext session, NamedResource resourceKey, int retryIndex) throws IOException {
        char[] password = null;
        if (this.credentialSourceSupplier != null) {
            CredentialSource credentialSource = null;
            try {
                credentialSource = this.credentialSourceSupplier.get();
            }
            catch (XMLStreamException e) {
                throw ElytronMessages.log.xmlFailedToCreateCredential(e);
            }
            password = credentialSource.applyToCredential(PasswordCredential.class, c -> c.getPassword().castAndApply(ClearPassword.class, ClearPassword::getPassword));
        } else if (this.credential != null) {
            password = this.credential.castAndApply(PasswordCredential.class, c -> c.getPassword().castAndApply(ClearPassword.class, ClearPassword::getPassword));
        }
        if (password == null) {
            throw ElytronMessages.log.xmlFailedToCreateCredential(new NullPointerException());
        }
        return new String(password);
    }
}

