/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;

public interface XAOutflowHandle {
    public int getRemainingTime();

    public void forgetEnlistment();

    public void nonMasterEnlistment();

    public void verifyEnlistment() throws RollbackException, SystemException;

    @NotNull
    public Xid getXid();

    public static XAOutflowHandle createSimple(final Xid xid, final int timeout) {
        Assert.checkNotNullParam("xid", xid);
        Assert.checkMinimumParameter("timeout", 0, timeout);
        return new XAOutflowHandle(){
            private long start = System.nanoTime();

            @Override
            @NotNull
            public Xid getXid() {
                return xid;
            }

            @Override
            public int getRemainingTime() {
                long elapsed = System.nanoTime() - this.start;
                return timeout - (int)Math.max((long)timeout, elapsed / 1000000000L);
            }

            @Override
            public void forgetEnlistment() {
            }

            @Override
            public void nonMasterEnlistment() {
            }

            @Override
            public void verifyEnlistment() {
            }
        };
    }
}

