/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.DefaultMessageFactory;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.MessageFactory;
import org.jgroups.PhysicalAddress;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.conf.AttributeType;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.AlternatingBundler;
import org.jgroups.protocols.AsyncNoBundler;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.LocalTransport;
import org.jgroups.protocols.MsgStats;
import org.jgroups.protocols.NoBundler;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.RemoveQueueBundler;
import org.jgroups.protocols.RingBufferBundler;
import org.jgroups.protocols.RingBufferBundlerLockless;
import org.jgroups.protocols.RingBufferBundlerLockless2;
import org.jgroups.protocols.SenderSendsBundler;
import org.jgroups.protocols.SimplifiedTransferQueueBundler;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.TransferQueueBundler;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AsciiString;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ExpiryCache;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.MaxOneThreadPerSender;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.SubmitToThreadPool;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadPool;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeScheduler3;
import org.jgroups.util.TimeService;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Transport protocol")
public abstract class TP
extends Protocol
implements DiagnosticsHandler.ProbeHandler {
    public static final byte LIST = 1;
    public static final byte MULTICAST = 2;
    public static final int MSG_OVERHEAD = 3;
    protected static final long MIN_WAIT_BETWEEN_DISCOVERIES = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
    @LocalAddress
    @Property(name="bind_addr", description="The bind address which should be used by this transport. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL, NON_LOOPBACK, match-interface, match-host, match-address", defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr;
    @Property(description="Used to map the internal port (bind_port) to an external port. Only used if > 0", systemProperty={"jgroups.external_port"}, writable=false)
    protected int external_port;
    @ManagedAttribute(description="tracing is enabled or disabled for the given log", writable=true)
    protected boolean is_trace;
    @Property(description="If true, the transport should use all available interfaces to receive multicast messages")
    protected boolean receive_on_all_interfaces;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addresses or interface names) to receive multicasts on")
    protected List<NetworkInterface> receive_interfaces;
    @Property(description="Max number of elements in the logical address cache before eviction starts")
    protected int logical_addr_cache_max_size;
    @Property(description="Time (in ms) after which entries in the logical address cache marked as removable can be removed. 0 never removes any entries (not recommended)", type=AttributeType.TIME)
    protected long logical_addr_cache_expiration;
    @Property(description="Interval (in ms) at which the reaper task scans logical_addr_cache and removes entries marked as removable. 0 disables reaping.", type=AttributeType.TIME)
    protected long logical_addr_cache_reaper_interval;
    @Property(description="The port to which the transport binds. Default of 0 binds to any (ephemeral) port. See also port_range", systemProperty={"jgroups.bind_port"}, writable=false)
    protected int bind_port;
    @Property(description="The range of valid ports: [bind_port .. bind_port+port_range ]. 0 only binds to bind_port and fails if taken")
    protected int port_range;
    @Property(description="Whether or not to make a copy of a message before looping it back up. Don't use this; might get removed without warning")
    protected boolean loopback_copy;
    @Property(description="Loop back the message on a separate thread or use the current thread. Don't use this; might get removed without warning")
    protected boolean loopback_separate_thread;
    @Property(description="The fully qualified name of a class implementing MessageProcessingPolicy")
    protected String message_processing_policy;
    @Property(description="The fully qualified name of a class implementing LocalTransport")
    protected String local_transport_class;
    @Property(description="If true, create virtual threads (Loom, if available), otherwise create native threads")
    protected boolean use_virtual_threads;
    @Property(description="Thread naming pattern for threads in this channel. Valid values are \"pcl\": \"p\": includes the thread name, e.g. \"Incoming thread-1\", \"UDP ucast receiver\", \"c\": includes the cluster name, e.g. \"MyCluster\", \"l\": includes the local address of the current member, e.g. \"192.168.5.1:5678\"")
    protected String thread_naming_pattern;
    @Property(description="Interval (in ms) at which the time service updates its timestamp. 0 disables the time service", type=AttributeType.TIME)
    protected long time_service_interval;
    @Property(description="whether or not warnings about messages from different groups are logged")
    protected boolean log_discard_msgs;
    @Property(description="whether or not warnings about messages from members with a different version are discarded")
    protected boolean log_discard_msgs_version;
    @Property(description="Timeout (in ms) to determine how long to wait until a request to fetch the physical address for a given logical address will be sent again. Subsequent requests for the same physical address will therefore be spaced at least who_has_cache_timeout ms apart", type=AttributeType.TIME)
    protected long who_has_cache_timeout;
    @Property(description="Time during which identical warnings about messages from a member with a different version will be suppressed. 0 disables this (every warning will be logged). Setting the log level to ERROR also disables this.", type=AttributeType.TIME)
    protected long suppress_time_different_version_warnings;
    @Property(description="Time during which identical warnings about messages from a member from a different cluster will be suppressed. 0 disables this (every warning will be logged). Setting the log level to ERROR also disables this.", type=AttributeType.TIME)
    protected long suppress_time_different_cluster_warnings;
    @Property(description="The fully qualified name of a MessageFactory implementation", exposeAsManagedAttribute=false)
    protected String msg_factory_class;
    protected MessageFactory msg_factory;
    @Property(description="The type of bundler used (\"ring-buffer\", \"transfer-queue\" (default), \"sender-sends\" or \"no-bundler\") or the fully qualified classname of a Bundler implementation")
    protected String bundler_type;
    @Component(name="msg_stats")
    protected final MsgStats msg_stats;
    @ManagedAttribute(description="Channel (cluster) name")
    protected AsciiString cluster_name;
    @ManagedAttribute(description="If enabled, the timer will run non-blocking tasks on its own (runner) thread, and not submit them to the thread pool. Otherwise, all tasks are submitted to the thread pool. This attribute is experimental and may be removed without notice.")
    protected boolean timer_handle_non_blocking_tasks;
    protected PhysicalAddress local_physical_addr;
    protected volatile View view;
    protected final Set<Address> members;
    protected final ReentrantLock connectLock;
    @Component(name="thread_pool")
    protected ThreadPool thread_pool;
    protected ThreadFactory thread_factory;
    protected TimeScheduler timer;
    protected TimeService time_service;
    protected SocketFactory socket_factory;
    @Component(name="bundler")
    protected Bundler bundler;
    @Component(name="msg_processing_policy")
    protected MessageProcessingPolicy msg_processing_policy;
    @Component(name="local_transport")
    protected LocalTransport local_transport;
    @Component(name="diag")
    protected DiagnosticsHandler diag_handler;
    protected TpHeader header;
    protected LazyRemovalCache<Address, PhysicalAddress> logical_addr_cache;
    protected long last_discovery_request;
    protected Future<?> logical_addr_cache_reaper;
    protected final AverageMinMax avg_batch_size;
    protected static final LazyRemovalCache.Printable<Address, LazyRemovalCache.Entry<PhysicalAddress>> print_function = (logical_addr, entry) -> {
        StringBuilder sb = new StringBuilder();
        String tmp_logical_name = NameCache.get(logical_addr);
        if (tmp_logical_name != null) {
            sb.append(tmp_logical_name).append(": ");
        }
        if (logical_addr instanceof UUID) {
            sb.append(((UUID)logical_addr).toStringLong()).append(": ");
        }
        sb.append(entry.toString(val -> val instanceof PhysicalAddress ? val.printIpAddress() : val.toString()));
        sb.append("\n");
        return sb.toString();
    };
    protected ExpiryCache<Address> who_has_cache;
    protected SuppressLog<Address> suppress_log_different_version;
    protected SuppressLog<Address> suppress_log_different_cluster;

    @ManagedAttribute(description="Fully qualified classname of bundler")
    public String getBundlerClass() {
        return this.bundler != null ? this.bundler.getClass().getName() : "null";
    }

    public MessageFactory getMessageFactory() {
        return this.msg_factory;
    }

    public <T extends TP> T setMessageFactory(MessageFactory m) {
        this.msg_factory = m;
        return (T)this;
    }

    public InetAddress getBindAddr() {
        return this.bind_addr;
    }

    public <T extends TP> T setBindAddr(InetAddress b) {
        this.bind_addr = b;
        return (T)this;
    }

    public InetAddress getExternalAddr() {
        return this.external_addr;
    }

    public <T extends TP> T setExternalAddr(InetAddress e) {
        this.external_addr = e;
        return (T)this;
    }

    public int getExternalPort() {
        return this.external_port;
    }

    public <T extends TP> T setExternalPort(int e) {
        this.external_port = e;
        return (T)this;
    }

    public boolean isTrace() {
        return this.is_trace;
    }

    public <T extends TP> T isTrace(boolean i) {
        this.is_trace = i;
        return (T)this;
    }

    public boolean receiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public <T extends TP> T receiveOnAllInterfaces(boolean r) {
        this.receive_on_all_interfaces = r;
        return (T)this;
    }

    public int getLogicalAddrCacheMaxSize() {
        return this.logical_addr_cache_max_size;
    }

    public <T extends TP> T setLogicalAddrCacheMaxSize(int l) {
        this.logical_addr_cache_max_size = l;
        return (T)this;
    }

    public long getLogicalAddrCacheExpiration() {
        return this.logical_addr_cache_expiration;
    }

    public <T extends TP> T setLogicalAddrCacheExpiration(long l) {
        this.logical_addr_cache_expiration = l;
        return (T)this;
    }

    public long getLogicalAddrCacheReaperInterval() {
        return this.logical_addr_cache_reaper_interval;
    }

    public <T extends TP> T setLogicalAddrCacheReaperInterval(long l) {
        this.logical_addr_cache_reaper_interval = l;
        return (T)this;
    }

    public boolean loopbackCopy() {
        return this.loopback_copy;
    }

    public <T extends TP> T loopbackCopy(boolean l) {
        this.loopback_copy = l;
        return (T)this;
    }

    public boolean loopbackSeparateThread() {
        return this.loopback_separate_thread;
    }

    public <T extends TP> T loopbackSeparateThread(boolean l) {
        this.loopback_separate_thread = l;
        return (T)this;
    }

    public boolean useVirtualThreads() {
        return this.use_virtual_threads;
    }

    public <T extends TP> T useVirtualThreads(boolean b) {
        this.use_virtual_threads = b;
        return (T)this;
    }

    public long getTimeServiceInterval() {
        return this.time_service_interval;
    }

    public <T extends TP> T setTimeServiceInterval(long t) {
        this.time_service_interval = t;
        return (T)this;
    }

    public boolean logDiscardMsgs() {
        return this.log_discard_msgs;
    }

    public <T extends TP> T logDiscardMsgs(boolean l) {
        this.log_discard_msgs = l;
        return (T)this;
    }

    public boolean logDiscardMsgsVersion() {
        return this.log_discard_msgs_version;
    }

    public <T extends TP> T logDiscardMsgsVersion(boolean l) {
        this.log_discard_msgs_version = l;
        return (T)this;
    }

    public long getWhoHasCacheTimeout() {
        return this.who_has_cache_timeout;
    }

    public <T extends TP> T setWhoHasCacheTimeout(long w) {
        this.who_has_cache_timeout = w;
        return (T)this;
    }

    public long getSuppressTimeDifferentVersionWarnings() {
        return this.suppress_time_different_version_warnings;
    }

    public <T extends TP> T setSuppressTimeDifferentVersionWarnings(long s) {
        this.suppress_time_different_version_warnings = s;
        return (T)this;
    }

    public long getSuppressTimeDifferentClusterWarnings() {
        return this.suppress_time_different_cluster_warnings;
    }

    public <T extends TP> T setSuppressTimeDifferentClusterWarnings(long s) {
        this.suppress_time_different_cluster_warnings = s;
        return (T)this;
    }

    public String getMsgFactoryClass() {
        return this.msg_factory_class;
    }

    public <T extends TP> T setMsgFactoryClass(String m) {
        this.msg_factory_class = m;
        return (T)this;
    }

    public String getBundlerType() {
        return this.bundler_type;
    }

    public <T extends TP> T setBundlerType(String b) {
        this.bundler_type = b;
        return (T)this;
    }

    @ManagedAttribute
    public String getMessageFactoryClass() {
        return this.msg_factory != null ? this.msg_factory.getClass().getName() : "n/a";
    }

    @ManagedAttribute(description="Is the logical_addr_cache reaper task running")
    public boolean isLogicalAddressCacheReaperRunning() {
        return this.logical_addr_cache_reaper != null && !this.logical_addr_cache_reaper.isDone();
    }

    @ManagedAttribute(description="Returns the average batch size of received batches")
    public String getAvgBatchSize() {
        return this.avg_batch_size.toString();
    }

    public AverageMinMax avgBatchSize() {
        return this.avg_batch_size;
    }

    @Override
    @Property(name="level", description="Sets the level")
    public <T extends Protocol> T setLevel(String level) {
        Object retval = super.setLevel(level);
        this.is_trace = this.log.isTraceEnabled();
        return retval;
    }

    @ManagedOperation(description="Changes the message processing policy. The fully qualified name of a class implementing MessageProcessingPolicy needs to be given")
    public void setMessageProcessingPolicy(String policy) {
        if (policy == null) {
            return;
        }
        this.msg_processing_policy = policy.startsWith("submit") ? new SubmitToThreadPool() : (policy.startsWith("max") ? new MaxOneThreadPerSender() : null);
        try {
            if (this.msg_processing_policy == null) {
                Class<?> clazz = Util.loadClass(policy, this.getClass());
                this.msg_processing_policy = (MessageProcessingPolicy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.message_processing_policy = policy;
            }
            this.msg_processing_policy.init(this);
        }
        catch (Exception e) {
            this.log.error("failed setting message_processing_policy", e);
        }
    }

    @ManagedAttribute(description="Class of the timer implementation")
    public String getTimerClass() {
        return this.timer != null ? this.timer.getClass().getSimpleName() : "null";
    }

    @ManagedAttribute(description="Name of the cluster to which this transport is connected")
    public String getClusterName() {
        return this.cluster_name != null ? this.cluster_name.toString() : null;
    }

    public AsciiString getClusterNameAscii() {
        return this.cluster_name;
    }

    @ManagedAttribute(description="Number of messages from members in a different cluster")
    public int getDifferentClusterMessages() {
        return this.suppress_log_different_cluster != null ? this.suppress_log_different_cluster.getCache().size() : 0;
    }

    @ManagedAttribute(description="Number of messages from members with a different JGroups version")
    public int getDifferentVersionMessages() {
        return this.suppress_log_different_version != null ? this.suppress_log_different_version.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the cache for messages from different clusters")
    public <T extends TP> T clearDifferentClusterCache() {
        if (this.suppress_log_different_cluster != null) {
            this.suppress_log_different_cluster.getCache().clear();
        }
        return (T)this;
    }

    @ManagedOperation(description="Clears the cache for messages from members with different versions")
    public <T extends TP> T clearDifferentVersionCache() {
        if (this.suppress_log_different_version != null) {
            this.suppress_log_different_version.getCache().clear();
        }
        return (T)this;
    }

    @ManagedAttribute(description="Type of logger used")
    public static String loggerType() {
        return LogFactory.loggerType();
    }

    @ManagedOperation(description="If enabled, the timer will run non-blocking tasks on its own (runner) thread, and not submit them to the thread pool. Otherwise, all tasks are submitted to the thread pool. This attribute is experimental and may be removed without notice.")
    public <T extends TP> T enableBlockingTimerTasks(boolean flag) {
        if (flag != this.timer_handle_non_blocking_tasks) {
            this.timer_handle_non_blocking_tasks = flag;
            this.timer.setNonBlockingTaskHandling(flag);
        }
        return (T)this;
    }

    protected TP() {
        this.is_trace = this.log.isTraceEnabled();
        this.logical_addr_cache_max_size = 2000;
        this.logical_addr_cache_expiration = 360000L;
        this.logical_addr_cache_reaper_interval = 60000L;
        this.port_range = 10;
        this.loopback_separate_thread = true;
        this.thread_naming_pattern = "cl";
        this.time_service_interval = 500L;
        this.log_discard_msgs = true;
        this.log_discard_msgs_version = true;
        this.who_has_cache_timeout = 2000L;
        this.suppress_time_different_version_warnings = 60000L;
        this.suppress_time_different_cluster_warnings = 60000L;
        this.msg_factory = new DefaultMessageFactory();
        this.bundler_type = "transfer-queue";
        this.msg_stats = new MsgStats();
        this.timer_handle_non_blocking_tasks = true;
        this.members = new CopyOnWriteArraySet<Address>();
        this.connectLock = new ReentrantLock();
        this.thread_pool = new ThreadPool(this);
        this.socket_factory = new DefaultSocketFactory();
        this.msg_processing_policy = new MaxOneThreadPerSender();
        this.avg_batch_size = new AverageMinMax();
    }

    public MsgStats getMessageStats() {
        return this.msg_stats;
    }

    public abstract boolean supportsMulticasting();

    public boolean isMulticastCapable() {
        return this.supportsMulticasting();
    }

    public LazyRemovalCache<Address, PhysicalAddress> getLogicalAddressCache() {
        return this.logical_addr_cache;
    }

    public String toString() {
        return this.local_addr != null ? this.getName() + "(local address: " + String.valueOf(this.local_addr) + ")" : this.getName();
    }

    @Override
    public <T extends Protocol> T setAddress(Address addr) {
        super.setAddress(addr);
        this.registerLocalAddress(addr);
        return (T)this;
    }

    public PhysicalAddress localPhysicalAddress() {
        return this.local_physical_addr;
    }

    public View view() {
        return this.view;
    }

    @ManagedAttribute(description="The physical address of the channel")
    public String getLocalPhysicalAddress() {
        return this.local_physical_addr != null ? this.local_physical_addr.printIpAddress() : null;
    }

    @Override
    public void resetStats() {
        this.msg_stats.reset();
        this.avg_batch_size.clear();
        this.msg_processing_policy.reset();
        if (this.local_transport != null) {
            this.local_transport.resetStats();
        }
    }

    public <T extends TP> T registerProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        this.diag_handler.registerProbeHandler(handler);
        return (T)this;
    }

    public <T extends TP> T unregisterProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        this.diag_handler.unregisterProbeHandler(handler);
        return (T)this;
    }

    public DiagnosticsHandler getDiagnosticsHandler() {
        return this.diag_handler;
    }

    public <T extends TP> T setDiagnosticsHandler(DiagnosticsHandler handler) throws Exception {
        if (handler != null) {
            this.diag_handler.stop();
            this.diag_handler = handler;
            this.diag_handler.start();
        }
        return (T)this;
    }

    public LocalTransport getLocalTransport() {
        return this.local_transport;
    }

    public <T extends TP> T setLocalTransport(LocalTransport l) {
        if (this.local_transport != null) {
            this.local_transport.resetStats();
            this.local_transport.stop();
            this.local_transport.destroy();
            this.local_transport_class = null;
        }
        this.local_transport = l;
        if (this.local_transport != null) {
            try {
                this.local_transport_class = l.getClass().toString();
                this.local_transport.init(this);
                this.local_transport.start();
            }
            catch (Exception ex) {
                this.log.error("failed setting new local transport", ex);
            }
        }
        return (T)this;
    }

    public <T extends TP> T setLocalTransport(String tp_class) throws Exception {
        if (tp_class == null || tp_class.trim().equals("null")) {
            return this.setLocalTransport((LocalTransport)null);
        }
        Class<?> cl = Util.loadClass(tp_class, this.getClass());
        LocalTransport ltp = (LocalTransport)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return this.setLocalTransport(ltp);
    }

    public Bundler getBundler() {
        return this.bundler;
    }

    public <T extends TP> T setBundler(Bundler bundler) {
        if (bundler != null) {
            this.bundler = bundler;
        }
        return (T)this;
    }

    public ThreadPool getThreadPool() {
        return this.thread_pool;
    }

    public <T extends TP> T setThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            this.thread_pool.destroy();
        }
        this.thread_pool.setThreadPool(thread_pool);
        return (T)this;
    }

    public ThreadFactory getThreadPoolThreadFactory() {
        return this.thread_factory;
    }

    public <T extends TP> T setThreadPoolThreadFactory(ThreadFactory factory) {
        this.thread_factory = factory;
        if (this.thread_pool != null) {
            this.thread_pool.setThreadFactory(factory);
        }
        return (T)this;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public <T extends TP> T setTimer(TimeScheduler timer) {
        this.timer = timer;
        return (T)this;
    }

    public TimeService getTimeService() {
        return this.time_service;
    }

    public <T extends TP> T setTimeService(TimeService ts) {
        if (ts == null) {
            return (T)this;
        }
        if (this.time_service != null) {
            this.time_service.stop();
        }
        this.time_service = ts;
        this.time_service.start();
        return (T)this;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.thread_factory;
    }

    public <T extends TP> T setThreadFactory(ThreadFactory factory) {
        this.thread_factory = factory;
        return (T)this;
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        if (factory != null) {
            this.socket_factory = factory;
        }
    }

    public String getThreadNamingPattern() {
        return this.thread_naming_pattern;
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public <T extends TP> T setBindAddress(InetAddress a) {
        this.bind_addr = a;
        return (T)this;
    }

    public int getBindPort() {
        return this.bind_port;
    }

    public <T extends TP> T setBindPort(int port) {
        this.bind_port = port;
        return (T)this;
    }

    public <T extends TP> T setBindToAllInterfaces(boolean f) {
        this.receive_on_all_interfaces = f;
        return (T)this;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public <T extends TP> T setPortRange(int range) {
        this.port_range = range;
        return (T)this;
    }

    public int getPortRange() {
        return this.port_range;
    }

    @ManagedAttribute(name="timer_tasks", description="Number of timer tasks queued up for execution")
    public int getNumTimerTasks() {
        return this.timer.size();
    }

    @ManagedOperation
    public String dumpTimerTasks() {
        return this.timer.dumpTimerTasks();
    }

    @ManagedOperation(description="Purges cancelled tasks from the timer queue")
    public void removeCancelledTimerTasks() {
        this.timer.removeCancelledTasks();
    }

    @ManagedAttribute(description="Number of threads currently in the pool")
    public int getTimerThreads() {
        return this.timer.getCurrentThreads();
    }

    @ManagedAttribute(description="Returns the number of live threads in the JVM")
    public static int getNumThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public <T extends TP> T setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
        return (T)this;
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    public <T extends TP> T setLogDiscardMessagesVersion(boolean f) {
        this.log_discard_msgs_version = f;
        return (T)this;
    }

    public boolean getLogDiscardMessagesVersion() {
        return this.log_discard_msgs_version;
    }

    @ManagedOperation(description="Dumps the contents of the logical address cache")
    public String printLogicalAddressCache() {
        return this.logical_addr_cache.printCache(print_function);
    }

    @ManagedOperation(description="Prints the contents of the who-has cache")
    public String printWhoHasCache() {
        return this.who_has_cache.toString();
    }

    @ManagedOperation(description="Evicts elements in the logical address cache which have expired")
    public void evictLogicalAddressCache() {
        this.evictLogicalAddressCache(false);
    }

    public void evictLogicalAddressCache(boolean force) {
        this.logical_addr_cache.removeMarkedElements(force);
        this.fetchLocalAddresses();
    }

    public String defaultHeaders(boolean detailed) {
        int num_members = this.view != null ? this.view.size() : 0;
        String fmt = detailed ? "%s (ip=%s)\nview=%s\ncluster=%s\nversion=%s\n" : "%s [ip=%s, %d mbr(s), cluster=%s, version=%s]\n";
        return String.format(fmt, this.local_addr != null ? this.local_addr.toString() : "n/a", this.local_physical_addr, detailed ? this.view : Integer.valueOf(num_members), this.cluster_name, Version.description);
    }

    public abstract void sendUnicast(PhysicalAddress var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract String getInfo();

    @Override
    public void init() throws Exception {
        this.id = ClassConfigurator.getProtocolId(TP.class);
        if (this.use_virtual_threads && !Util.fibersAvailable()) {
            this.log.warn("use_virtual_threads was set to false, as virtual threads are not available in this Java version");
            this.use_virtual_threads = false;
        }
        if (this.local_transport_class != null) {
            Class<?> cl = Util.loadClass(this.local_transport_class, this.getClass());
            this.local_transport = (LocalTransport)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.local_transport.init(this);
        }
        if (this.thread_factory == null) {
            this.thread_factory = ((DefaultThreadFactory)new LazyThreadFactory("jgroups", false, true).useFibers(this.use_virtual_threads)).log(this.log);
        }
        this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
        this.diag_handler = this.createDiagnosticsHandler();
        this.who_has_cache = new ExpiryCache(this.who_has_cache_timeout);
        if (this.suppress_time_different_version_warnings > 0L) {
            this.suppress_log_different_version = new SuppressLog(this.log, "VersionMismatch", "SuppressMsg");
        }
        if (this.suppress_time_different_cluster_warnings > 0L) {
            this.suppress_log_different_cluster = new SuppressLog(this.log, "MsgDroppedDiffCluster", "SuppressMsg");
        }
        if (this.timer == null) {
            this.timer = new TimeScheduler3(this.thread_pool, this.thread_factory, false);
            this.timer.setNonBlockingTaskHandling(this.timer_handle_non_blocking_tasks);
        }
        if (this.time_service_interval > 0L) {
            this.time_service = new TimeService(this.timer, this.time_service_interval);
        }
        HashMap<String, Serializable> m = new HashMap<String, Serializable>(2);
        if (this.bind_addr != null) {
            m.put("bind_addr", this.bind_addr);
        }
        if (this.external_addr != null) {
            m.put("external_addr", this.external_addr);
        }
        if (this.external_port > 0) {
            m.put("external_port", Integer.valueOf(this.external_port));
        }
        if (!m.isEmpty()) {
            this.up(new Event(56, m));
        }
        this.logical_addr_cache = new LazyRemovalCache(this.logical_addr_cache_max_size, this.logical_addr_cache_expiration);
        if (this.logical_addr_cache_reaper_interval > 0L && (this.logical_addr_cache_reaper == null || this.logical_addr_cache_reaper.isDone())) {
            this.logical_addr_cache_reaper = this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TP.this.evictLogicalAddressCache();
                }

                public String toString() {
                    return TP.this.getClass().getSimpleName() + ": LogicalAddressCacheReaper (interval=" + TP.this.logical_addr_cache_reaper_interval + " ms)";
                }
            }, this.logical_addr_cache_reaper_interval, this.logical_addr_cache_reaper_interval, TimeUnit.MILLISECONDS, false);
        }
        if (this.message_processing_policy != null) {
            this.setMessageProcessingPolicy(this.message_processing_policy);
        } else {
            this.msg_processing_policy.init(this);
        }
        if (this.msg_factory_class != null) {
            Class<?> clazz = Util.loadClass(this.msg_factory_class, this.getClass());
            this.msg_factory = (MessageFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this.bundler = this.createBundler(this.bundler_type);
        this.bundler.init(this);
    }

    @Override
    public void start() throws Exception {
        this.timer.start();
        if (this.time_service != null) {
            this.time_service.start();
        }
        this.fetchLocalAddresses();
        this.startDiagnostics();
        this.bundler.start();
        this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
    }

    @Override
    public void stop() {
        this.stopDiagnostics();
        this.bundler.stop();
        if (this.msg_processing_policy != null) {
            this.msg_processing_policy.destroy();
        }
        if (this.time_service != null) {
            this.time_service.stop();
        }
        this.timer.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.local_transport != null) {
            this.local_transport.destroy();
        }
        if (this.logical_addr_cache_reaper != null) {
            this.logical_addr_cache_reaper.cancel(false);
            this.logical_addr_cache_reaper = null;
        }
        if (this.thread_pool != null) {
            this.thread_pool.destroy();
        }
    }

    @ManagedOperation(description="Creates and sets a new bundler. Type has to be either a bundler_type or the fully qualified classname of a Bundler impl. Stops the current bundler (if running)")
    public <T extends TP> T bundler(String type) throws Exception {
        Bundler new_bundler = this.createBundler(type);
        String old_bundler_class = null;
        if (this.bundler != null) {
            this.bundler.stop();
            old_bundler_class = this.bundler.getClass().getName();
        }
        new_bundler.init(this);
        new_bundler.start();
        this.bundler = new_bundler;
        this.bundler_type = type;
        if (old_bundler_class != null) {
            this.log.debug("%s: replaced bundler %s with %s", this.local_addr, old_bundler_class, this.bundler.getClass().getName());
        }
        return (T)this;
    }

    @ManagedOperation(description="Enables diagnostics and starts DiagnosticsHandler (if not running)")
    public void enableDiagnostics() {
        this.diag_handler.setEnabled(true);
        try {
            this.startDiagnostics();
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedStartingDiagnostics"), e);
        }
    }

    @ManagedOperation(description="Disables diagnostics and stops DiagnosticsHandler (if running)")
    public void disableDiagnostics() {
        this.stopDiagnostics();
    }

    protected void startDiagnostics() throws Exception {
        if (this.diag_handler != null) {
            this.diag_handler.registerProbeHandler(this);
            this.diag_handler.start();
        }
    }

    protected void stopDiagnostics() {
        if (this.diag_handler != null) {
            this.diag_handler.unregisterProbeHandler(this);
            this.diag_handler.stop();
        }
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        HashMap<String, String> retval = new HashMap<String, String>(keys != null ? keys.length : 2);
        if (keys == null) {
            return retval;
        }
        String[] stringArray = keys;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String key;
            switch (key = stringArray[i]) {
                case "dump": {
                    retval.put(key, Util.dumpThreads());
                    continue block12;
                }
                case "uuids": {
                    retval.put(key, this.printLogicalAddressCache());
                    if (retval.containsKey("local_addr")) continue block12;
                    retval.put("local_addr", this.local_addr != null ? this.local_addr.toString() : null);
                    continue block12;
                }
                case "keys": {
                    StringBuilder sb = new StringBuilder();
                    for (DiagnosticsHandler.ProbeHandler handler : this.diag_handler.getProbeHandlers()) {
                        String[] tmp = handler.supportedKeys();
                        if (tmp == null || tmp.length <= 0) continue;
                        for (String s : tmp) {
                            sb.append(s).append(" ");
                        }
                    }
                    retval.put(key, sb.toString());
                    continue block12;
                }
                case "member-addrs": {
                    Set<PhysicalAddress> physical_addrs = this.logical_addr_cache.nonRemovedValues();
                    String list = Util.print(physical_addrs);
                    retval.put(key, list);
                }
            }
        }
        return retval;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"dump", "keys", "uuids", "member-addrs"};
    }

    protected void handleConnect() throws Exception {
    }

    protected void handleDisconnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Set<Address> set = this.members;
                synchronized (set) {
                    View v;
                    this.view = v = (View)evt.getArg();
                    ArrayList<Address> old_members = new ArrayList<Address>(this.members);
                    this.members.clear();
                    this.members.addAll(v.getMembers());
                    this.logical_addr_cache.retainAll(this.members);
                    this.fetchLocalAddresses();
                    List<Address> left_mbrs = Util.leftMembers(old_members, this.members);
                    if (left_mbrs != null && !left_mbrs.isEmpty()) {
                        NameCache.removeAll(left_mbrs);
                    }
                    if (this.suppress_log_different_version != null) {
                        this.suppress_log_different_version.removeExpired(this.suppress_time_different_version_warnings);
                    }
                    if (this.suppress_log_different_cluster != null) {
                        this.suppress_log_different_cluster.removeExpired(this.suppress_time_different_cluster_warnings);
                    }
                }
                this.who_has_cache.removeExpiredElements();
                if (this.bundler != null) {
                    this.bundler.viewChange((View)evt.getArg());
                }
                if (this.msg_processing_policy instanceof MaxOneThreadPerSender) {
                    ((MaxOneThreadPerSender)this.msg_processing_policy).viewChange(this.view.getMembers());
                }
                if (this.local_transport == null) break;
                this.local_transport.viewChange(this.view);
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = new AsciiString((String)evt.getArg());
                this.header = new TpHeader(this.cluster_name);
                this.setInAllThreadFactories(this.cluster_name != null ? this.cluster_name.toString() : null, this.local_addr, this.thread_naming_pattern);
                this.setThreadNames();
                this.connectLock.lock();
                try {
                    if (this.local_transport != null) {
                        this.local_transport.start();
                    }
                    this.handleConnect();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.connectLock.unlock();
                }
                return null;
            }
            case 4: {
                this.unsetThreadNames();
                this.connectLock.lock();
                try {
                    if (this.local_transport != null) {
                        this.local_transport.stop();
                    }
                    this.handleDisconnect();
                    break;
                }
                finally {
                    this.connectLock.unlock();
                }
            }
            case 87: {
                Address addr = (Address)evt.getArg();
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(addr);
                if (physical_addr != null) {
                    return physical_addr;
                }
                if (Objects.equals(addr, this.local_addr) && (physical_addr = this.getPhysicalAddress()) != null) {
                    this.addPhysicalAddressToCache(addr, physical_addr);
                }
                return physical_addr;
            }
            case 102: {
                return this.getAllPhysicalAddressesFromCache();
            }
            case 88: {
                Object arg = evt.getArg();
                boolean skip_removed_values = arg instanceof Boolean && (Boolean)arg != false;
                return this.logical_addr_cache.contents(skip_removed_values);
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                return this.addPhysicalAddressToCache((Address)tuple.getVal1(), (PhysicalAddress)tuple.getVal2());
            }
            case 90: {
                this.removeLogicalAddressFromCache((Address)evt.getArg());
                this.local_addr = null;
            }
        }
        return null;
    }

    @Override
    public Object down(Message msg) {
        boolean loop_back;
        if (this.header != null) {
            msg.putHeader(this.id, this.header);
        }
        this.setSourceAddress(msg);
        Address dest = msg.getDest();
        Address sender = msg.getSrc();
        if (this.is_trace) {
            this.log.trace("%s: sending msg to %s, src=%s, size=%d, headers are %s", this.local_addr, dest, sender, msg.size(), msg.printHeaders());
        }
        boolean multicast = dest == null;
        boolean do_send = multicast || !dest.equals(sender);
        boolean bl = loop_back = (multicast || dest.equals(sender)) && !msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK);
        if (dest instanceof PhysicalAddress && dest.equals(this.local_physical_addr)) {
            loop_back = true;
            do_send = false;
        }
        if (this.loopback_separate_thread) {
            if (loop_back) {
                this.loopback(msg, multicast);
            }
            if (do_send) {
                this._send(msg, dest);
            }
        } else {
            if (do_send) {
                this._send(msg, dest);
            }
            if (loop_back) {
                this.loopback(msg, multicast);
            }
        }
        return null;
    }

    protected DiagnosticsHandler createDiagnosticsHandler() {
        return new DiagnosticsHandler(this.log, this.socket_factory, this.thread_factory).printHeaders(this::defaultHeaders).sameCluster(this::sameCluster);
    }

    protected Bundler createBundler(String type) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("bundler type has to be non-null");
        }
        switch (type) {
            case "transfer-queue": 
            case "tq": {
                return new TransferQueueBundler();
            }
            case "simplified-transfer-queue": 
            case "stq": {
                return new SimplifiedTransferQueueBundler();
            }
            case "sender-sends": 
            case "ss": {
                return new SenderSendsBundler();
            }
            case "ring-buffer": 
            case "rb": {
                return new RingBufferBundler();
            }
            case "ring-buffer-lockless": 
            case "rbl": {
                return new RingBufferBundlerLockless();
            }
            case "ring-buffer-lockless2": 
            case "rbl2": {
                return new RingBufferBundlerLockless2();
            }
            case "no-bundler": 
            case "nb": {
                return new NoBundler();
            }
            case "async-no-bundler": 
            case "anb": {
                return new AsyncNoBundler();
            }
            case "ab": 
            case "alternating-bundler": {
                return new AlternatingBundler();
            }
            case "rqb": 
            case "rq": 
            case "remove-queue-bundler": 
            case "remove-queue": {
                return new RemoveQueueBundler();
            }
        }
        Class<?> clazz = Util.loadClass(type, this.getClass());
        return (Bundler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void loopback(Message msg, boolean multicast) {
        Message copy;
        Message message = copy = this.loopback_copy ? msg.copy(true, true) : msg;
        if (this.is_trace) {
            this.log.trace("%s: looping back message %s, headers are %s", this.local_addr, copy, copy.printHeaders());
        }
        if (!this.loopback_separate_thread) {
            this.passMessageUp(copy, null, false, multicast, false);
            return;
        }
        this.msg_processing_policy.loopback(msg, msg.isFlagSet(Message.Flag.OOB));
    }

    protected void _send(Message msg, Address dest) {
        try {
            Bundler tmp_bundler = this.bundler;
            if (tmp_bundler != null) {
                tmp_bundler.send(msg);
            }
        }
        catch (InterruptedIOException tmp_bundler) {
        }
        catch (InterruptedException interruptedEx) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("SendFailure"), this.local_addr, dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void setSourceAddress(Message msg) {
        if (msg.getSrc() == null && this.local_addr != null) {
            msg.setSrc(this.local_addr);
        }
    }

    public void passMessageUp(Message msg, byte[] cluster_name, boolean perform_cluster_name_matching, boolean multicast, boolean discard_own_mcast) {
        if (this.is_trace) {
            this.log.trace("%s: received %s, headers are %s", this.local_addr, msg, msg.printHeaders());
        }
        if (this.up_prot == null) {
            return;
        }
        if (multicast && discard_own_mcast && this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
            return;
        }
        if (perform_cluster_name_matching && this.cluster_name != null && !this.cluster_name.equals(cluster_name)) {
            if (this.log_discard_msgs && this.log.isWarnEnabled()) {
                Address sender = msg.getSrc();
                if (this.suppress_log_different_cluster != null) {
                    this.suppress_log_different_cluster.log(SuppressLog.Level.warn, sender, this.suppress_time_different_cluster_warnings, new AsciiString(cluster_name), this.cluster_name, sender);
                } else {
                    this.log.warn(Util.getMessage("MsgDroppedDiffCluster"), new AsciiString(cluster_name), this.cluster_name, sender);
                }
            }
            return;
        }
        this.up_prot.up(msg);
    }

    public void passBatchUp(MessageBatch batch, boolean perform_cluster_name_matching, boolean discard_own_mcast) {
        if (this.is_trace) {
            this.log.trace("%s: received message batch of %d messages from %s", this.local_addr, batch.size(), batch.sender());
        }
        if (this.up_prot == null) {
            return;
        }
        if (perform_cluster_name_matching && this.cluster_name != null && !this.cluster_name.equals(batch.clusterName())) {
            if (this.log_discard_msgs && this.log.isWarnEnabled()) {
                Address sender = batch.sender();
                if (this.suppress_log_different_cluster != null) {
                    this.suppress_log_different_cluster.log(SuppressLog.Level.warn, sender, this.suppress_time_different_cluster_warnings, batch.clusterName(), this.cluster_name, sender);
                } else {
                    this.log.warn(Util.getMessage("BatchDroppedDiffCluster"), batch.clusterName(), this.cluster_name, sender);
                }
            }
            return;
        }
        if (batch.multicast() && discard_own_mcast && this.local_addr != null && this.local_addr.equals(batch.sender())) {
            return;
        }
        this.up_prot.up(batch);
    }

    protected boolean sameCluster(String req) {
        if (!req.startsWith("cluster=")) {
            return true;
        }
        String cluster_name_pattern = req.substring("cluster=".length()).trim();
        String cname = this.getClusterName();
        return cluster_name_pattern == null || Util.patternMatch(cluster_name_pattern, cname);
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        if (data == null) {
            return;
        }
        if (Objects.equals(this.local_physical_addr, sender)) {
            return;
        }
        if (length < 3) {
            return;
        }
        short version = Bits.readShort(data, offset);
        if (!this.versionMatch(version, sender)) {
            return;
        }
        byte flags = data[offset += 2];
        boolean is_message_list = (flags & 1) == 1;
        boolean multicast = (flags & 2) == 2;
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, ++offset, length);
        if (is_message_list) {
            this.handleMessageBatch(in, multicast, this.msg_factory);
        } else {
            this.handleSingleMessage(in, multicast);
        }
    }

    public void receive(Address sender, DataInput in) throws Exception {
        boolean multicast;
        if (in == null) {
            return;
        }
        if (Objects.equals(this.local_physical_addr, sender)) {
            return;
        }
        short version = in.readShort();
        if (!this.versionMatch(version, sender)) {
            return;
        }
        byte flags = in.readByte();
        boolean is_message_list = (flags & 1) == 1;
        boolean bl = multicast = (flags & 2) == 2;
        if (is_message_list) {
            this.handleMessageBatch(in, multicast, this.msg_factory);
        } else {
            this.handleSingleMessage(in, multicast);
        }
    }

    protected void handleMessageBatch(DataInput in, boolean multicast, MessageFactory factory) {
        try {
            MessageBatch[] batches = Util.readMessageBatch(in, multicast, factory);
            MessageBatch regular = batches[0];
            MessageBatch oob = batches[1];
            this.processBatch(oob, true);
            this.processBatch(regular, false);
        }
        catch (Throwable t) {
            this.log.error(String.format(Util.getMessage("IncomingMsgFailure"), this.local_addr), t);
        }
    }

    protected void handleSingleMessage(DataInput in, boolean multicast) {
        try {
            short type = in.readShort();
            Object msg = this.msg_factory.create(type);
            msg.readFrom(in);
            if (!multicast && this.unicastDestMismatch(msg.getDest())) {
                return;
            }
            boolean oob = msg.isFlagSet(Message.Flag.OOB);
            this.msg_processing_policy.process((Message)msg, oob);
        }
        catch (Throwable t) {
            this.log.error(String.format(Util.getMessage("IncomingMsgFailure"), this.local_addr), t);
        }
    }

    protected void processBatch(MessageBatch batch, boolean oob) {
        try {
            if (batch != null && !batch.isEmpty() && !this.unicastDestMismatch(batch.getDest())) {
                this.msg_processing_policy.process(batch, oob);
            }
        }
        catch (Throwable t) {
            this.log.error("processing batch failed", t);
        }
    }

    public boolean unicastDestMismatch(Address dest) {
        return dest != null && !Objects.equals(dest, this.local_addr) && !Objects.equals(dest, this.local_physical_addr);
    }

    protected boolean versionMatch(short version, Address sender) {
        boolean match = Version.isBinaryCompatible(version);
        if (!match && this.log_discard_msgs_version && this.log.isWarnEnabled()) {
            if (this.suppress_log_different_version != null) {
                this.suppress_log_different_version.log(SuppressLog.Level.warn, sender, this.suppress_time_different_version_warnings, sender, Version.print(version), Version.printVersion());
            } else {
                this.log.warn(Util.getMessage("VersionMismatch"), sender, Version.print(version), Version.printVersion());
            }
        }
        return match;
    }

    public void doSend(byte[] buf, int offset, int length, Address dest) throws Exception {
        if (this.stats) {
            this.msg_stats.incrNumMsgsSent(1);
            this.msg_stats.incrNumBytesSent(length);
        }
        if (dest != null) {
            this.sendTo(dest, buf, offset, length);
        } else {
            this.sendToAll(buf, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTo(Address dest, byte[] buf, int offset, int length) throws Exception {
        PhysicalAddress physical_dest;
        if (this.local_transport != null && this.local_transport.isLocalMember(dest)) {
            try {
                this.local_transport.sendTo(dest, buf, offset, length);
                return;
            }
            catch (Exception ex) {
                this.log.warn("failed sending message to %s via local transport, sending message via regular transport: %s", dest, ex);
            }
        }
        PhysicalAddress physicalAddress = physical_dest = dest instanceof PhysicalAddress ? (PhysicalAddress)dest : this.getPhysicalAddressFromCache(dest);
        if (physical_dest != null) {
            this.sendUnicast(physical_dest, buf, offset, length);
            return;
        }
        if (this.who_has_cache.addIfAbsentOrExpired(dest)) {
            Responses responses = this.fetchResponsesFromDiscoveryProtocol(Collections.singletonList(dest));
            try {
                for (PingData data : responses) {
                    if (data.getAddress() == null || !data.getAddress().equals(dest) || (physical_dest = data.getPhysicalAddr()) == null) continue;
                    this.sendUnicast(physical_dest, buf, offset, length);
                    return;
                }
                this.log.warn(Util.getMessage("PhysicalAddrMissing"), this.local_addr, dest);
            }
            finally {
                responses.done();
            }
        }
    }

    protected void sendToAll(byte[] buf, int offset, int length) throws Exception {
        ArrayList<Address> missing = null;
        Set<Address> mbrs = this.members;
        boolean local_send_successful = true;
        if (mbrs == null || mbrs.isEmpty()) {
            mbrs = this.logical_addr_cache.keySet();
        }
        if (this.local_transport != null) {
            try {
                this.local_transport.sendToAll(buf, offset, length);
            }
            catch (Exception ex) {
                this.log.warn("failed sending group message via local transport, sending it via regular transport", ex);
                local_send_successful = false;
            }
        }
        for (Address mbr : mbrs) {
            PhysicalAddress target;
            if (local_send_successful && this.local_transport != null && this.local_transport.isLocalMember(mbr)) continue;
            PhysicalAddress physicalAddress = target = mbr instanceof PhysicalAddress ? (PhysicalAddress)mbr : this.logical_addr_cache.get(mbr);
            if (target == null) {
                if (missing == null) {
                    missing = new ArrayList<Address>(mbrs.size());
                }
                missing.add(mbr);
                continue;
            }
            try {
                if (Objects.equals(this.local_physical_addr, target)) continue;
                this.sendUnicast(target, buf, offset, length);
            }
            catch (SocketException | SocketTimeoutException sock_ex) {
                this.log.debug(Util.getMessage("FailureSendingToPhysAddr"), this.local_addr, mbr, sock_ex);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailureSendingToPhysAddr"), this.local_addr, mbr, t);
            }
        }
        if (missing != null) {
            this.fetchPhysicalAddrs(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchPhysicalAddrs(List<Address> missing) {
        long current_time = 0L;
        boolean do_send = false;
        TP tP = this;
        synchronized (tP) {
            if (this.last_discovery_request == 0L || (current_time = this.timestamp()) - this.last_discovery_request >= MIN_WAIT_BETWEEN_DISCOVERIES) {
                this.last_discovery_request = current_time == 0L ? this.timestamp() : current_time;
                do_send = true;
            }
        }
        if (do_send) {
            missing.removeAll(this.logical_addr_cache.keySet());
            if (!missing.isEmpty()) {
                Responses rsps = this.fetchResponsesFromDiscoveryProtocol(missing);
                rsps.done();
            }
        }
    }

    protected Responses fetchResponsesFromDiscoveryProtocol(List<Address> missing) {
        return (Responses)this.up_prot.up(new Event(11, missing));
    }

    protected long timestamp() {
        return this.time_service != null ? this.time_service.timestamp() : System.nanoTime();
    }

    protected void registerLocalAddress(Address addr) {
        PhysicalAddress physical_addr = this.getPhysicalAddress();
        if (physical_addr == null) {
            return;
        }
        this.local_physical_addr = physical_addr;
        if (addr != null) {
            this.addPhysicalAddressToCache(addr, physical_addr, true);
        }
    }

    protected void fetchLocalAddresses() {
        if (this.local_addr != null) {
            this.registerLocalAddress(this.local_addr);
        } else {
            Address addr;
            this.local_addr = addr = (Address)this.up_prot.up(new Event(91));
            this.registerLocalAddress(addr);
        }
    }

    protected void setThreadNames() {
        if (this.diag_handler != null) {
            this.diag_handler.setThreadNames();
        }
        if (this.bundler instanceof TransferQueueBundler) {
            this.thread_factory.renameThread("TQ-Bundler", ((TransferQueueBundler)this.bundler).getThread());
        }
    }

    protected void unsetThreadNames() {
        Thread thread;
        if (this.diag_handler != null) {
            this.diag_handler.unsetThreadNames();
        }
        Thread thread2 = this.bundler instanceof TransferQueueBundler ? ((TransferQueueBundler)this.bundler).getThread() : (thread = this.bundler instanceof RingBufferBundler ? ((RingBufferBundler)this.bundler).getThread() : null);
        if (thread != null) {
            this.thread_factory.renameThread("TQ-Bundler", thread);
        }
    }

    protected void setInAllThreadFactories(String cluster_name, Address local_address, String pattern) {
        ThreadFactory[] factories;
        for (ThreadFactory factory : factories = new ThreadFactory[]{this.thread_factory}) {
            if (pattern != null) {
                factory.setPattern(pattern);
            }
            if (cluster_name != null) {
                factory.setClusterName(cluster_name);
            }
            if (local_address == null) continue;
            factory.setAddress(local_address.toString());
        }
    }

    public boolean addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr) {
        return this.addPhysicalAddressToCache(logical_addr, physical_addr, true);
    }

    protected boolean addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr, boolean overwrite) {
        return logical_addr != null && physical_addr != null && overwrite ? this.logical_addr_cache.add(logical_addr, physical_addr) : this.logical_addr_cache.addIfAbsent(logical_addr, physical_addr);
    }

    public PhysicalAddress getPhysicalAddressFromCache(Address logical_addr) {
        return logical_addr != null ? this.logical_addr_cache.get(logical_addr) : null;
    }

    protected Collection<PhysicalAddress> getAllPhysicalAddressesFromCache() {
        return this.logical_addr_cache.nonRemovedValues();
    }

    protected void removeLogicalAddressFromCache(Address logical_addr) {
        if (logical_addr != null) {
            this.logical_addr_cache.remove(logical_addr);
            this.fetchLocalAddresses();
        }
    }

    @ManagedOperation(description="Clears the logical address cache; only used for testing")
    public void clearLogicalAddressCache() {
        this.logical_addr_cache.clear(true);
        this.fetchLocalAddresses();
    }

    protected abstract PhysicalAddress getPhysicalAddress();
}

