/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.wildfly.httpclient.ejb.EjbConstants;

class HttpEJBInvocationBuilder {
    private String appName;
    private String moduleName;
    private String distinctName;
    private String beanName;
    private String beanId;
    private String view;
    private Method method;
    private InvocationType invocationType;
    private String invocationId;
    private int version = 1;
    private boolean cancelIfRunning;

    HttpEJBInvocationBuilder() {
    }

    public String getAppName() {
        return this.appName;
    }

    public HttpEJBInvocationBuilder setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public HttpEJBInvocationBuilder setModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public HttpEJBInvocationBuilder setDistinctName(String distinctName) {
        this.distinctName = distinctName;
        return this;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public HttpEJBInvocationBuilder setBeanName(String beanName) {
        this.beanName = beanName;
        return this;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public HttpEJBInvocationBuilder setBeanId(String beanId) {
        this.beanId = beanId;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpEJBInvocationBuilder setMethod(Method method) {
        this.method = method;
        return this;
    }

    public String getView() {
        return this.view;
    }

    public HttpEJBInvocationBuilder setView(String view) {
        this.view = view;
        return this;
    }

    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    public HttpEJBInvocationBuilder setInvocationType(InvocationType invocationType) {
        this.invocationType = invocationType;
        return this;
    }

    public String getInvocationId() {
        return this.invocationId;
    }

    public HttpEJBInvocationBuilder setInvocationId(String invocationId) {
        this.invocationId = invocationId;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public HttpEJBInvocationBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    private String buildPath(String mountPoint, String type, String appName, String moduleName, String distinctName, String beanName) {
        StringBuilder sb = new StringBuilder();
        this.buildBeanPath(mountPoint, type, appName, moduleName, distinctName, beanName, sb);
        return sb.toString();
    }

    private String buildPath(String mountPoint, String type, String appName, String moduleName, String distinctName, String beanName, String invocationId, boolean cancelIfRunning) {
        StringBuilder sb = new StringBuilder();
        this.buildBeanPath(mountPoint, type, appName, moduleName, distinctName, beanName, sb);
        sb.append("/");
        sb.append(invocationId);
        sb.append("/");
        sb.append(Boolean.toString(cancelIfRunning));
        return sb.toString();
    }

    private String buildPath(String mountPoint, String type, String appName, String moduleName, String distinctName, String beanName, String beanId, String view, Method method) {
        StringBuilder sb = new StringBuilder();
        this.buildBeanPath(mountPoint, type, appName, moduleName, distinctName, beanName, sb);
        sb.append("/");
        if (beanId == null) {
            sb.append("-");
        } else {
            sb.append(beanId);
        }
        sb.append("/");
        sb.append(view);
        sb.append("/");
        sb.append(method.getName());
        for (Class<?> param : method.getParameterTypes()) {
            sb.append("/");
            sb.append(HttpEJBInvocationBuilder.encodeUrlPart(param.getName()));
        }
        return sb.toString();
    }

    private void buildBeanPath(String mountPoint, String type, String appName, String moduleName, String distinctName, String beanName, StringBuilder sb) {
        this.buildModulePath(mountPoint, type, appName, moduleName, distinctName, sb);
        sb.append("/");
        sb.append(HttpEJBInvocationBuilder.encodeUrlPart(beanName));
    }

    private void buildModulePath(String mountPoint, String type, String appName, String moduleName, String distinctName, StringBuilder sb) {
        if (mountPoint != null) {
            sb.append(mountPoint);
        }
        sb.append("/ejb/v");
        sb.append(this.version);
        sb.append("/");
        sb.append(type);
        sb.append("/");
        if (appName == null || appName.isEmpty()) {
            sb.append("-");
        } else {
            sb.append(HttpEJBInvocationBuilder.encodeUrlPart(appName));
        }
        sb.append("/");
        if (moduleName == null || moduleName.isEmpty()) {
            sb.append("-");
        } else {
            sb.append(HttpEJBInvocationBuilder.encodeUrlPart(moduleName));
        }
        sb.append("/");
        if (distinctName == null || distinctName.isEmpty()) {
            sb.append("-");
        } else {
            sb.append(HttpEJBInvocationBuilder.encodeUrlPart(distinctName));
        }
    }

    private static String encodeUrlPart(String part) {
        try {
            return URLEncoder.encode(part, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientRequest createRequest(String mountPoint) {
        ClientRequest clientRequest = new ClientRequest();
        if (this.invocationType == InvocationType.METHOD_INVOCATION) {
            clientRequest.setMethod(Methods.POST);
            clientRequest.getRequestHeaders().add(Headers.ACCEPT, EjbConstants.INVOCATION_ACCEPT + "," + EjbConstants.EJB_EXCEPTION);
            if (this.invocationId != null) {
                clientRequest.getRequestHeaders().put(EjbConstants.INVOCATION_ID, this.invocationId);
            }
            clientRequest.setPath(this.buildPath(mountPoint, "/invoke", this.appName, this.moduleName, this.distinctName, this.beanName, this.beanId, this.view, this.method));
            clientRequest.getRequestHeaders().put(Headers.CONTENT_TYPE, EjbConstants.INVOCATION.toString());
        } else if (this.invocationType == InvocationType.STATEFUL_CREATE) {
            clientRequest.setMethod(Methods.POST);
            clientRequest.getRequestHeaders().put(Headers.CONTENT_TYPE, EjbConstants.SESSION_OPEN.toString());
            clientRequest.setPath(this.buildPath(mountPoint, "/open", this.appName, this.moduleName, this.distinctName, this.beanName));
            clientRequest.getRequestHeaders().add(Headers.ACCEPT, EjbConstants.EJB_EXCEPTION.toString());
        } else if (this.invocationType == InvocationType.CANCEL) {
            clientRequest.setMethod(Methods.DELETE);
            clientRequest.setPath(this.buildPath(mountPoint, "/cancel", this.appName, this.moduleName, this.distinctName, this.beanName, this.invocationId, this.cancelIfRunning));
        }
        return clientRequest;
    }

    public HttpEJBInvocationBuilder setCancelIfRunning(boolean cancelIfRunning) {
        this.cancelIfRunning = cancelIfRunning;
        return this;
    }

    public boolean isCancelIfRunning() {
        return this.cancelIfRunning;
    }

    public static enum InvocationType {
        METHOD_INVOCATION,
        STATEFUL_CREATE,
        CANCEL;

    }
}

