/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.TransactionRolledBackException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;

public final class JMSExceptionHelper {
    public static JMSException convertFromActiveMQException(ActiveMQInterruptedException me) {
        IllegalStateException je = new IllegalStateException(me.getMessage());
        je.setStackTrace(me.getStackTrace());
        je.initCause(me);
        return je;
    }

    public static JMSException convertFromActiveMQException(ActiveMQException me) {
        JMSException je;
        switch (me.getType()) {
            case CONNECTION_TIMEDOUT: {
                je = new JMSException(me.getMessage());
                break;
            }
            case ILLEGAL_STATE: {
                je = new IllegalStateException(me.getMessage());
                break;
            }
            case INTERNAL_ERROR: {
                je = new JMSException(me.getMessage());
                break;
            }
            case INVALID_FILTER_EXPRESSION: {
                je = new InvalidSelectorException(me.getMessage());
                break;
            }
            case NOT_CONNECTED: {
                je = new JMSException(me.getMessage());
                break;
            }
            case OBJECT_CLOSED: {
                je = new IllegalStateException(me.getMessage());
                break;
            }
            case QUEUE_DOES_NOT_EXIST: {
                je = new InvalidDestinationException(me.getMessage());
                break;
            }
            case QUEUE_EXISTS: {
                je = new InvalidDestinationException(me.getMessage());
                break;
            }
            case SECURITY_EXCEPTION: {
                je = new JMSSecurityException(me.getMessage());
                break;
            }
            case UNSUPPORTED_PACKET: {
                je = new IllegalStateException(me.getMessage());
                break;
            }
            case TRANSACTION_ROLLED_BACK: {
                je = new TransactionRolledBackException(me.getMessage());
                break;
            }
            default: {
                je = new JMSException(me.getMessage());
            }
        }
        je.setStackTrace(me.getStackTrace());
        je.initCause(me);
        return je;
    }
}

