/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.OutputStream;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.httpclient.common.HttpServiceConfig;

public class HttpServerHelper {
    private HttpServerHelper() {
    }

    public static void sendException(HttpServerExchange exchange, HttpServiceConfig serviceConfig, int status, Throwable e) {
        try {
            exchange.setStatusCode(status);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-jbmar-exception;version=1");
            Marshaller marshaller = serviceConfig.getHttpMarshallerFactory(exchange).createMarshaller();
            OutputStream outputStream = exchange.getOutputStream();
            ByteOutput byteOutput = Marshalling.createByteOutput(outputStream);
            marshaller.start(byteOutput);
            marshaller.writeObject(e);
            marshaller.write(0);
            marshaller.finish();
            marshaller.flush();
            exchange.endExchange();
        }
        catch (Exception ex) {
            ex.addSuppressed(e);
            HttpClientMessages.MESSAGES.failedToWriteException(ex);
            exchange.endExchange();
        }
    }

    @Deprecated
    public static void sendException(HttpServerExchange exchange, int status, Throwable e) {
        HttpServerHelper.sendException(exchange, HttpServiceConfig.getInstance(), status, e);
    }
}

