/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandResult;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.GenericTypeOperationHandler;
import org.jboss.as.cli.impl.aesh.CLICommandRegistry;
import org.jboss.as.cli.impl.aesh.HelpSupport;
import org.jboss.as.cli.impl.aesh.cmd.operation.LegacyCommandContainer;
import org.jboss.as.cli.impl.aesh.cmd.operation.OperationCommandContainer;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;
import org.wildfly.core.cli.command.aesh.activator.AbstractRejectOptionActivator;

@CommandDefinition(name="help", description="", aliases={"h"})
public class HelpCommand
implements Command<CLICommandInvocation> {
    @Arguments(completer=HelpCompleter.class, activator=ArgActivator.class)
    private List<String> command;
    private final CLICommandRegistry aeshRegistry;
    @Option(hasValue=false)
    private boolean commands;
    private static final DefaultCallbackHandler LINE = new DefaultCallbackHandler(false);
    private static final String OP_FALLBACK_HELP = "jboss_cli_raw_op";

    public HelpCommand(CLICommandRegistry aeshRegistry) {
        this.aeshRegistry = aeshRegistry;
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        block16: {
            CommandContext ctx = commandInvocation.getCommandContext();
            if (this.command == null || this.command.isEmpty()) {
                if (this.commands) {
                    return this.listAvailable(commandInvocation);
                }
                ctx.printLine(commandInvocation.getHelpInfo("help"));
                return CommandResult.SUCCESS;
            }
            if (this.commands) {
                throw new CommandException("commands option not usable with an argument");
            }
            if (this.command.size() > 2) {
                throw new CommandException("Command has more than one action");
            }
            String mainCommand = this.command.get(0);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.command.size(); ++i) {
                builder.append(this.command.get(i));
                if (i >= this.command.size() - 1) continue;
                builder.append(" ");
            }
            if (OperationCommandContainer.isOperation(mainCommand)) {
                try {
                    ctx.printLine(HelpCommand.getOperationHelp(builder.toString(), commandInvocation.getCommandContext()));
                }
                catch (Exception ex) {
                    ctx.printLine("Error getting operation help: " + ex.getLocalizedMessage());
                }
                return CommandResult.SUCCESS;
            }
            try {
                CommandLineParser parser = this.aeshRegistry.findCommand(mainCommand, builder.toString());
                if (parser.getProcessedCommand().getCommand() instanceof LegacyCommandContainer.LegacyCommand) {
                    CommandHandler handler = ((LegacyCommandContainer.LegacyCommand)parser.getProcessedCommand().getCommand()).getCommandHandler();
                    if (handler instanceof GenericTypeOperationHandler) {
                        try {
                            ((GenericTypeOperationHandler)handler).printDescription(commandInvocation.getCommandContext());
                            break block16;
                        }
                        catch (CommandLineException ex1) {
                            throw new CommandException(ex1);
                        }
                    }
                    if (!(handler instanceof CommandHandlerWithHelp)) break block16;
                    try {
                        ((CommandHandlerWithHelp)handler).displayHelp(commandInvocation.getCommandContext());
                        break block16;
                    }
                    catch (CommandLineException ex1) {
                        throw new CommandException(ex1);
                    }
                }
                ctx.printLine(parser.printHelp());
            }
            catch (CommandNotFoundException ex) {
                throw new CommandException("Command " + builder.toString() + " does not exist.");
            }
        }
        return CommandResult.SUCCESS;
    }

    private static String getOperationHelp(String op, CommandContext ctx) throws Exception {
        if (ctx.getModelControllerClient() == null) {
            throw new Exception("Not connected.");
        }
        LINE.reset();
        try {
            LINE.parse(ctx.getCurrentNodePath(), op, ctx);
        }
        catch (CommandFormatException ex) {
            throw new Exception(HelpSupport.printHelp(ctx, OP_FALLBACK_HELP));
        }
        String opName = LINE.getOperationName();
        if (opName == null) {
            throw new Exception("No operation name.");
        }
        OperationRequestAddress address = LINE.getAddress();
        ModelNode request = new ModelNode();
        if (address == null || address.isEmpty()) {
            request.get("address").setEmptyList();
        } else {
            if (address.endsOnType()) {
                throw new Exception("Invalid address.");
            }
            ModelNode addrNode = request.get("address");
            for (OperationRequestAddress.Node node : address) {
                addrNode.add(node.getType(), node.getName());
            }
        }
        request.get("operation").set("read-operation-description");
        request.get("name").set(opName);
        ModelNode result = ctx.getModelControllerClient().execute(request);
        if (!result.hasDefined("result")) {
            throw new Exception("Error retrieving operation description.");
        }
        String content = HelpSupport.printHelp(ctx, result.get("result"), address);
        if (content == null) {
            throw new Exception("Error retrieving operation description.");
        }
        return content;
    }

    private CommandResult listAvailable(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ArrayList<String> lst = new ArrayList<String>();
        for (String c : this.aeshRegistry.getAllCommandNames()) {
            CommandLineParser cmdParser;
            try {
                cmdParser = this.aeshRegistry.findCommand(c, null);
            }
            catch (CommandNotFoundException ex) {
                continue;
            }
            CommandActivator activator = cmdParser.getProcessedCommand().getActivator();
            if (activator != null && !activator.isActivated(new ParsedCommand(cmdParser.getProcessedCommand()))) continue;
            if (cmdParser.isGroupCommand()) {
                for (CommandLineParser child : cmdParser.getAllChildParsers()) {
                    CommandActivator childActivator = child.getProcessedCommand().getActivator();
                    if (childActivator != null && !childActivator.isActivated(new ParsedCommand(child.getProcessedCommand()))) continue;
                    lst.add(c + " " + child.getProcessedCommand().name());
                }
                continue;
            }
            lst.add(c);
        }
        ctx.printLine("Commands available in the current context:");
        this.print(lst, ctx);
        ctx.printLine("To read a description of a specific command execute 'help <command name>'.");
        return CommandResult.SUCCESS;
    }

    private void print(List<String> lst, CommandContext ctx) {
        lst.sort(null);
        ctx.printColumns(lst);
    }

    public static class ArgActivator
    extends AbstractRejectOptionActivator {
        public ArgActivator() {
            super("commands");
        }
    }

    public static class HelpCompleter
    implements OptionCompleter<CLICompleterInvocation> {
        private final DefaultCallbackHandler parsedCmd = new DefaultCallbackHandler(false);

        @Override
        public void complete(CLICompleterInvocation completerInvocation) {
            String buff;
            HelpCommand cmd = (HelpCommand)completerInvocation.getCommand();
            String mainCommand = null;
            if (cmd.command != null) {
                if (cmd.command.size() > 1) {
                    return;
                }
                mainCommand = cmd.command.get(0);
            }
            if (OperationCommandContainer.isOperation(buff = completerInvocation.getGivenCompleteValue())) {
                ArrayList<String> candidates = new ArrayList<String>();
                this.parsedCmd.reset();
                try {
                    this.parsedCmd.parse(null, buff, false, completerInvocation.getCommandContext());
                }
                catch (CommandFormatException ex) {
                    return;
                }
                int offset = OperationRequestCompleter.INSTANCE.complete(completerInvocation.getCommandContext(), this.parsedCmd, buff, 0, candidates);
                boolean contains = false;
                for (String c : candidates) {
                    int i = c.indexOf("(");
                    if (i <= 0) continue;
                    contains = true;
                }
                if (contains) {
                    return;
                }
                Collections.sort(candidates);
                completerInvocation.setOffset(buff.length() - offset);
                completerInvocation.addAllCompleterValues(candidates);
                completerInvocation.setAppendSpace(false);
                return;
            }
            ArrayList<String> allExposed = new ArrayList<String>(cmd.aeshRegistry.getAllCommandNames());
            ArrayList<String> candidates = new ArrayList<String>();
            if (mainCommand == null) {
                if (completerInvocation.getCommandContext().getModelControllerClient() != null) {
                    allExposed.add("/");
                    allExposed.add(":");
                }
                if (buff == null || buff.isEmpty()) {
                    candidates.addAll(allExposed);
                } else {
                    for (String c : allExposed) {
                        if (!c.startsWith(buff)) continue;
                        candidates.add(c);
                    }
                }
            } else {
                try {
                    CommandLineParser p = cmd.aeshRegistry.findCommand(mainCommand, null);
                    for (CommandLineParser child : p.getAllChildParsers()) {
                        if (!child.getProcessedCommand().name().startsWith(buff)) continue;
                        candidates.add(child.getProcessedCommand().name());
                    }
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    // empty catch block
                }
            }
            Collections.sort(candidates);
            completerInvocation.addAllCompleterValues(candidates);
        }
    }
}

