/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQUtilBundle_impl
implements ActiveMQUtilBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQUtilBundle_impl(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public ActiveMQIllegalStateException invalidProperty(String part) {
        String returnString = MessageFormatter.arrayFormat("AMQ209000: invalid property: {}", new Object[]{part}).getMessage();
        ActiveMQIllegalStateException objReturn_invalidProperty = new ActiveMQIllegalStateException(returnString);
        ActiveMQUtilBundle_impl._copyStackTraceMinusOne(objReturn_invalidProperty);
        return objReturn_invalidProperty;
    }

    @Override
    public IllegalStateException invalidType(Byte type) {
        String returnString = MessageFormatter.arrayFormat("AMQ209001: Invalid type: {}", new Object[]{type}).getMessage();
        IllegalStateException objReturn_invalidType = new IllegalStateException(returnString);
        ActiveMQUtilBundle_impl._copyStackTraceMinusOne(objReturn_invalidType);
        return objReturn_invalidType;
    }

    @Override
    public IllegalStateException stringTooLong(Integer length) {
        String returnString = MessageFormatter.arrayFormat("AMQ209002: the specified string is too long ({})", new Object[]{length}).getMessage();
        IllegalStateException objReturn_stringTooLong = new IllegalStateException(returnString);
        ActiveMQUtilBundle_impl._copyStackTraceMinusOne(objReturn_stringTooLong);
        return objReturn_stringTooLong;
    }

    @Override
    public IllegalArgumentException errorCreatingCodec(String codecClassName, Exception e) {
        String returnString = MessageFormatter.arrayFormat("AMQ209003: Error instantiating codec {}", new Object[]{codecClassName, e}).getMessage();
        IllegalArgumentException objReturn_errorCreatingCodec = new IllegalArgumentException(returnString);
        objReturn_errorCreatingCodec.initCause(e);
        ActiveMQUtilBundle_impl._copyStackTraceMinusOne(objReturn_errorCreatingCodec);
        return objReturn_errorCreatingCodec;
    }

    @Override
    public IllegalArgumentException failedToParseLong(String value) {
        String returnString = MessageFormatter.arrayFormat("AMQ209004: Failed to parse long value from {}", new Object[]{value}).getMessage();
        IllegalArgumentException objReturn_failedToParseLong = new IllegalArgumentException(returnString);
        ActiveMQUtilBundle_impl._copyStackTraceMinusOne(objReturn_failedToParseLong);
        return objReturn_failedToParseLong;
    }
}

