/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;

public class HornetQBytesMessage
extends HornetQMessage
implements BytesMessage {
    public static final byte TYPE = 4;
    private int bodyLength;

    protected HornetQBytesMessage(ClientSession session) {
        super((byte)4, session);
    }

    protected HornetQBytesMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQBytesMessage(BytesMessage foreign, ClientSession session) throws JMSException {
        super(foreign, (byte)4, session);
        foreign.reset();
        byte[] buffer = new byte[1024];
        int n = foreign.readBytes(buffer);
        while (n != -1) {
            this.writeBytes(buffer, 0, n);
            n = foreign.readBytes(buffer);
        }
    }

    @Override
    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readBoolean();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readUnsignedByte() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readUnsignedByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public short readShort() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readUnsignedShort() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readUnsignedShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public char readChar() throws JMSException {
        this.checkRead();
        try {
            return (char)this.getBuffer().readShort();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readInt() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readInt();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public long readLong() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readLong();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            return Float.intBitsToFloat(this.getBuffer().readInt());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            return Double.longBitsToDouble(this.getBuffer().readLong());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public String readUTF() throws JMSException {
        this.checkRead();
        try {
            return this.getBuffer().readUTF();
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to get UTF");
            je.setLinkedException(e);
            je.initCause(e);
            throw je;
        }
    }

    @Override
    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    @Override
    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkRead();
        if (!this.getBuffer().readable()) {
            return -1;
        }
        int read = Math.min(length, this.getBuffer().readableBytes());
        if (read != 0) {
            this.getBuffer().readBytes(value, 0, read);
        }
        return read;
    }

    @Override
    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeBoolean(value);
    }

    @Override
    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte(value);
    }

    @Override
    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeShort(value);
    }

    @Override
    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeShort((short)value);
    }

    @Override
    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeInt(value);
    }

    @Override
    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeLong(value);
    }

    @Override
    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeUTF(String value) throws JMSException {
        this.checkWrite();
        try {
            this.getBuffer().writeUTF(value);
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to write UTF");
            je.setLinkedException(e);
            je.initCause(e);
            throw je;
        }
    }

    @Override
    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeBytes(value);
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeBytes(value, offset, length);
    }

    @Override
    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException("Attempt to write a null value");
        }
        if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Invalid object for properties");
        }
    }

    @Override
    public void reset() throws JMSException {
        if (!this.readOnly) {
            this.readOnly = true;
            this.bodyLength = this.message.getBodySize();
            this.getBuffer().resetReaderIndex();
        } else {
            this.getBuffer().resetReaderIndex();
        }
    }

    @Override
    public void doBeforeReceive() throws HornetQException {
        this.bodyLength = this.message.getBodySize();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        try {
            this.getBuffer().clear();
        }
        catch (RuntimeException e) {
            JMSException e2 = new JMSException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public long getBodyLength() throws JMSException {
        this.checkRead();
        return this.bodyLength;
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.reset();
    }

    @Override
    public byte getType() {
        return 4;
    }

    private HornetQBuffer getBuffer() {
        return this.message.getBodyBuffer();
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        return c.isAssignableFrom(byte[].class);
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) {
        if (this.bodyLength == 0) {
            return null;
        }
        byte[] dst = new byte[this.bodyLength];
        this.message.getBodyBuffer().getBytes(17, dst);
        return (T)dst;
    }
}

