/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin.it;

import com.soebes.itf.extension.assertj.MavenExecutionResultAssert;
import com.soebes.itf.jupiter.extension.MavenGoal;
import com.soebes.itf.jupiter.extension.MavenJupiterExtension;
import com.soebes.itf.jupiter.extension.MavenPredefinedRepository;
import com.soebes.itf.jupiter.extension.MavenTest;
import com.soebes.itf.jupiter.extension.SystemProperties;
import com.soebes.itf.jupiter.extension.SystemProperty;
import com.soebes.itf.jupiter.maven.MavenExecutionResult;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.Stream;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.channelplugin.utils.DependencyModel;
import org.wildfly.channeltools.util.VersionUtils;

@MavenJupiterExtension
@MavenPredefinedRepository(value="maven-repo")
public class UpgradeComponentsMojoIT {
    private static final Logger LOGGER = Logger.getLogger(UpgradeComponentsMojoIT.class.getName());

    @MavenGoal(value={"${project.groupId}:wildfly-channel-maven-plugin:${project.version}:upgrade"})
    @SystemProperties(value={@SystemProperty(value="channelFile", content="channel.yaml"), @SystemProperty(value="localRepository", content="${maven.repo.local}"), @SystemProperty(value="ignoreStreams", content="org.jboss:ignored-dep")})
    @MavenTest
    void basic_project_test_case(MavenExecutionResult result) throws MalformedURLException {
        MavenExecutionResultAssert.assertThat((MavenExecutionResult)result).isSuccessful();
        Model model = result.getMavenProjectResult().getModel();
        DependencyModel dependencyModel = new DependencyModel(model);
        Assertions.assertThat((String)model.getProperties().getProperty("undertow.version")).usingComparator(VersionMatcher.COMPARATOR).isEqualTo("2.2.17.SP1-redhat-00001");
        Assertions.assertThat((Optional)dependencyModel.getDependency("io.undertow", "undertow-core", "jar", null)).satisfies(new ThrowingConsumer[]{o -> {
            Assertions.assertThat((boolean)o.isPresent());
            Assertions.assertThat((String)((Dependency)o.get()).getVersion()).isEqualTo("${undertow.version}");
        }});
        Assertions.assertThat((Optional)dependencyModel.getDependency("io.undertow", "undertow-servlet", "jar", null)).satisfies(new ThrowingConsumer[]{o -> {
            Assertions.assertThat((boolean)o.isPresent());
            Assertions.assertThat((String)((Dependency)o.get()).getVersion()).isEqualTo("${undertow.version}");
        }});
        Assertions.assertThat((Optional)dependencyModel.getDependency("org.jboss.marshalling", "jboss-marshalling", "jar", null)).satisfies(new ThrowingConsumer[]{o -> {
            Assertions.assertThat((boolean)o.isPresent());
            Assertions.assertThat((String)((Dependency)o.get()).getVersion()).isEqualTo("2.0.9.Final-redhat-00001");
        }});
        Assertions.assertThat((Optional)dependencyModel.getDependency("commons-io", "commons-io", "jar", null)).satisfies(new ThrowingConsumer[]{o -> {
            Assertions.assertThat((boolean)o.isPresent());
            Assertions.assertThat((String)((Dependency)o.get()).getVersion()).isEqualTo("${commons.version}");
        }});
        Assertions.assertThat((Object)model.getProperties().get("commons.version")).isEqualTo((Object)"${commons2.version}");
        Assertions.assertThat((Object)model.getProperties().get("commons2.version")).isEqualTo((Object)"2.10.1.redhat-00001");
        Assertions.assertThat((Optional)dependencyModel.getDependency("org.jboss", "ignored-dep", "jar", null)).satisfies(new ThrowingConsumer[]{o -> {
            Assertions.assertThat((Optional)o).isPresent();
            Assertions.assertThat((String)((Dependency)o.get()).getVersion()).isEqualTo("1.0.0.Final");
        }});
        File effectiveChannelFile = new File(result.getMavenProjectResult().getTargetProjectDirectory(), "target/recorded-channel.yaml");
        Assertions.assertThat((File)effectiveChannelFile).exists();
        Channel effectiveChannel = ChannelMapper.from((URL)effectiveChannelFile.toURI().toURL());
        Assertions.assertThat(effectiveChannel.getStreams().stream().map(s -> s.getGroupId() + ":" + s.getArtifactId() + ":" + s.getVersion()).collect(Collectors.toList())).contains((Object[])new String[]{"io.undertow:undertow-core:2.2.17.SP1-redhat-00001", "org.jboss.marshalling:jboss-marshalling:2.0.9.Final-redhat-00001", "commons-io:commons-io:2.10.1.redhat-00001"});
    }

    @MavenGoal(value={"${project.groupId}:wildfly-channel-maven-plugin:${project.version}:upgrade"})
    @SystemProperty(value="channelFile", content="channel.yaml")
    @MavenTest
    void eap_bom_test_case(MavenExecutionResult result) throws MalformedURLException {
        MavenExecutionResultAssert.assertThat((MavenExecutionResult)result).isSuccessful();
        File channelFile = new File(result.getMavenProjectResult().getTargetProjectDirectory(), "channel.yaml");
        Channel channel = ChannelMapper.from((URL)channelFile.toURI().toURL());
        Model model = result.getMavenProjectResult().getModel();
        for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
            Optional streamOptional = channel.findStreamFor(dependency.getGroupId(), dependency.getArtifactId());
            if (streamOptional.isPresent()) {
                Assertions.assertThat((Optional)streamOptional).isPresent();
                Assertions.assertThat((String)((Stream)streamOptional.get()).getVersion()).isNotNull();
                String propertyExpression = dependency.getVersion();
                Assertions.assertThat((String)propertyExpression).satisfies(new ThrowingConsumer[]{e -> {
                    Assertions.assertThat((String)e).startsWith((CharSequence)"${");
                    Assertions.assertThat((String)e).endsWith((CharSequence)"}");
                }});
                String propertyName = VersionUtils.extractPropertyName((String)propertyExpression);
                String versionString = model.getProperties().getProperty(propertyName);
                Assertions.assertThat((String)versionString).isNotNull();
                ((AbstractStringAssert)Assertions.assertThat((String)versionString).as("dependency version for %s:%s", new Object[]{dependency.getGroupId(), dependency.getArtifactId()})).isEqualTo(((Stream)streamOptional.get()).getVersion());
                continue;
            }
            LOGGER.warning("Can't find stream for " + dependency);
        }
    }
}

