/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin.it;

import com.soebes.itf.extension.assertj.MavenExecutionResultAssert;
import com.soebes.itf.jupiter.extension.MavenGoal;
import com.soebes.itf.jupiter.extension.MavenJupiterExtension;
import com.soebes.itf.jupiter.extension.MavenTest;
import com.soebes.itf.jupiter.extension.SystemProperties;
import com.soebes.itf.jupiter.extension.SystemProperty;
import com.soebes.itf.jupiter.maven.MavenExecutionResult;
import java.util.Optional;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.channelplugin.utils.DependencyModel;

@MavenJupiterExtension
public class SetPropertyMojoIT {
    @MavenGoal(value={"${project.groupId}:wildfly-channel-maven-plugin:${project.version}:set-property"})
    @SystemProperties(value={@SystemProperty(value="manifestFile", content="manifest.yaml"), @SystemProperty(value="property", content="undertow.version"), @SystemProperty(value="stream", content="io.undertow:undertow-core")})
    @MavenTest
    void set_version_test_case(MavenExecutionResult result) {
        MavenExecutionResultAssert.assertThat((MavenExecutionResult)result).isSuccessful();
        Model model = result.getMavenProjectResult().getModel();
        DependencyModel dependencyModel = new DependencyModel(model);
        Assertions.assertThat((String)model.getProperties().getProperty("undertow.version")).usingComparator(VersionMatcher.COMPARATOR).isEqualTo("2.2.5.Final-redhat-00001");
        Assertions.assertThat((Optional)dependencyModel.getDependency("io.undertow", "undertow-core", "jar", null)).satisfies(new ThrowingConsumer[]{o -> {
            Assertions.assertThat((Optional)o).isPresent();
            Assertions.assertThat((String)((Dependency)o.get()).getVersion()).isEqualTo("${undertow.version}");
        }});
    }
}

