/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.io.PomIO;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channelplugin.ChannelPluginLogger;
import org.wildfly.channelplugin.manipulation.PomManipulator;
import org.wildfly.channeltools.resolver.DefaultMavenVersionsResolverFactory;
import org.wildfly.channeltools.util.VersionUtils;

@Mojo(name="upgrade", requiresProject=true, requiresDirectInvocation=true)
public class UpgradeComponentsMojo
extends AbstractMojo {
    private static final String LOCAL_MAVEN_REPO = System.getProperty("user.home") + "/.m2/repository";
    private static final String CHANNEL_CLASSIFIER = "channel";
    private static final String CHANNEL_EXTENSION = "yaml";
    @Parameter(required=false, property="channelFile")
    String channelFile;
    @Parameter(required=false, property="channelGAV")
    String channelGAV;
    @Parameter(required=false, property="remoteRepositories")
    List<String> remoteRepositories;
    @Parameter(property="localRepository")
    String localRepository;
    @Parameter(property="disableTlsVerification", defaultValue="false")
    boolean disableTlsVerification;
    @Parameter(property="ignoreStreams", defaultValue="")
    List<String> ignoreStreams;
    @Parameter(property="ignoreModules", defaultValue="")
    List<String> ignoreModules;
    @Parameter(property="writeRecordedChannel", defaultValue="true")
    boolean writeRecordedChannel;
    @Parameter(defaultValue="${basedir}", readonly=true)
    File basedir;
    @Inject
    MavenProject mavenProject;
    @Inject
    MavenSession mavenSession;
    @Inject
    PomIO pomIO;
    @Inject
    ManipulationSession manipulationSession;
    @Inject
    RepositorySystem repositorySystem;
    private Channel channel;
    private ChannelSession channelSession;
    private final List<ProjectRef> ignoredStreams = new ArrayList<ProjectRef>();
    private final List<ProjectRef> ignoredModules = new ArrayList<ProjectRef>();
    private Set<ProjectVersionRef> projectGavs;
    private final HashMap<Pair<String, String>, PomManipulator> manipulators = new HashMap();
    private final HashMap<Pair<Project, String>, String> upgradedProperties = new HashMap();

    private void init() throws MojoExecutionException {
        if (this.localRepository == null) {
            this.localRepository = LOCAL_MAVEN_REPO;
        }
        this.channel = this.loadChannel();
        this.channelSession = new ChannelSession(Collections.singletonList(this.channel), (MavenVersionsResolver.Factory)new DefaultMavenVersionsResolverFactory(this.remoteRepositories, this.localRepository, this.disableTlsVerification));
        this.ignoreStreams.forEach(ga -> this.ignoredStreams.add(SimpleProjectRef.parse((String)ga)));
        this.ignoreModules.forEach(ga -> this.ignoredModules.add(SimpleProjectRef.parse((String)ga)));
    }

    public void execute() throws MojoExecutionException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        this.init();
        try {
            List<Project> pmeProjects = this.parsePmeProjects();
            this.projectGavs = pmeProjects.stream().map(p -> new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId(), p.getVersion())).collect(Collectors.toSet());
            for (Project project : pmeProjects) {
                ProjectRef moduleGA = project.getKey().asProjectRef();
                if (this.ignoredModules.contains(moduleGA)) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s", project.getGroupId(), project.getArtifactId()));
                    continue;
                }
                this.getLog().info((CharSequence)String.format("Processing module %s:%s", project.getGroupId(), project.getArtifactId()));
                PomManipulator manipulator = new PomManipulator(project);
                this.manipulators.put((Pair<String, String>)Pair.of((Object)project.getGroupId(), (Object)project.getArtifactId()), manipulator);
                this.processProject(project, manipulator);
            }
            for (PomManipulator manipulator : this.manipulators.values()) {
                manipulator.writePom();
            }
        }
        catch (XMLStreamException | ManipulationException e) {
            throw new MojoExecutionException("Project parsing failed", (Exception)e);
        }
    }

    private void processProject(Project pmeProject, PomManipulator manipulator) throws ManipulationException, XMLStreamException {
        Map<ArtifactRef, Dependency> resolvedProjectDependencies = this.collectResolvedProjectDependencies(pmeProject);
        List<Pair<Dependency, MavenArtifact>> dependenciesToUpgrade = this.findDepenenciesToUpgrade(resolvedProjectDependencies);
        for (Pair<Dependency, MavenArtifact> upgrade : dependenciesToUpgrade) {
            MavenArtifact artifactToUpgrade = (MavenArtifact)upgrade.getRight();
            Dependency locatedDependency = (Dependency)upgrade.getLeft();
            String newVersion = artifactToUpgrade.getVersion();
            if (locatedDependency == null) {
                ChannelPluginLogger.LOGGER.errorf("Couldn't locate dependency %s", (Object)artifactToUpgrade);
                continue;
            }
            if (VersionUtils.isProperty((String)locatedDependency.getVersion())) {
                Dependency d;
                String versionPropertyName = VersionUtils.extractPropertyName((String)locatedDependency.getVersion());
                Pair<Project, String> projectProperty = UpgradeComponentsMojo.followProperties(pmeProject, versionPropertyName);
                if (projectProperty == null) {
                    d = locatedDependency;
                    ChannelPluginLogger.LOGGER.errorf("Unable to upgrade %s:%s:%s to '%s', can't locate property '%s' in POM file %s", new Object[]{d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, versionPropertyName, pmeProject.getPom().getPath()});
                    continue;
                }
                if (this.upgradedProperties.containsKey(projectProperty)) {
                    if (!this.upgradedProperties.get(projectProperty).equals(newVersion)) {
                        d = locatedDependency;
                        String currentPropertyValue = this.upgradedProperties.get(projectProperty);
                        this.getLog().warn((CharSequence)String.format("Can't upgrade %s:%s:%s to '%s', property '%s' was already upgraded to '%s'", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, projectProperty.getRight(), currentPropertyValue));
                        continue;
                    }
                } else {
                    this.upgradedProperties.put(projectProperty, newVersion);
                }
                Project targetProject = (Project)projectProperty.getLeft();
                String targetPropertyName = (String)projectProperty.getRight();
                PomManipulator targetManipulator = this.manipulators.get(Pair.of((Object)targetProject.getGroupId(), (Object)targetProject.getArtifactId()));
                targetManipulator.overrideProperty(targetPropertyName, newVersion);
                continue;
            }
            manipulator.overrideDependencyVersion(locatedDependency, newVersion);
        }
        if (this.writeRecordedChannel) {
            this.writeRecordedChannel(pmeProject);
        }
    }

    private Map<ArtifactRef, Dependency> collectResolvedProjectDependencies(Project pmeProject) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> projectDependencies = new HashMap<ArtifactRef, Dependency>();
        projectDependencies.putAll(pmeProject.getResolvedManagedDependencies((MavenSessionHandler)this.manipulationSession));
        projectDependencies.putAll(pmeProject.getResolvedDependencies((MavenSessionHandler)this.manipulationSession));
        if (projectDependencies.size() == 0) {
            this.getLog().debug((CharSequence)("No dependencies found in " + pmeProject.getArtifactId()));
        }
        return projectDependencies;
    }

    private List<Pair<Dependency, MavenArtifact>> findDepenenciesToUpgrade(Map<ArtifactRef, Dependency> resolvedProjectDependencies) {
        ArrayList<Pair<Dependency, MavenArtifact>> dependenciesToUpgrade = new ArrayList<Pair<Dependency, MavenArtifact>>();
        for (Map.Entry<ArtifactRef, Dependency> entry : resolvedProjectDependencies.entrySet()) {
            ArtifactRef artifactRef = entry.getKey();
            Dependency dependency = entry.getValue();
            if (this.projectGavs.contains(artifactRef.asProjectVersionRef())) {
                this.getLog().debug((CharSequence)("Ignoring in-project dependency: " + artifactRef.asProjectVersionRef().toString()));
                continue;
            }
            if (this.ignoredStreams.contains(artifactRef.asProjectRef())) {
                this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + artifactRef.asProjectVersionRef().toString()));
                continue;
            }
            if (artifactRef.getVersionString() == null) {
                this.getLog().warn((CharSequence)("Resolved dependency has null version: " + artifactRef));
                continue;
            }
            if (VersionUtils.isProperty((String)artifactRef.getVersionString())) {
                this.getLog().warn((CharSequence)("Resolved dependency has version with property: " + artifactRef));
                continue;
            }
            try {
                MavenArtifact mavenArtifact = this.channelSession.resolveMavenArtifact(artifactRef.getGroupId(), artifactRef.getArtifactId(), artifactRef.getType(), artifactRef.getClassifier(), artifactRef.getVersionString());
                if (mavenArtifact.getVersion().equals(artifactRef.getVersionString())) continue;
                this.getLog().info((CharSequence)("Overriding dependency version " + artifactRef.getGroupId() + ":" + artifactRef.getArtifactId() + ":" + artifactRef.getVersionString() + " to version " + mavenArtifact.getVersion()));
                dependenciesToUpgrade.add((Pair<Dependency, MavenArtifact>)Pair.of((Object)dependency, (Object)mavenArtifact));
            }
            catch (UnresolvedMavenArtifactException e) {
                this.getLog().debug((CharSequence)("Can't resolve artifact: " + artifactRef), (Throwable)e);
            }
        }
        return dependenciesToUpgrade;
    }

    private Channel loadChannel() throws MojoExecutionException {
        try {
            if (this.channelFile != null) {
                Path channelFilePath = Path.of(this.channelFile, new String[0]);
                if (!channelFilePath.isAbsolute()) {
                    channelFilePath = Path.of(this.mavenSession.getExecutionRootDirectory(), new String[0]).resolve(channelFilePath);
                }
                this.getLog().info((CharSequence)("Reading channel file " + channelFilePath));
                return ChannelMapper.from((URL)channelFilePath.toUri().toURL());
            }
            if (StringUtils.isNotBlank((String)this.channelGAV)) {
                return this.resolveChannel(this.channelGAV);
            }
            throw new MojoExecutionException("Either channelFile or channelGAV parameter needs to be set.");
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not read channelFile", (Exception)e);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve the channel artifact", (Exception)((Object)e));
        }
    }

    private Channel resolveChannel(String gavString) throws ArtifactResolutionException, MalformedURLException {
        ProjectVersionRef gav = SimpleProjectVersionRef.parse((String)gavString);
        DefaultArtifact artifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), CHANNEL_CLASSIFIER, CHANNEL_EXTENSION, gav.getVersionString());
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.mavenProject.getRemoteProjectRepositories());
        ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.mavenSession.getRepositorySession(), request);
        this.getLog().info((CharSequence)String.format("Channel file resolved from %s in repository %s", artifact, artifactResult.getRepository().getId()));
        File channelFile = artifactResult.getArtifact().getFile();
        return ChannelMapper.from((URL)channelFile.toURI().toURL());
    }

    private List<Project> parsePmeProjects() throws ManipulationException {
        return this.pomIO.parseProject(this.mavenProject.getModel().getPomFile());
    }

    private void writeRecordedChannel(Project project) {
        try {
            Channel recordedChannel = this.channelSession.getRecordedChannel();
            if (recordedChannel.getStreams().size() > 0) {
                String recordedChannelYaml = ChannelMapper.toYaml((Channel[])new Channel[]{recordedChannel});
                Path targetDir = Path.of(project.getPom().getParent(), "target");
                if (!targetDir.toFile().exists()) {
                    targetDir.toFile().mkdir();
                }
                Files.write(Path.of(targetDir.toString(), "recorded-channel.yaml"), recordedChannelYaml.getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write recorder channel", e);
        }
    }

    static Pair<Project, String> followProperties(Project pmeProject, String propertyName) {
        String newPropertyName;
        Pair<Project, String> targetProperty;
        Properties properties = pmeProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            Project parentProject = pmeProject.getProjectParent();
            if (parentProject == null) {
                return null;
            }
            return UpgradeComponentsMojo.followProperties(parentProject, propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.followProperties(pmeProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return Pair.of((Object)pmeProject, (Object)propertyName);
    }
}

