/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin.manipulation;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.http.util.Asserts;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.commonjava.maven.ext.common.model.Project;
import org.wildfly.channel.MavenArtifact;

public class PomManipulator {
    private static final String DEPENDENCY_MANAGEMENT_PATH = "/project/dependencyManagement/dependencies";
    private static final String DEPENDENCIES = "dependencies";
    private final Project project;
    private final ModifiedPomXMLEventReader eventReader;
    private final StringBuilder content;
    private boolean closed = false;

    public PomManipulator(Project project) {
        try {
            this.project = project;
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            this.content = PomHelper.readXmlFile((File)project.getPom());
            this.eventReader = new ModifiedPomXMLEventReader(this.content, inputFactory, project.getPom().getPath());
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Couldn't initialize PomWriter instance", e);
        }
    }

    public void overrideDependencyVersion(Dependency d, String newVersion) throws XMLStreamException {
        PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)this.eventReader, (String)d.getGroupId(), (String)d.getArtifactId(), (String)d.getVersion(), (String)newVersion, (Model)this.project.getModel());
    }

    public boolean overrideProperty(String propertyName, String propertyValue) throws XMLStreamException {
        return PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)this.eventReader, null, (String)propertyName, (String)propertyValue);
    }

    public void writePom() {
        this.assertOpen();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)this.project.getPom());){
            this.closed = true;
            IOUtil.copy((String)this.content.toString(), (Writer)writer);
            this.eventReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to the pom file", e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't close event reader", e);
        }
    }

    private void assertOpen() {
        Asserts.check((!this.closed ? 1 : 0) != 0, (String)"This instance cannot be used repeatedly.");
    }

    static void injectManagedDependency(ModifiedPomXMLEventReader eventReader, MavenArtifact dep) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals(DEPENDENCIES) && ((String)path).equals(DEPENDENCY_MANAGEMENT_PATH)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, String.format("    <!-- dependency injected by wildfly-channel-maven-plugin -->\n            <dependency>\n                <groupId>%s</groupId>\n                <artifactId>%s</artifactId>\n                <version>%s</version>\n                <type>%s</type>\n            </dependency>\n        </dependencies>", dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getExtension()));
                eventReader.clearMark(0);
                break;
            }
            path = (String)stack.pop();
        }
    }
}

