/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.io.PomIO;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channelplugin.ChannelPluginLogger;
import org.wildfly.channelplugin.manipulation.PomManipulator;

@Mojo(name="inject-repositories", requiresProject=true, requiresDirectInvocation=true)
public class InjectRepositoriesMojo
extends AbstractMojo {
    @Parameter(required=true, property="fromChannelFile")
    String fromChannelFile;
    @Inject
    MavenSession mavenSession;
    @Inject
    MavenProject mavenProject;
    @Inject
    PomIO pomIO;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List channels;
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        Path channelFilePath = Path.of(this.fromChannelFile, new String[0]);
        if (!channelFilePath.isAbsolute()) {
            channelFilePath = Path.of(this.mavenSession.getExecutionRootDirectory(), new String[0]).resolve(channelFilePath);
        }
        this.getLog().info((CharSequence)("Reading channel file " + channelFilePath));
        try (InputStream is = channelFilePath.toUri().toURL().openStream();){
            channels = ChannelMapper.fromString((String)new String(is.readAllBytes()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't read channel file", (Exception)e);
        }
        try {
            Project project = this.parseRootProject();
            this.getLog().info((CharSequence)("Root project: " + project.getArtifactId()));
            PomManipulator manipulator = new PomManipulator(project);
            Set existingRepositories = project.getModel().getRepositories().stream().map(RepositoryBase::getUrl).collect(Collectors.toSet());
            channels.stream().flatMap(c -> c.getRepositories().stream()).distinct().forEach(r -> {
                if (!existingRepositories.contains(r.getUrl())) {
                    try {
                        this.getLog().info((CharSequence)("Inserting repository " + r.getUrl()));
                        manipulator.injectRepository(r.getId(), r.getUrl());
                    }
                    catch (XMLStreamException e) {
                        ChannelPluginLogger.LOGGER.errorf("Failed to inject repository: %s", (Object)e.getMessage());
                    }
                } else {
                    this.getLog().info((CharSequence)String.format("Repository with URL %s is already present.", r.getUrl()));
                }
            });
            manipulator.writePom();
        }
        catch (ManipulationException e) {
            throw new MojoExecutionException("Can't parse project POM files", (Exception)((Object)e));
        }
    }

    private Project parseRootProject() throws ManipulationException {
        return this.pomIO.parseProject(this.mavenProject.getModel().getPomFile()).stream().filter(Project::isExecutionRoot).findFirst().get();
    }
}

