/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractRunGoalsPhase;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.util.PomFinder;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ReleasePhase.class, hint="run-perform-goals")
public class RunPerformGoalsPhase
extends AbstractRunGoalsPhase {
    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        return this.runLogic(releaseDescriptor, releaseEnvironment, reactorProjects, false);
    }

    private ReleaseResult runLogic(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate) throws ReleaseExecutionException {
        File matchingPom;
        String pomFileName;
        String additionalArguments = this.getAdditionalArguments(releaseDescriptor);
        if (releaseDescriptor.isUseReleaseProfile()) {
            additionalArguments = !StringUtils.isEmpty(additionalArguments) ? additionalArguments + " -DperformRelease=true" : "-DperformRelease=true";
        }
        if ((pomFileName = releaseDescriptor.getPomFileName()) == null) {
            pomFileName = "pom.xml";
        }
        additionalArguments = !StringUtils.isEmpty(additionalArguments) ? additionalArguments + " -f " + pomFileName : "-f " + pomFileName;
        if (simulate) {
            ReleaseResult result = new ReleaseResult();
            this.logDebug(result, "Additional arguments: " + additionalArguments);
            this.logInfo(result, "Executing perform goals  - since this is simulation mode these goals are skipped.");
            return result;
        }
        String workDir = releaseDescriptor.getWorkingDirectory();
        if (workDir == null) {
            workDir = System.getProperty("user.dir");
        }
        File pomFile = new File(workDir, pomFileName);
        PomFinder pomFinder = new PomFinder(this.getLogger());
        boolean foundPom = false;
        if (StringUtils.isEmpty(releaseDescriptor.getScmRelativePathProjectDirectory())) {
            foundPom = pomFinder.parsePom(pomFile);
        }
        File workDirectory = new File(releaseDescriptor.getCheckoutDirectory());
        if (foundPom && (matchingPom = pomFinder.findMatchingPom(workDirectory)) != null) {
            this.getLogger().info("Invoking perform goals in directory " + matchingPom.getParent());
            workDirectory = matchingPom.getParentFile();
        }
        return this.execute(releaseDescriptor, releaseEnvironment, workDirectory, additionalArguments);
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        return this.runLogic(releaseDescriptor, releaseEnvironment, reactorProjects, true);
    }

    @Override
    protected String getGoals(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getPerformGoals();
    }
}

