/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.commonjava.maven.atlas.graph.rel.AbstractSimpleProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.ProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipConstants;
import org.commonjava.maven.atlas.graph.rel.RelationshipType;
import org.commonjava.maven.atlas.graph.rel.SimpleBomRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleExtensionRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleParentRelationship;
import org.commonjava.maven.atlas.graph.rel.SimplePluginDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.SimplePluginRelationship;
import org.commonjava.maven.atlas.ident.DependencyScope;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProjectRelationshipDeserializer<T extends ProjectRelationship>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;

    public ProjectRelationshipDeserializer() {
        super(ProjectRelationship.class);
    }

    @Override
    public T deserialize(JsonParser jp, DeserializationContext ctx) throws JsonProcessingException, IOException {
        URI pomLocation;
        HashMap<String, Object> ast = new HashMap<String, Object>();
        HashMap<String, JsonLocation> locations = new HashMap<String, JsonLocation>();
        JsonToken token = jp.getCurrentToken();
        String currentField = null;
        ArrayList<String> currentArry = null;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        do {
            switch (token) {
                case START_ARRAY: {
                    currentArry = new ArrayList<String>();
                    break;
                }
                case END_ARRAY: {
                    locations.put(currentField, jp.getCurrentLocation());
                    ast.put(currentField, currentArry);
                    currentArry = null;
                    break;
                }
                case FIELD_NAME: {
                    currentField = jp.getCurrentName();
                    break;
                }
                case VALUE_STRING: {
                    if (currentArry != null) {
                        currentArry.add(jp.getText());
                        break;
                    }
                    locations.put(currentField, jp.getCurrentLocation());
                    ast.put(currentField, jp.getText());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    locations.put(currentField, jp.getCurrentLocation());
                    ast.put(currentField, jp.getIntValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    locations.put(currentField, jp.getCurrentLocation());
                    ast.put(currentField, Float.valueOf(jp.getFloatValue()));
                    break;
                }
                case VALUE_TRUE: {
                    locations.put(currentField, jp.getCurrentLocation());
                    ast.put(currentField, Boolean.TRUE);
                    break;
                }
                case VALUE_FALSE: {
                    locations.put(currentField, jp.getCurrentLocation());
                    ast.put(currentField, Boolean.FALSE);
                }
            }
        } while ((token = jp.nextToken()) != JsonToken.END_OBJECT);
        StringBuilder sb = new StringBuilder();
        sb.append("AST is:");
        for (String field : ast.keySet()) {
            Object value = ast.get(field);
            sb.append("\n  ").append(field).append(" = ");
            if (value == null) {
                sb.append("null");
                continue;
            }
            sb.append(value).append("  (type: ").append(value.getClass().getSimpleName()).append(")");
        }
        logger.debug(sb.toString());
        RelationshipType type = RelationshipType.getType((String)ast.get("type"));
        String uri = (String)ast.get("pom-location-uri");
        if (uri == null) {
            pomLocation = RelationshipConstants.POM_ROOT_URI;
        } else {
            try {
                pomLocation = new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new JsonParseException("Invalid pom-location-uri: '" + uri + "': " + e.getMessage(), (JsonLocation)locations.get("pom-location-uri"), (Throwable)e);
            }
        }
        HashSet<URI> sources = new HashSet<URI>();
        List srcs = (List)ast.get("source-uris");
        if (srcs != null) {
            for (String u : srcs) {
                try {
                    sources.add(new URI(u));
                }
                catch (URISyntaxException e) {
                    throw new JsonParseException("Failed to parse source URI: " + u, (JsonLocation)locations.get("source-uris"));
                }
            }
        }
        String decl = (String)ast.get("declaring");
        ProjectVersionRef declaring = SimpleProjectVersionRef.parse(decl);
        String tgt = (String)ast.get("target");
        Integer index = (Integer)ast.get("idx");
        if (index == null) {
            index = 0;
        }
        boolean managed = Boolean.TRUE.equals(ast.get("managed"));
        boolean inherited = Boolean.TRUE.equals(ast.get("inherited"));
        boolean mixin = Boolean.TRUE.equals(ast.get("mixin"));
        boolean optional = Boolean.TRUE.equals(ast.get("optional"));
        AbstractSimpleProjectRelationship rel = null;
        switch (type) {
            case DEPENDENCY: {
                SimpleArtifactRef target = SimpleArtifactRef.parse(tgt);
                String scp = (String)ast.get("scope");
                DependencyScope scope = scp == null ? DependencyScope.compile : DependencyScope.getScope(scp);
                rel = new SimpleDependencyRelationship(sources, pomLocation, declaring, (ArtifactRef)target, scope, (int)index, managed, inherited, optional, new ProjectRef[0]);
                break;
            }
            case EXTENSION: {
                ProjectVersionRef target = SimpleProjectVersionRef.parse(tgt);
                rel = new SimpleExtensionRelationship(sources, pomLocation, declaring, target, (int)index, inherited);
                break;
            }
            case PARENT: {
                ProjectVersionRef target = SimpleProjectVersionRef.parse(tgt);
                rel = new SimpleParentRelationship(sources, declaring, target);
                break;
            }
            case PLUGIN: {
                ProjectVersionRef target = SimpleProjectVersionRef.parse(tgt);
                Boolean report = (Boolean)ast.get("reporting");
                rel = new SimplePluginRelationship(sources, pomLocation, declaring, target, (int)index, managed, Boolean.TRUE.equals(report), inherited);
                break;
            }
            case PLUGIN_DEP: {
                String plug = (String)ast.get("plugin");
                if (plug == null) {
                    throw new JsonParseException("No plugin reference (field: plugin) found in plugin-dependency relationship!", jp.getCurrentLocation());
                }
                ProjectRef plugin = SimpleProjectRef.parse(plug);
                SimpleArtifactRef target = SimpleArtifactRef.parse(tgt);
                rel = new SimplePluginDependencyRelationship(sources, pomLocation, declaring, plugin, (ArtifactRef)target, (int)index, managed, inherited);
                break;
            }
            case BOM: {
                ProjectVersionRef target = SimpleProjectVersionRef.parse(tgt);
                rel = new SimpleBomRelationship(sources, pomLocation, declaring, target, (int)index, inherited, mixin);
                break;
            }
        }
        return (T)rel;
    }
}

