/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.util;

import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.atlas.ident.version.RangeVersionSpec;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.atlas.ident.version.VersionSpec;
import org.commonjava.maven.atlas.ident.version.parse.ParseException;
import org.commonjava.maven.atlas.ident.version.parse.TokenMgrError;
import org.commonjava.maven.atlas.ident.version.parse.VersionParser;

public final class VersionUtils {
    private VersionUtils() {
    }

    public static VersionSpec createFromSpec(String version) throws InvalidVersionSpecificationException {
        VersionUtils.checkEmpty(version);
        try {
            VersionSpec spec = new VersionParser(version).parse();
            if (spec == null) {
                throw new InvalidVersionSpecificationException(version, "Parsed VersionSpec is null.", new Object[0]);
            }
            return spec;
        }
        catch (ParseException e) {
            throw new InvalidVersionSpecificationException(version, "Failed to parse version: %s", e, e.getMessage());
        }
        catch (TokenMgrError e) {
            throw new InvalidVersionSpecificationException(version, "Failed to parse version: %s", e, e.getMessage());
        }
    }

    private static void checkEmpty(String version) throws InvalidVersionSpecificationException {
        if (version == null || version.trim().length() < 1) {
            throw new InvalidVersionSpecificationException(version, "Valid versions cannot be null or empty", new Object[0]);
        }
    }

    public static RangeVersionSpec createRange(String version) throws InvalidVersionSpecificationException {
        VersionUtils.checkEmpty(version);
        try {
            return new VersionParser(version).range();
        }
        catch (ParseException e) {
            throw new InvalidVersionSpecificationException(version, "Failed to parse version range: %s", e, e.getMessage());
        }
        catch (TokenMgrError e) {
            throw new InvalidVersionSpecificationException(version, "Failed to parse version range: %s", e, e.getMessage());
        }
    }

    public static SingleVersion createSingleVersion(String version) throws InvalidVersionSpecificationException {
        VersionUtils.checkEmpty(version);
        try {
            return new VersionParser(version).single();
        }
        catch (ParseException e) {
            throw new InvalidVersionSpecificationException(version, "Failed to parse single version: %s", e, e.getMessage());
        }
        catch (TokenMgrError e) {
            throw new InvalidVersionSpecificationException(version, "Failed to parse single version: %s", e, e.getMessage());
        }
    }
}

