/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.File;
import java.io.IOException;
import kong.unirest.jackson.JacksonObjectMapper;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.json.DependencyAnalyserResult;
import org.commonjava.maven.ext.common.json.PME;
import org.jboss.da.model.rest.GAV;

public class JSONUtils {
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String BEST_MATCH_VERSION = "bestMatchVersion";
    private static final String LATEST_VERSION = "latestVersion";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String jsonToString(Object jsonReport) throws IOException {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(jsonReport);
    }

    public static PME fileToJSON(File jsonFile) throws IOException {
        return MAPPER.readValue(jsonFile, PME.class);
    }

    static {
        MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public static class InternalObjectMapper
    extends JacksonObjectMapper {
        public InternalObjectMapper(ObjectMapper mapper) {
            super(mapper);
            mapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            SimpleModule module = new SimpleModule();
            module.addDeserializer(ProjectVersionRef.class, new ProjectVersionRefDeserializer());
            module.addSerializer(ProjectVersionRef.class, new ProjectVersionRefSerializer());
            module.addDeserializer(DependencyAnalyserResult.class, new MavenResultDeserializer());
            mapper.registerModule(module);
        }
    }

    public static class MavenResultDeserializer
    extends JsonDeserializer<DependencyAnalyserResult> {
        @Override
        public DependencyAnalyserResult deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String groupId = node.get(JSONUtils.GROUP_ID).asText();
            String artifactId = node.get(JSONUtils.ARTIFACT_ID).asText();
            String version = node.get(JSONUtils.VERSION).asText();
            DependencyAnalyserResult result = new DependencyAnalyserResult();
            result.setGav(new GAV(groupId, artifactId, version));
            if (node.has(JSONUtils.BEST_MATCH_VERSION) && !node.get(JSONUtils.BEST_MATCH_VERSION).getNodeType().equals((Object)JsonNodeType.NULL)) {
                result.setBestMatchVersion(node.get(JSONUtils.BEST_MATCH_VERSION).asText());
            }
            if (node.has(JSONUtils.LATEST_VERSION) && !node.get(JSONUtils.LATEST_VERSION).getNodeType().equals((Object)JsonNodeType.NULL)) {
                result.setLatestVersion(node.get(JSONUtils.LATEST_VERSION).asText());
            }
            result.setProjectVersionRef(new SimpleProjectVersionRef(groupId, artifactId, version));
            return result;
        }
    }

    public static class ProjectVersionRefSerializer
    extends JsonSerializer<ProjectVersionRef> {
        @Override
        public void serialize(ProjectVersionRef value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField(JSONUtils.GROUP_ID, value.getGroupId());
            gen.writeStringField(JSONUtils.ARTIFACT_ID, value.getArtifactId());
            gen.writeStringField(JSONUtils.VERSION, value.getVersionString());
            gen.writeEndObject();
        }
    }

    public static class ProjectVersionRefDeserializer
    extends JsonDeserializer<ProjectVersionRef> {
        @Override
        public ProjectVersionRef deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String groupId = node.get(JSONUtils.GROUP_ID).asText();
            String artifactId = node.get(JSONUtils.ARTIFACT_ID).asText();
            String version = node.get(JSONUtils.VERSION).asText();
            return new SimpleProjectVersionRef(groupId, artifactId, version);
        }
    }
}

