/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.json.ManagedDependenciesItem;
import org.commonjava.maven.ext.common.json.ManagedPluginsItem;
import org.commonjava.maven.ext.common.json.ModulesItem;
import org.commonjava.maven.ext.common.json.PME;
import org.commonjava.maven.ext.common.json.ProfileItem;
import org.commonjava.maven.ext.common.json.PropertiesItem;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.slf4j.helpers.MessageFormatter;

public class ProjectComparator {
    public static final String REPORT_NON_ALIGNED = "reportNonAligned";
    private static final AtomicBoolean spacerLine = new AtomicBoolean();

    public static String compareProjects(MavenSessionHandler session, PME jsonReport, WildcardMap<ProjectVersionRef> dependencyRelocations, List<Project> originalProjects, List<Project> newProjects) throws ManipulationException {
        boolean reportNonAligned = Boolean.parseBoolean(session.getUserProperties().getProperty(REPORT_NON_ALIGNED, "false"));
        StringBuilder builder = new StringBuilder(500);
        List<ModulesItem> modules = jsonReport.getModules();
        try {
            newProjects.forEach(newProject -> originalProjects.stream().filter(originalProject -> newProject.getArtifactId().equals(originalProject.getArtifactId()) && newProject.getGroupId().equals(originalProject.getGroupId())).forEach(originalProject -> {
                ModulesItem module = new ModulesItem();
                modules.add(module);
                module.getGav().setOriginalGAV(originalProject.getKey().toString());
                module.getGav().setPVR(newProject.getKey());
                ProjectComparator.append(builder, "------------------- project {}", newProject.getKey().asProjectRef());
                if (!originalProject.getVersion().equals(newProject.getVersion())) {
                    ProjectComparator.append(builder, "\tProject version : {} --> {}", originalProject.getVersion(), newProject.getVersion());
                    spacerLine.set(true);
                }
                ProjectComparator.injectSpacerLine(builder);
                newProject.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(nKey, nValue) -> originalProject.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(oKey, oValue) -> {
                    if (oKey != null && oKey.equals(nKey) && oValue != null && !oValue.equals(nValue)) {
                        module.getProperties().put(oKey.toString(), new PropertiesItem(oValue.toString(), nValue.toString()));
                        ProjectComparator.append(builder, "\tProperty : key {} ; value {} --> {}", oKey, oValue, nValue);
                        spacerLine.set(true);
                    }
                }))));
                ProjectComparator.injectSpacerLine(builder);
                ProjectComparator.compareDependencies(Type.DEPENDENCIES, module.getDependencies(), builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, null, Type.DEPENDENCIES));
                ProjectComparator.injectSpacerLine(builder);
                ManagedDependenciesItem mgdDeps = new ManagedDependenciesItem();
                module.setManagedDependencies(mgdDeps);
                ProjectComparator.compareDependencies(Type.MANAGED_DEPENDENCIES, mgdDeps.getDependencies(), builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.MANAGED_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, null, Type.MANAGED_DEPENDENCIES));
                ProjectComparator.injectSpacerLine(builder);
                ProjectComparator.compareDependencies(Type.DEPENDENCIES_UNVERSIONED, module.getDependencies(), builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, null, Type.DEPENDENCIES_UNVERSIONED), ProjectComparator.handleDependencies(session, newProject, null, Type.DEPENDENCIES_UNVERSIONED));
                ProjectComparator.injectSpacerLine(builder);
                ProjectComparator.comparePlugins(Type.PLUGINS, module.getPlugins(), builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, null, Type.PLUGINS), ProjectComparator.handlePlugins(session, newProject, null, Type.PLUGINS));
                ManagedPluginsItem mgdPlugins = new ManagedPluginsItem();
                module.setManagedPlugins(mgdPlugins);
                ProjectComparator.comparePlugins(Type.MANAGED_PLUGINS, mgdPlugins.getPlugins(), builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, null, Type.MANAGED_PLUGINS), ProjectComparator.handlePlugins(session, newProject, null, Type.MANAGED_PLUGINS));
                List<Profile> oldProfiles = ProfileUtils.getProfiles(session, originalProject.getModel());
                List<Profile> newProfiles = ProfileUtils.getProfiles(session, newProject.getModel());
                newProfiles.forEach(newProfile -> oldProfiles.stream().filter(oldProfile -> newProfile.getId().equals(oldProfile.getId())).forEach(oldProfile -> {
                    ProfileItem profileItem = new ProfileItem();
                    profileItem.setId(newProfile.getId());
                    module.getProfiles().add(profileItem);
                    newProfile.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(nKey, nValue) -> oldProfile.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(oKey, oValue) -> {
                        if (oKey != null && oKey.equals(nKey) && oValue != null && !oValue.equals(nValue)) {
                            ProjectComparator.append(builder, "\tProfile property : key {} ; value {} --> {}", oKey, oValue, nValue);
                            spacerLine.set(true);
                        }
                    }))));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.compareDependencies(Type.PROFILE_DEPENDENCIES, profileItem.getDependencies(), builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_DEPENDENCIES));
                    ProjectComparator.injectSpacerLine(builder);
                    ManagedDependenciesItem mgdProfileDeps = new ManagedDependenciesItem();
                    profileItem.getManagedDependencies().add(mgdProfileDeps);
                    ProjectComparator.compareDependencies(Type.PROFILE_MANAGED_DEPENDENCIES, mgdProfileDeps.getDependencies(), builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_MANAGED_DEPENDENCIES), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_MANAGED_DEPENDENCIES));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.compareDependencies(Type.PROFILE_DEPENDENCIES_UNVERSIONED, profileItem.getDependencies(), builder, dependencyRelocations, reportNonAligned, ProjectComparator.handleDependencies(session, originalProject, oldProfile, Type.PROFILE_DEPENDENCIES_UNVERSIONED), ProjectComparator.handleDependencies(session, newProject, newProfile, Type.PROFILE_DEPENDENCIES_UNVERSIONED));
                    ProjectComparator.injectSpacerLine(builder);
                    ProjectComparator.comparePlugins(Type.PROFILE_PLUGINS, profileItem.getPlugins(), builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, oldProfile, Type.PROFILE_PLUGINS), ProjectComparator.handlePlugins(session, newProject, newProfile, Type.PROFILE_PLUGINS));
                    ProjectComparator.injectSpacerLine(builder);
                    ManagedPluginsItem mgdProfilePlugins = new ManagedPluginsItem();
                    module.setManagedPlugins(mgdProfilePlugins);
                    ProjectComparator.comparePlugins(Type.PROFILE_MANAGED_PLUGINS, mgdProfilePlugins.getPlugins(), builder, reportNonAligned, ProjectComparator.handlePlugins(session, originalProject, oldProfile, Type.PROFILE_MANAGED_PLUGINS), ProjectComparator.handlePlugins(session, newProject, newProfile, Type.PROFILE_MANAGED_PLUGINS));
                }));
            }));
            return builder.toString();
        }
        catch (ManipulationUncheckedException e) {
            throw (ManipulationException)e.getCause();
        }
    }

    private static void compareDependencies(Type type, Map<String, ProjectVersionRef> alignedDependencies, StringBuilder builder, WildcardMap<ProjectVersionRef> dependencyRelocations, boolean reportNonAligned, Set<ArtifactRef> originalDeps, Set<ArtifactRef> newDeps) {
        HashSet nonAligned = new HashSet();
        if (dependencyRelocations.size() > 0 && type == Type.PROFILE_DEPENDENCIES_UNVERSIONED || type == Type.DEPENDENCIES_UNVERSIONED) {
            originalDeps.forEach(originalDep -> {
                ProjectRef orig = originalDep.asProjectRef();
                if (dependencyRelocations.containsKey(orig)) {
                    ProjectVersionRef p = (ProjectVersionRef)dependencyRelocations.get(orig);
                    SimpleProjectVersionRef n = new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId().equals("*") ? orig.getArtifactId() : p.getArtifactId(), p.getVersionString());
                    alignedDependencies.put(originalDep.asProjectVersionRef().toString(), n);
                    ProjectComparator.append(builder, "\tUnversioned relocation : {} --> {}", originalDep, n);
                    spacerLine.set(true);
                }
            });
            ProjectComparator.injectSpacerLine(builder);
        } else {
            originalDeps.forEach(originalArtifact -> newDeps.stream().filter(newArtifact -> newArtifact.getGroupId().equals(originalArtifact.getGroupId()) && newArtifact.getArtifactId().equals(originalArtifact.getArtifactId()) && newArtifact.getType().equals(originalArtifact.getType()) && StringUtils.equals(newArtifact.getClassifier(), originalArtifact.getClassifier())).forEach(newArtifact -> {
                if (!newArtifact.getVersionString().equals(originalArtifact.getVersionString())) {
                    alignedDependencies.put(originalArtifact.asProjectVersionRef().toString(), newArtifact.asProjectVersionRef());
                    ProjectComparator.append(builder, "\t{} : {} --> {}", new Object[]{type, originalArtifact, newArtifact});
                    spacerLine.set(true);
                } else if (reportNonAligned) {
                    nonAligned.add(originalArtifact);
                }
            }));
            if (dependencyRelocations.size() > 0) {
                ProjectComparator.injectSpacerLine(builder);
                originalDeps.forEach(originalDep -> {
                    ProjectRef orig = originalDep.asProjectRef();
                    if (dependencyRelocations.containsKey(orig)) {
                        ProjectVersionRef p = (ProjectVersionRef)dependencyRelocations.get(orig);
                        ProjectComparator.append(builder, "\tRelocation : {} --> {}:{}:{}", originalDep, p.getGroupId(), p.getArtifactId().equals("*") ? orig.getArtifactId() : p.getArtifactId(), p.getVersionString());
                        spacerLine.set(true);
                    }
                });
            }
        }
        if (nonAligned.size() > 0) {
            nonAligned.forEach(na -> ProjectComparator.append(builder, "\tNon-Aligned {} : {}", new Object[]{type, na}));
            builder.append(System.lineSeparator());
        }
    }

    private static void comparePlugins(Type type, Map<String, ProjectVersionRef> plugins, StringBuilder builder, boolean reportNonAligned, Set<ProjectVersionRef> originalPlugins, Set<ProjectVersionRef> newPlugins) {
        HashSet nonAligned = new HashSet();
        AtomicBoolean spacerLine = new AtomicBoolean();
        originalPlugins.forEach(originalPVR -> newPlugins.stream().filter(newPVR -> newPVR.getGroupId().equals(originalPVR.getGroupId()) && newPVR.getArtifactId().equals(originalPVR.getArtifactId())).forEach(newArtifact -> {
            if (!newArtifact.getVersionString().equals(originalPVR.getVersionString())) {
                plugins.put(originalPVR.toString(), (ProjectVersionRef)newArtifact);
                ProjectComparator.append(builder, "\t{} : {} --> {}", new Object[]{type, originalPVR, newArtifact});
                spacerLine.set(true);
            } else if (reportNonAligned) {
                nonAligned.add(originalPVR);
            }
        }));
        if (nonAligned.size() > 0) {
            nonAligned.forEach(pv -> ProjectComparator.append(builder, "\tNon-Aligned {} : {}", new Object[]{type, pv}));
            builder.append(System.lineSeparator());
        }
    }

    private static void injectSpacerLine(StringBuilder builder) {
        if (spacerLine.get()) {
            builder.append(System.lineSeparator());
            spacerLine.set(false);
        }
    }

    private static void append(StringBuilder builder, String message, Object ... args) {
        builder.append(MessageFormatter.arrayFormat(message, args).getMessage());
        builder.append(System.lineSeparator());
    }

    private static Set<ArtifactRef> handleDependencies(MavenSessionHandler session, Project project, Profile profile, Type type) throws ManipulationUncheckedException {
        try {
            switch (type) {
                case DEPENDENCIES: {
                    return project.getResolvedDependencies(session).keySet();
                }
                case MANAGED_DEPENDENCIES: {
                    return project.getResolvedManagedDependencies(session).keySet();
                }
                case PROFILE_DEPENDENCIES: {
                    return project.getResolvedProfileDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case PROFILE_MANAGED_DEPENDENCIES: {
                    return project.getResolvedProfileManagedDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case DEPENDENCIES_UNVERSIONED: {
                    return project.getAllResolvedDependencies(session).keySet().stream().filter(a -> a.getVersionString().equals("*")).collect(Collectors.toSet());
                }
                case PROFILE_DEPENDENCIES_UNVERSIONED: {
                    return project.getAllResolvedProfileDependencies(session).getOrDefault(profile, Collections.emptyMap()).keySet().stream().filter(a -> a.getVersionString().equals("*")).collect(Collectors.toSet());
                }
            }
            throw new ManipulationException("Invalid type {}", new Object[]{type});
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    private static Set<ProjectVersionRef> handlePlugins(MavenSessionHandler session, Project project, Profile profile, Type type) throws ManipulationUncheckedException {
        try {
            switch (type) {
                case PLUGINS: {
                    return project.getResolvedPlugins(session).keySet();
                }
                case MANAGED_PLUGINS: {
                    return project.getResolvedManagedPlugins(session).keySet();
                }
                case PROFILE_PLUGINS: {
                    return project.getResolvedProfilePlugins(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
                case PROFILE_MANAGED_PLUGINS: {
                    return project.getResolvedProfileManagedPlugins(session).getOrDefault(profile, Collections.emptyMap()).keySet();
                }
            }
            throw new ManipulationException("Invalid type {}", new Object[]{type});
        }
        catch (ManipulationException e) {
            throw new ManipulationUncheckedException(e);
        }
    }

    static enum Type {
        DEPENDENCIES,
        DEPENDENCIES_UNVERSIONED,
        MANAGED_DEPENDENCIES,
        PROFILE_DEPENDENCIES,
        PROFILE_DEPENDENCIES_UNVERSIONED,
        PROFILE_MANAGED_DEPENDENCIES,
        PLUGINS,
        MANAGED_PLUGINS,
        PROFILE_PLUGINS,
        PROFILE_MANAGED_PLUGINS;


        public String toString() {
            switch (this) {
                case DEPENDENCIES: {
                    return "Dependencies";
                }
                case DEPENDENCIES_UNVERSIONED: {
                    return "Non-versioned dependencies";
                }
                case MANAGED_DEPENDENCIES: {
                    return "Managed dependencies";
                }
                case PROFILE_DEPENDENCIES: {
                    return "Profile dependencies";
                }
                case PROFILE_DEPENDENCIES_UNVERSIONED: {
                    return "Profile non-versioned dependencies";
                }
                case PROFILE_MANAGED_DEPENDENCIES: {
                    return "Profile managed dependencies";
                }
                case PLUGINS: {
                    return "Plugins";
                }
                case MANAGED_PLUGINS: {
                    return "Managed plugins";
                }
                case PROFILE_PLUGINS: {
                    return "Profile plugins";
                }
                case PROFILE_MANAGED_PLUGINS: {
                    return "Profile managed plugins";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

