/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import org.commonjava.maven.galley.filearc.internal.util.ZipUtils;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractZipOperation {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Location location;
    private final String path;
    private final File zipFile;
    private final String basePath;
    private final String fullPath;
    protected Transfer transfer;
    protected ConcreteResource resource;

    protected AbstractZipOperation(Transfer transfer) {
        this(transfer.getLocation(), transfer.getPath());
        this.transfer = transfer;
    }

    protected AbstractZipOperation(ConcreteResource resource) {
        this(resource.getLocation(), resource.getPath());
        this.resource = resource;
    }

    protected AbstractZipOperation(Location location, String path) {
        this.location = location;
        this.path = path;
        String uri = location.getUri();
        this.zipFile = ZipUtils.getArchiveFile(uri);
        String basePath = ZipUtils.getArchivePath(uri);
        if (basePath == null) {
            basePath = "";
        }
        this.basePath = basePath;
        String fp = PathUtils.normalize(basePath, path);
        if (fp.startsWith("/")) {
            fp = fp.substring(1);
        }
        this.fullPath = fp;
        this.logger.debug("Got archive reference with the following:\n  File: {}\n  Base-Path: {}\n  Full-Path: {}\n", this.zipFile, basePath, this.fullPath);
    }

    public String toString() {
        return String.format("%s [file: %s, base-path: %s, full-path: %s]", this.getClass().getSimpleName(), this.zipFile, this.basePath, this.fullPath);
    }

    protected ConcreteResource getResource() {
        return this.resource;
    }

    protected Transfer getTransfer() {
        return this.transfer;
    }

    protected boolean isJarOperation() {
        return ZipUtils.isJar(this.location.getUri());
    }

    protected String getFullPath() {
        return this.fullPath;
    }

    protected Location getLocation() {
        return this.location;
    }

    protected String getPath() {
        return this.path;
    }

    protected File getZipFile() {
        return this.zipFile;
    }

    protected String getBasePath() {
        return this.basePath;
    }
}

